/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.minecart;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.RailUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.Material;
import org.bukkit.entity.Minecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.util.Vector;

public class ConstantSpeed
extends AbstractCraftBookMechanic {
    private double speed;
    private boolean ignorePoweredRail;

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleMove(VehicleMoveEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!(event.getVehicle() instanceof Minecart)) {
            return;
        }
        if (RailUtil.isTrack(event.getTo().getBlock().getType()) && event.getVehicle().getVelocity().lengthSquared() > 0.0) {
            if (event.getTo().getBlock().getType() == Material.POWERED_RAIL && !this.ignorePoweredRail && (event.getTo().getBlock().getData() & 8) == 0) {
                return;
            }
            Vector vel = event.getVehicle().getVelocity();
            event.getVehicle().setVelocity(vel.normalize().multiply(this.speed));
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "speed", "Sets the speed to move at constantly.");
        this.speed = config.getDouble(path + "speed", 0.5);
        config.setComment(path + "ignore-powered-rail", "Whether or not powered rails should be ignored.");
        this.ignorePoweredRail = config.getBoolean(path + "ignore-powered-rail", false);
    }
}

