/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.items;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.items.ClickType;
import com.sk89q.craftbook.mechanics.items.CommandItemAction;
import com.sk89q.craftbook.mechanics.items.CommandItemDefinition;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.LoadPriority;
import com.sk89q.craftbook.util.ParsingUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.craftbook.util.Tuple2;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class CommandItems
extends AbstractCraftBookMechanic {
    public static CommandItems INSTANCE;
    private YAMLProcessor config;
    private Set<CommandItemDefinition> definitions;
    private Map<Tuple2<String, String>, Integer> cooldownPeriods;
    private Map<UUID, List<ItemStack>> deathPersistItems = Maps.newHashMap();

    public CommandItemDefinition getDefinitionByName(String name) {
        for (CommandItemDefinition def : this.definitions) {
            if (!def.name.equalsIgnoreCase(name)) continue;
            return def;
        }
        return null;
    }

    @Override
    public void disable() {
        for (Map.Entry<UUID, List<ItemStack>> deathPersistEntry : this.deathPersistItems.entrySet()) {
            Map items = (Map)CraftBookPlugin.inst().getPersistentStorage().get("command-items.death-items");
            ArrayList<String> its = (ArrayList<String>)items.get(deathPersistEntry.getKey().toString());
            if (its == null) {
                its = new ArrayList<String>();
            }
            for (ItemStack stack : deathPersistEntry.getValue()) {
                its.add(ItemSyntax.getStringFromItem(stack));
            }
            items.put(deathPersistEntry.getKey().toString(), its);
            CraftBookPlugin.inst().getPersistentStorage().set("command-items.death-items", items);
        }
        this.definitions = null;
        this.cooldownPeriods = null;
        this.config = null;
        INSTANCE = null;
    }

    @Override
    public boolean enable() {
        INSTANCE = this;
        this.definitions = new HashSet<CommandItemDefinition>();
        this.cooldownPeriods = new HashMap<Tuple2<String, String>, Integer>();
        CraftBookPlugin.inst().createDefaultConfiguration(new File(CraftBookPlugin.inst().getDataFolder(), "command-items.yml"), "command-items.yml");
        this.config = new YAMLProcessor(new File(CraftBookPlugin.inst().getDataFolder(), "command-items.yml"), false, YAMLFormat.EXTENDED);
        try {
            this.config.load();
        }
        catch (IOException e) {
            CraftBookPlugin.logger().severe("Corrupt CommandItems command-items.yml File! Make sure that the correct syntax has been used, and that there are no tabs!");
            CraftBookBukkitUtil.printStacktrace(e);
            return false;
        }
        int amount = 0;
        for (String key : this.config.getKeys("command-items")) {
            CommandItemDefinition comdef = CommandItemDefinition.load(this.config, "command-items." + key);
            if (this.addDefinition(comdef)) {
                CraftBookPlugin.logDebugMessage("Added CommandItem: " + key, "command-items.initialize");
                ++amount;
                continue;
            }
            CraftBookPlugin.logger().warning("Failed to add CommandItem: " + key);
        }
        if (amount == 0) {
            return false;
        }
        this.config.save();
        CraftBookPlugin.logger().info("Successfully added " + amount + " CommandItems!");
        if (this.definitions.size() > 0) {
            Bukkit.getScheduler().runTaskTimer((Plugin)CraftBookPlugin.inst(), () -> {
                Iterator<Map.Entry<Tuple2<String, String>, Integer>> iterator = this.cooldownPeriods.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Tuple2<String, String>, Integer> entry = iterator.next();
                    if (entry.getValue() > 1) {
                        this.cooldownPeriods.put(entry.getKey(), entry.getValue() - 1);
                        continue;
                    }
                    iterator.remove();
                }
            }, 0L, 20L);
            Bukkit.getScheduler().runTaskTimer((Plugin)CraftBookPlugin.inst(), () -> {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.getInventory().getItemInMainHand() != null) {
                        this.performCommandItems(player.getInventory().getItemInMainHand(), player, null);
                    }
                    if (player.getInventory().getItemInOffHand() != null) {
                        this.performCommandItems(player.getInventory().getItemInOffHand(), player, null);
                    }
                    for (ItemStack stack : player.getInventory().getArmorContents()) {
                        if (stack == null) continue;
                        this.performCommandItems(stack, player, null);
                    }
                }
            }, 10L, 10L);
        }
        if (!CraftBookPlugin.inst().getPersistentStorage().has("command-items.death-items")) {
            CraftBookPlugin.inst().getPersistentStorage().set("command-items.death-items", new HashMap());
        } else {
            Map items = (Map)CraftBookPlugin.inst().getPersistentStorage().get("command-items.death-items");
            for (Map.Entry entry : items.entrySet()) {
                UUID uuid = UUID.fromString((String)entry.getKey());
                ArrayList its = Lists.newArrayList();
                for (String item : (List)entry.getValue()) {
                    its.add(ItemSyntax.getItem(item));
                }
                this.deathPersistItems.put(uuid, its);
            }
            items.clear();
            CraftBookPlugin.inst().getPersistentStorage().set("command-items.death-items", items);
        }
        return true;
    }

    public boolean addDefinition(CommandItemDefinition def) {
        return this.definitions.add(def);
    }

    public void save() {
        this.config.addNode("command-items");
        for (CommandItemDefinition def : this.definitions) {
            this.config.addNode("command-items." + def.name);
            def.save(this.config, "command-items." + def.name);
        }
        this.config.save();
        this.disable();
        this.enable();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getItem() == null) {
            return;
        }
        if (event.getAction() == Action.PHYSICAL) {
            return;
        }
        this.performCommandItems(event.getItem(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerHitEntity(PlayerInteractEntityEvent event) {
        if (event.getPlayer().getItemInHand() == null) {
            return;
        }
        this.performCommandItems(event.getPlayer().getItemInHand(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamageEntity(EntityDamageByEntityEvent event) {
        Player p;
        if (event.getDamager() instanceof Projectile) {
            if (!(((Projectile)event.getDamager()).getShooter() instanceof Player)) {
                return;
            }
            p = (Player)((Projectile)event.getDamager()).getShooter();
        } else {
            if (!(event.getDamager() instanceof Player)) {
                return;
            }
            p = (Player)event.getDamager();
        }
        if (p.getItemInHand() == null) {
            return;
        }
        this.performCommandItems(p.getItemInHand(), p, (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getPlayer().getItemInHand() == null) {
            return;
        }
        this.performCommandItems(event.getPlayer().getItemInHand(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (!(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        if (((Player)event.getEntity().getShooter()).getItemInHand() == null) {
            return;
        }
        ItemStack item = ((Player)event.getEntity().getShooter()).getItemInHand();
        Player shooter = (Player)event.getEntity().getShooter();
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> this.performCommandItems(item, shooter, (Event)event), 5L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onProjectileHit(ProjectileHitEvent event) {
        if (!(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        if (((Player)event.getEntity().getShooter()).getItemInHand() == null) {
            return;
        }
        ItemStack item = ((Player)event.getEntity().getShooter()).getItemInHand();
        Player shooter = (Player)event.getEntity().getShooter();
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> this.performCommandItems(item, shooter, (Event)event), 5L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.getItemInHand() == null) {
            return;
        }
        this.performCommandItems(event.getItemInHand(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemConsume(PlayerItemConsumeEvent event) {
        if (event.getItem() == null) {
            return;
        }
        this.performCommandItems(event.getItem(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemDrop(PlayerDropItemEvent event) {
        if (event.getItemDrop() == null || !ItemUtil.isStackValid(event.getItemDrop().getItemStack())) {
            return;
        }
        this.performCommandItems(event.getItemDrop().getItemStack(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemBreak(PlayerItemBreakEvent event) {
        if (event.getBrokenItem() == null) {
            return;
        }
        this.performCommandItems(event.getBrokenItem(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemPickup(EntityPickupItemEvent event) {
        if (event.getItem() == null) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            this.performCommandItems(event.getItem().getItemStack(), (Player)event.getEntity(), (Event)event);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Iterator stackIt = event.getDrops().iterator();
        block0: while (stackIt.hasNext()) {
            ItemStack stack = (ItemStack)stackIt.next();
            this.performCommandItems(stack, event.getEntity(), (Event)event);
            for (CommandItemDefinition def : this.definitions) {
                if (!ItemUtil.areItemsIdentical(stack, def.getItem()) || !def.keepOnDeath) continue;
                ArrayList items = this.deathPersistItems.get(event.getEntity().getUniqueId());
                if (items == null) {
                    items = Lists.newArrayList();
                }
                items.add(stack);
                this.deathPersistItems.put(event.getEntity().getUniqueId(), items);
                stackIt.remove();
                continue block0;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerItemClick(InventoryClickEvent event) {
        if (event.getCurrentItem() == null || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        this.performCommandItems(event.getCurrentItem(), (Player)event.getWhoClicked(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (event.getPlayer().getItemInHand() == null) {
            return;
        }
        this.performCommandItems(event.getPlayer().getItemInHand(), event.getPlayer(), (Event)event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (!this.deathPersistItems.containsKey(event.getPlayer().getUniqueId())) {
            return;
        }
        List<ItemStack> its = this.deathPersistItems.get(event.getPlayer().getUniqueId());
        for (ItemStack it : its) {
            event.getPlayer().getInventory().addItem(new ItemStack[]{it});
        }
        this.deathPersistItems.remove(event.getPlayer().getUniqueId());
    }

    public void performCommandItems(ItemStack item, Player player, Event event) {
        if (event == null || !EventUtil.passesFilter(event)) {
            return;
        }
        CraftBookPlayer lplayer = CraftBookPlugin.inst().wrapPlayer(player);
        block0: for (CommandItemDefinition def : this.definitions) {
            int amount;
            boolean found;
            if (!ItemUtil.areItemsIdentical(def.stack, item)) continue;
            CommandItemDefinition comdef = def;
            if (!comdef.clickType.doesPassType(event) || !comdef.requireSneaking.doesPass(lplayer.isSneaking())) continue;
            if (!lplayer.hasPermission("craftbook.mech.commanditems") || comdef.permNode != null && !comdef.permNode.isEmpty() && !lplayer.hasPermission(comdef.permNode)) {
                if (!CraftBookPlugin.inst().getConfiguration().showPermissionMessages) continue;
                lplayer.printError("mech.use-permission");
                continue;
            }
            if (event instanceof Cancellable && comdef.cancelAction) {
                ((Cancellable)event).setCancelled(true);
            }
            if (this.cooldownPeriods.containsKey(new Tuple2<String, String>(lplayer.getName(), comdef.name))) {
                if (def.clickType == ClickType.PASSIVE || def.cooldownMessage.isEmpty()) continue;
                lplayer.printError(lplayer.translate(def.cooldownMessage).replace("%time%", String.valueOf(this.cooldownPeriods.get(new Tuple2<String, String>(lplayer.getName(), comdef.name)))));
                continue;
            }
            if (!player.hasPermission("craftbook.mech.commanditems.bypassconsumables") && !player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                for (CommandItemAction commandItemAction : def.consumables) {
                    found = false;
                    amount = 0;
                    for (ItemStack tStack : player.getInventory().getContents()) {
                        if (!ItemUtil.areItemsIdentical((ItemStack)commandItemAction, tStack) || (amount += tStack.getAmount()) < commandItemAction.getAmount()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    if (def.missingConsumableMessage.isEmpty()) continue block0;
                    lplayer.printError(lplayer.translate(def.missingConsumableMessage).replace("%item%", commandItemAction.getAmount() + " " + commandItemAction.getType().name()));
                    continue block0;
                }
            }
            for (CommandItemAction commandItemAction : comdef.actions) {
                if (commandItemAction.stage == CommandItemAction.ActionRunStage.BEFORE && !commandItemAction.runAction(comdef, event, player)) continue block0;
            }
            for (CommandItemAction commandItemAction : def.consumables) {
                found = false;
                amount = commandItemAction.getAmount();
                for (int i = 0; i < player.getInventory().getContents().length; ++i) {
                    ItemStack tStack = player.getInventory().getContents()[i];
                    if (!ItemUtil.areItemsIdentical((ItemStack)commandItemAction, tStack)) continue;
                    ItemStack toRemove = tStack.clone();
                    if (toRemove.getAmount() > amount) {
                        toRemove.setAmount(toRemove.getAmount() - amount);
                        player.getInventory().setItem(i, toRemove);
                        amount = 0;
                    } else {
                        amount -= toRemove.getAmount();
                        player.getInventory().setItem(i, null);
                    }
                    if (amount > 0) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                lplayer.printError("mech.command-items.out-of-sync");
                continue block0;
            }
            if (def.consumeSelf) {
                if (event instanceof PlayerInteractEvent && ((PlayerInteractEvent)event).getHand() == EquipmentSlot.OFF_HAND || event instanceof BlockPlaceEvent && ((BlockPlaceEvent)event).getHand() == EquipmentSlot.OFF_HAND) {
                    if (player.getInventory().getItemInOffHand().getAmount() > 1) {
                        player.getInventory().getItemInOffHand().setAmount(player.getInventory().getItemInOffHand().getAmount() - 1);
                    } else {
                        player.getInventory().setItemInOffHand(null);
                    }
                } else if (event instanceof PlayerPickupItemEvent) {
                    ((PlayerPickupItemEvent)event).getItem().remove();
                    ((PlayerPickupItemEvent)event).setCancelled(true);
                } else if (player.getInventory().getItemInMainHand().getAmount() > 1) {
                    player.getInventory().getItemInMainHand().setAmount(player.getInventory().getItemInMainHand().getAmount() - 1);
                } else {
                    player.getInventory().setItemInMainHand(null);
                }
            }
            player.updateInventory();
            for (String string : comdef.commands) {
                CommandItems.doCommand(string, event, comdef, player);
            }
            for (CommandItemAction commandItemAction : comdef.actions) {
                if (commandItemAction.stage != CommandItemAction.ActionRunStage.AFTER) continue;
                commandItemAction.runAction(comdef, event, player);
            }
            if (comdef.cooldown > 0 && !lplayer.hasPermission("craftbook.mech.commanditems.bypasscooldown")) {
                this.cooldownPeriods.put(new Tuple2<String, String>(lplayer.getName(), comdef.name), comdef.cooldown);
            }
            if (comdef.delayedCommands.length <= 0) continue;
            Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
                for (String command : comdef.delayedCommands) {
                    CommandItems.doCommand(command, event, comdef, player);
                }
            }, (long)comdef.delay);
        }
    }

    public static void doCommand(String command, Event event, CommandItemDefinition comdef, Player player) {
        if (command == null || command.trim().isEmpty()) {
            return;
        }
        command = CommandItems.parseLine(command, event, player);
        if (comdef.type == CommandItemDefinition.CommandType.CONSOLE) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        } else if (comdef.type == CommandItemDefinition.CommandType.PLAYER) {
            if (comdef.fakeCommand) {
                ProtectionUtil.canSendCommand(player, command);
            } else {
                Bukkit.dispatchCommand((CommandSender)player, (String)command);
            }
        } else if (comdef.type == CommandItemDefinition.CommandType.SUPERUSER) {
            PermissionAttachment att = player.addAttachment((Plugin)CraftBookPlugin.inst());
            att.setPermission("*", true);
            boolean wasOp = player.isOp();
            if (!wasOp) {
                player.setOp(true);
            }
            if (comdef.fakeCommand) {
                ProtectionUtil.canSendCommand(player, command);
            } else {
                Bukkit.dispatchCommand((CommandSender)player, (String)command);
            }
            att.remove();
            if (!wasOp) {
                player.setOp(wasOp);
            }
        }
    }

    static String parseLine(String command, Event event, Player player) {
        if (command == null) {
            return null;
        }
        if (event instanceof EntityDamageByEntityEvent) {
            command = StringUtils.replace((String)command, (String)"@d.x", (String)String.valueOf(((EntityDamageByEntityEvent)event).getEntity().getLocation().getX()));
            command = StringUtils.replace((String)command, (String)"@d.y", (String)String.valueOf(((EntityDamageByEntityEvent)event).getEntity().getLocation().getY()));
            command = StringUtils.replace((String)command, (String)"@d.z", (String)String.valueOf(((EntityDamageByEntityEvent)event).getEntity().getLocation().getZ()));
            command = StringUtils.replace((String)command, (String)"@d.bx", (String)String.valueOf(((EntityDamageByEntityEvent)event).getEntity().getLocation().getBlockX()));
            command = StringUtils.replace((String)command, (String)"@d.by", (String)String.valueOf(((EntityDamageByEntityEvent)event).getEntity().getLocation().getBlockY()));
            command = StringUtils.replace((String)command, (String)"@d.bz", (String)String.valueOf(((EntityDamageByEntityEvent)event).getEntity().getLocation().getBlockZ()));
            command = StringUtils.replace((String)command, (String)"@d.w", (String)String.valueOf(((EntityDamageByEntityEvent)event).getEntity().getLocation().getWorld().getName()));
            command = StringUtils.replace((String)command, (String)"@d.l", (String)((EntityDamageByEntityEvent)event).getEntity().getLocation().toString());
            command = StringUtils.replace((String)command, (String)"@d.u", (String)((EntityDamageByEntityEvent)event).getEntity().getUniqueId().toString());
            if (((EntityDamageByEntityEvent)event).getEntity() instanceof Player) {
                command = StringUtils.replace((String)command, (String)"@d.i", (String)CraftBookPlugin.inst().getUUIDMappings().getCBID(((EntityDamageByEntityEvent)event).getEntity().getUniqueId()));
                command = StringUtils.replace((String)command, (String)"@d", (String)((EntityDamageByEntityEvent)event).getEntity().getName());
            } else {
                command = StringUtils.replace((String)command, (String)"@d", (String)((EntityDamageByEntityEvent)event).getEntity().getType().name());
            }
        }
        if (event instanceof PlayerInteractEntityEvent) {
            command = StringUtils.replace((String)command, (String)"@d.x", (String)String.valueOf(((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getX()));
            command = StringUtils.replace((String)command, (String)"@d.y", (String)String.valueOf(((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getY()));
            command = StringUtils.replace((String)command, (String)"@d.z", (String)String.valueOf(((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getZ()));
            command = StringUtils.replace((String)command, (String)"@d.bx", (String)String.valueOf(((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getBlockX()));
            command = StringUtils.replace((String)command, (String)"@d.by", (String)String.valueOf(((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getBlockY()));
            command = StringUtils.replace((String)command, (String)"@d.bz", (String)String.valueOf(((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getBlockZ()));
            command = StringUtils.replace((String)command, (String)"@d.w", (String)String.valueOf(((PlayerInteractEntityEvent)event).getRightClicked().getLocation().getWorld().getName()));
            command = StringUtils.replace((String)command, (String)"@d.l", (String)((PlayerInteractEntityEvent)event).getRightClicked().getLocation().toString());
            command = StringUtils.replace((String)command, (String)"@d.u", (String)((PlayerInteractEntityEvent)event).getRightClicked().getUniqueId().toString());
            if (((PlayerInteractEntityEvent)event).getRightClicked() instanceof Player) {
                command = StringUtils.replace((String)command, (String)"@d.i", (String)CraftBookPlugin.inst().getUUIDMappings().getCBID(((PlayerInteractEntityEvent)event).getRightClicked().getUniqueId()));
                command = StringUtils.replace((String)command, (String)"@d", (String)((PlayerInteractEntityEvent)event).getRightClicked().getName());
            } else {
                command = StringUtils.replace((String)command, (String)"@d", (String)((PlayerInteractEntityEvent)event).getRightClicked().getType().name());
            }
        }
        if (event instanceof BlockEvent && ((BlockEvent)event).getBlock() != null) {
            command = StringUtils.replace((String)command, (String)"@b.x", (String)String.valueOf(((BlockEvent)event).getBlock().getX()));
            command = StringUtils.replace((String)command, (String)"@b.y", (String)String.valueOf(((BlockEvent)event).getBlock().getY()));
            command = StringUtils.replace((String)command, (String)"@b.z", (String)String.valueOf(((BlockEvent)event).getBlock().getZ()));
            command = StringUtils.replace((String)command, (String)"@b.w", (String)((BlockEvent)event).getBlock().getLocation().getWorld().getName());
            command = StringUtils.replace((String)command, (String)"@b.l", (String)((BlockEvent)event).getBlock().getLocation().toString());
            command = StringUtils.replace((String)command, (String)"@b.d", (String)String.valueOf(((BlockEvent)event).getBlock().getData()));
            command = StringUtils.replace((String)command, (String)"@b.t", (String)((BlockEvent)event).getBlock().getType().name());
            command = StringUtils.replace((String)command, (String)"@b", (String)(((BlockEvent)event).getBlock().getType().name() + (((BlockEvent)event).getBlock().getData() == 0 ? "" : ":") + ((BlockEvent)event).getBlock().getData()));
        }
        if (event instanceof PlayerInteractEvent && ((PlayerInteractEvent)event).getClickedBlock() != null) {
            command = StringUtils.replace((String)command, (String)"@b.x", (String)String.valueOf(((PlayerInteractEvent)event).getClickedBlock().getX()));
            command = StringUtils.replace((String)command, (String)"@b.y", (String)String.valueOf(((PlayerInteractEvent)event).getClickedBlock().getY()));
            command = StringUtils.replace((String)command, (String)"@b.z", (String)String.valueOf(((PlayerInteractEvent)event).getClickedBlock().getZ()));
            command = StringUtils.replace((String)command, (String)"@b.w", (String)String.valueOf(((PlayerInteractEvent)event).getClickedBlock().getWorld().getName()));
            command = StringUtils.replace((String)command, (String)"@b.l", (String)((PlayerInteractEvent)event).getClickedBlock().getLocation().toString());
            command = StringUtils.replace((String)command, (String)"@b.d", (String)String.valueOf(((PlayerInteractEvent)event).getClickedBlock().getData()));
            command = StringUtils.replace((String)command, (String)"@b.t", (String)((PlayerInteractEvent)event).getClickedBlock().getType().name());
            command = StringUtils.replace((String)command, (String)"@b", (String)(((PlayerInteractEvent)event).getClickedBlock().getType().name() + (((PlayerInteractEvent)event).getClickedBlock().getData() == 0 ? "" : ":") + ((PlayerInteractEvent)event).getClickedBlock().getData()));
        }
        if (event instanceof EntityEvent && ((EntityEvent)event).getEntityType() != null && command.contains("@e")) {
            command = StringUtils.replace((String)command, (String)"@e.x", (String)String.valueOf(((EntityEvent)event).getEntity().getLocation().getX()));
            command = StringUtils.replace((String)command, (String)"@e.y", (String)String.valueOf(((EntityEvent)event).getEntity().getLocation().getY()));
            command = StringUtils.replace((String)command, (String)"@e.z", (String)String.valueOf(((EntityEvent)event).getEntity().getLocation().getZ()));
            command = StringUtils.replace((String)command, (String)"@e.bx", (String)String.valueOf(((EntityEvent)event).getEntity().getLocation().getBlockX()));
            command = StringUtils.replace((String)command, (String)"@e.by", (String)String.valueOf(((EntityEvent)event).getEntity().getLocation().getBlockY()));
            command = StringUtils.replace((String)command, (String)"@e.bz", (String)String.valueOf(((EntityEvent)event).getEntity().getLocation().getBlockZ()));
            command = StringUtils.replace((String)command, (String)"@e.w", (String)String.valueOf(((EntityEvent)event).getEntity().getLocation().getWorld().getName()));
            command = StringUtils.replace((String)command, (String)"@e.l", (String)((EntityEvent)event).getEntity().getLocation().toString());
            command = StringUtils.replace((String)command, (String)"@e.u", (String)((EntityEvent)event).getEntity().getUniqueId().toString());
            command = StringUtils.replace((String)command, (String)"@e", (String)((EntityEvent)event).getEntityType().getName());
        }
        if (event instanceof AsyncPlayerChatEvent && command.contains("@m")) {
            command = StringUtils.replace((String)command, (String)"@m", (String)((AsyncPlayerChatEvent)event).getMessage());
        }
        command = ParsingUtil.parsePlayerTags(command, player);
        command = ParsingUtil.parseVariables(command, null);
        return command;
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
    }

    @Override
    public LoadPriority getLoadPriority() {
        return LoadPriority.EARLY;
    }
}

