/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.items;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.items.ClickType;
import com.sk89q.craftbook.mechanics.items.CommandItemAction;
import com.sk89q.craftbook.mechanics.items.CommandItemDefinition;
import com.sk89q.craftbook.mechanics.items.CommandItems;
import com.sk89q.craftbook.util.EnumUtil;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.TernaryState;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.BooleanPrompt;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.FixedSetPrompt;
import org.bukkit.conversations.MessagePrompt;
import org.bukkit.conversations.NullConversationPrefix;
import org.bukkit.conversations.NumericPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CommandItemCommands {
    private ConversationFactory conversationFactory;

    public CommandItemCommands(CraftBookPlugin plugin) {
        this.setupAddCommand(plugin);
    }

    @Command(aliases={"give"}, desc="Gives the player the item.", flags="p:a:s", usage="[-p player] <CommandItem Name> [-a amount] [-s]", min=1)
    public void giveItem(CommandContext context, CommandSender sender) throws CommandException {
        Player player;
        if (context.hasFlag('p')) {
            player = Bukkit.getPlayer((String)context.getFlag('p'));
        } else {
            if (!(sender instanceof Player)) {
                throw new CommandException("Please provide a player! (-p flag)");
            }
            player = (Player)sender;
        }
        if (player == null) {
            throw new CommandException("Unknown Player!");
        }
        if (CommandItems.INSTANCE == null) {
            throw new CommandException("CommandItems are not enabled!");
        }
        if (!sender.hasPermission("craftbook.mech.commanditems.give" + (context.hasFlag('p') ? ".others" : "") + "." + context.getString(0))) {
            throw new CommandPermissionsException();
        }
        CommandItemDefinition def = CommandItems.INSTANCE.getDefinitionByName(context.getString(0));
        if (def == null) {
            throw new CommandException("Invalid CommandItem!");
        }
        ItemStack stack = ItemUtil.makeItemValid(def.getItem().clone());
        if (context.hasFlag('a')) {
            stack.setAmount(stack.getAmount() * context.getFlagInteger('a', 1));
        }
        if (!player.getInventory().addItem(new ItemStack[]{stack}).isEmpty()) {
            throw new CommandException("Failed to add item to inventory!");
        }
        if (!context.hasFlag('s')) {
            sender.sendMessage(ChatColor.YELLOW + "Gave CommandItem " + ChatColor.BLUE + def.getName() + ChatColor.YELLOW + " to " + player.getName());
        }
    }

    @Command(aliases={"spawn"}, desc="Spawns the item at the coordinates", flags="w:a:s", usage="<CommandItem Name> <x> <y> <z> [-w world] [-a amount] [-s]", min=4)
    public void spawnItem(CommandContext context, CommandSender sender) throws CommandException {
        if (CommandItems.INSTANCE == null) {
            throw new CommandException("CommandItems are not enabled!");
        }
        if (!sender.hasPermission("craftbook.mech.commanditems.spawn" + context.getString(0))) {
            throw new CommandPermissionsException();
        }
        CommandItemDefinition def = CommandItems.INSTANCE.getDefinitionByName(context.getString(0));
        if (def == null) {
            throw new CommandException("Invalid CommandItem!");
        }
        World world = null;
        if (context.hasFlag('w')) {
            world = Bukkit.getWorld((String)context.getFlag('w'));
        } else if (sender instanceof Player) {
            world = ((Player)sender).getWorld();
        } else {
            throw new CommandException("Either a player or world is required!");
        }
        ItemStack stack = def.getItem().clone();
        stack = ItemUtil.makeItemValid(stack);
        if (context.hasFlag('a')) {
            stack.setAmount(stack.getAmount() * context.getFlagInteger('a', 1));
        }
        world.dropItem(new Location(world, (double)context.getInteger(1), (double)context.getInteger(2), (double)context.getInteger(3)), stack);
        if (!context.hasFlag('s')) {
            sender.sendMessage(ChatColor.YELLOW + "Spawned CommandItem " + ChatColor.BLUE + def.getName() + ChatColor.YELLOW + " at " + new Location(world, (double)context.getInteger(1), (double)context.getInteger(2), (double)context.getInteger(3)).toString());
        }
    }

    @Command(aliases={"add", "create"}, desc="Create a new CommandItem.")
    @CommandPermissions(value={"craftbook.mech.commanditems.create"})
    public void addCommandItem(CommandContext context, CommandSender sender) throws CommandException {
        if (CommandItems.INSTANCE == null) {
            sender.sendMessage("CommandItems are not enabled!");
            return;
        }
        if (!(sender instanceof Player)) {
            throw new CommandException("Can only add CommandItems as a player!");
        }
        if (((Player)sender).getInventory().getItemInHand() == null) {
            throw new CommandException("Invalid Item for CommandItems!");
        }
        Conversation convo = this.conversationFactory.buildConversation((Conversable)sender);
        convo.getContext().setSessionData((Object)"item", (Object)((HumanEntity)sender).getInventory().getItemInHand());
        ArrayList<ItemStack> consumables = new ArrayList<ItemStack>();
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack;
            if (i == ((HumanEntity)sender).getInventory().getHeldItemSlot() || !ItemUtil.isStackValid(stack = ((HumanEntity)sender).getInventory().getItem(i))) continue;
            consumables.add(stack);
        }
        convo.getContext().setSessionData((Object)"consumables", consumables);
        convo.begin();
    }

    public void setupAddCommand(CraftBookPlugin plugin) {
        this.conversationFactory = new ConversationFactory((Plugin)plugin).withModality(true).withEscapeSequence("cancel").withPrefix((ConversationPrefix)new NullConversationPrefix()).withFirstPrompt((Prompt)new StringPrompt(){

            public String getPromptText(ConversationContext context) {
                return ChatColor.YELLOW + "Please enter a unique ID for this CommandItem. (Used in /comitems give) (Type 'cancel' to quit)";
            }

            public Prompt acceptInput(ConversationContext context, String input) {
                if (input.trim().length() == 0) {
                    return Prompt.END_OF_CONVERSATION;
                }
                context.setSessionData((Object)"name", (Object)input);
                return new CommandPrompt();
            }
        });
    }

    private static class CreateItemPrompt
    extends MessagePrompt {
        private CreateItemPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            try {
                String name = (String)context.getSessionData((Object)"name");
                ItemStack stack = (ItemStack)context.getSessionData((Object)"item");
                List consumables = (List)context.getSessionData((Object)"consumables");
                List commands = (List)context.getSessionData((Object)"commands");
                String permNode = (String)context.getSessionData((Object)"permission-node");
                CommandItemDefinition.CommandType type = (CommandItemDefinition.CommandType)((Object)context.getSessionData((Object)"run-as"));
                ClickType clickType = (ClickType)((Object)context.getSessionData((Object)"click-type"));
                int delay = (Integer)context.getSessionData((Object)"delay");
                List delayedCommands = new ArrayList();
                if (delay > 0) {
                    delayedCommands = (List)context.getSessionData((Object)"delayed-commands");
                }
                int cooldown = (Integer)context.getSessionData((Object)"cooldown");
                boolean cancelAction = (Boolean)context.getSessionData((Object)"cancel-action");
                boolean consumeSelf = (Boolean)context.getSessionData((Object)"consume-self");
                TernaryState requireSneaking = (TernaryState)((Object)context.getSessionData((Object)"require-sneaking"));
                boolean keepOnDeath = (Boolean)context.getSessionData((Object)"keep-on-death");
                ArrayList actions = new ArrayList();
                String missingConsumableMessage = "mech.command-items.need";
                String cooldownMessage = "mech.command-items.wait";
                CommandItemDefinition def = new CommandItemDefinition(name, stack, type, clickType, permNode, commands.toArray(new String[commands.size()]), delay, delayedCommands.toArray(new String[delayedCommands.size()]), cooldown, cancelAction, consumables.toArray(new ItemStack[consumables.size()]), consumeSelf, requireSneaking, keepOnDeath, actions.toArray(new CommandItemAction[actions.size()]), missingConsumableMessage, cooldownMessage, false);
                CommandItems.INSTANCE.addDefinition(def);
                CommandItems.INSTANCE.save();
                return ChatColor.YELLOW + "Successfully added CommandItem: " + name;
            }
            catch (Exception e) {
                CraftBookBukkitUtil.printStacktrace(e);
                return ChatColor.RED + "Failed to add CommandItem! See Console for more details!";
            }
        }

        protected Prompt getNextPrompt(ConversationContext context) {
            return Prompt.END_OF_CONVERSATION;
        }
    }

    private static class KeepOnDeathPrompt
    extends BooleanPrompt {
        private KeepOnDeathPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return ChatColor.YELLOW + "Do you wish the CommandItem to be kept on death?";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, boolean input) {
            context.setSessionData((Object)"keep-on-death", (Object)input);
            return new CreateItemPrompt();
        }
    }

    private static class DelayedCommandPrompt
    extends StringPrompt {
        private DelayedCommandPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return ChatColor.YELLOW + "Please enter the commands you wish for this CommandItem to perform after the delay (Without the /). Please enter one per message. (Type 'done' to stop entering commands)";
        }

        public Prompt acceptInput(ConversationContext context, final String input) {
            if (input.trim().length() == 0 || input.trim().equalsIgnoreCase("done")) {
                return new KeepOnDeathPrompt();
            }
            if (context.getSessionData((Object)"delayed-commands") == null) {
                context.setSessionData((Object)"delayed-commands", (Object)new ArrayList<String>(){
                    {
                        this.add(input.trim());
                    }
                });
            } else {
                ArrayList list = (ArrayList)context.getSessionData((Object)"delayed-commands");
                list.add(input.trim());
                context.setSessionData((Object)"delayed-commands", (Object)list);
            }
            return new DelayedCommandPrompt();
        }
    }

    private static class DelayPrompt
    extends NumericPrompt {
        private DelayPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return ChatColor.YELLOW + "Please enter a delay after which an extra set of Commands will be performed. (Useful for turning off CommandItems after a delay). (Type '0' for none)";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, Number input) {
            context.setSessionData((Object)"delay", (Object)input.intValue());
            if (input.intValue() == 0) {
                return new KeepOnDeathPrompt();
            }
            return new DelayedCommandPrompt();
        }
    }

    private static class RequireSneakingPrompt
    extends StringPrompt {
        private RequireSneakingPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return ChatColor.YELLOW + "What sneaking state do you want players to require?";
        }

        public Prompt acceptInput(ConversationContext context, String input) {
            context.setSessionData((Object)"require-sneaking", (Object)TernaryState.getFromString(input));
            return new DelayPrompt();
        }
    }

    private static class ConsumeSelfPrompt
    extends BooleanPrompt {
        private ConsumeSelfPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return ChatColor.YELLOW + "Do you wish the CommandItem to be consumed when used?";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, boolean input) {
            context.setSessionData((Object)"consume-self", (Object)input);
            return new RequireSneakingPrompt();
        }
    }

    private static class CancelActionPrompt
    extends BooleanPrompt {
        private CancelActionPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return ChatColor.YELLOW + "Do you wish the action that is being performed to not occur when the CommandItem is used? (Eg, damaging entities)";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, boolean input) {
            context.setSessionData((Object)"cancel-action", (Object)input);
            return new ConsumeSelfPrompt();
        }
    }

    private static class CooldownPromp
    extends NumericPrompt {
        private CooldownPromp() {
        }

        public String getPromptText(ConversationContext context) {
            return ChatColor.YELLOW + "Please enter the cooldown for using this CommandItem. (Type '0' for none)";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, Number input) {
            context.setSessionData((Object)"cooldown", (Object)input.intValue());
            return new CancelActionPrompt();
        }
    }

    private static class PermissionNodePromp
    extends StringPrompt {
        private PermissionNodePromp() {
        }

        public String getPromptText(ConversationContext context) {
            return ChatColor.YELLOW + "Please enter the permission node you wish users to require to use the CommandItem. (Type 'none' for none.)";
        }

        public Prompt acceptInput(ConversationContext context, String input) {
            if ((input = input.trim()).length() > 0 && !input.equalsIgnoreCase("none")) {
                context.setSessionData((Object)"permission-node", (Object)input);
            } else {
                context.setSessionData((Object)"permission-node", (Object)"");
            }
            return new CooldownPromp();
        }
    }

    private static class EventPrompt
    extends FixedSetPrompt {
        public EventPrompt() {
            super(EnumUtil.getStringArrayFromEnum(ClickType.class));
        }

        public String getPromptText(ConversationContext context) {
            return ChatColor.YELLOW + "Please enter what event you want the CommandItem to be triggered by.";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, String input) {
            context.setSessionData((Object)"click-type", (Object)ClickType.valueOf(input));
            return new PermissionNodePromp();
        }
    }

    private static class RunAsPrompt
    extends FixedSetPrompt {
        public RunAsPrompt() {
            super(EnumUtil.getStringArrayFromEnum(CommandItemDefinition.CommandType.class));
        }

        public String getPromptText(ConversationContext context) {
            return ChatColor.YELLOW + "Please enter what you would like the CommandItem to run as.";
        }

        protected Prompt acceptValidatedInput(ConversationContext context, String input) {
            context.setSessionData((Object)"run-as", (Object)CommandItemDefinition.CommandType.valueOf(input));
            return new EventPrompt();
        }
    }

    private static class CommandPrompt
    extends StringPrompt {
        private CommandPrompt() {
        }

        public String getPromptText(ConversationContext context) {
            return ChatColor.YELLOW + "Please enter the commands you wish for this CommandItem to perform (Without the /). Please enter one per message. (Type 'done' to stop entering commands)";
        }

        public Prompt acceptInput(ConversationContext context, final String input) {
            if (input.trim().length() == 0 || input.trim().equalsIgnoreCase("done")) {
                if (context.getSessionData((Object)"commands") == null) {
                    context.setSessionData((Object)"commands", new ArrayList());
                }
                return new RunAsPrompt();
            }
            if (context.getSessionData((Object)"commands") == null) {
                context.setSessionData((Object)"commands", (Object)new ArrayList<String>(){
                    {
                        this.add(input.trim());
                    }
                });
            } else {
                ArrayList list = (ArrayList)context.getSessionData((Object)"commands");
                list.add(input.trim());
                context.setSessionData((Object)"commands", (Object)list);
            }
            return new CommandPrompt();
        }
    }
}

