/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.plc.lang;

import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.mechanics.ic.plc.PlcException;
import com.sk89q.craftbook.mechanics.ic.plc.PlcLanguage;
import com.sk89q.craftbook.mechanics.ic.plc.lang.LineInfo;
import com.sk89q.craftbook.mechanics.ic.plc.lang.WithLineInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;
import org.bukkit.ChatColor;

public class Perlstone
implements PlcLanguage<boolean[], WithLineInfo<String>[]> {
    private static final int MAX_INSTRUCTION_COUNT = 10000;
    private static final int MAX_STACK_SIZE = 64;
    private static final int MAX_RECURSION = 16;
    private static final int PERLSTONE_STORE_VERSION = 0;

    @Override
    public String getName() {
        return "Perlstone-1.1";
    }

    @Override
    public boolean[] initState() {
        return new boolean[32];
    }

    private WithLineInfo<char[]> markLines(String code) {
        char[] chars = code.toCharArray();
        ArrayList<LineInfo> lines = new ArrayList<LineInfo>();
        int line = 1;
        int col = 1;
        for (char aChar : chars) {
            lines.add(new LineInfo(line, col));
            switch (aChar) {
                case '\n': {
                    ++line;
                    col = 0;
                    break;
                }
            }
            ++col;
        }
        return new WithLineInfo<char[]>(lines.toArray(new LineInfo[lines.size()]), chars);
    }

    private char[] fixArray(Character[] c) {
        char[] o = new char[c.length];
        for (int i = 0; i < c.length; ++i) {
            o[i] = c[i].charValue();
        }
        return o;
    }

    private WithLineInfo<String>[] splitFunctions(WithLineInfo<char[]> chars) {
        ArrayList<WithLineInfo<String>> lines = new ArrayList<WithLineInfo<String>>();
        ArrayList<Character> current = new ArrayList<Character>();
        ArrayList<LineInfo> currentLineInfo = new ArrayList<LineInfo>();
        char[] data = (char[])chars.code;
        block4: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case ':': {
                    lines.add(new WithLineInfo<String>(currentLineInfo.toArray(new LineInfo[currentLineInfo.size()]), new String(this.fixArray(current.toArray(new Character[current.size()])))));
                    current.clear();
                    currentLineInfo.clear();
                    continue block4;
                }
                case '\n': 
                case ' ': {
                    continue block4;
                }
                default: {
                    current.add(Character.valueOf(data[i]));
                    currentLineInfo.add(chars.lineInfo[i]);
                }
            }
        }
        lines.add(new WithLineInfo<String>(currentLineInfo.toArray(new LineInfo[currentLineInfo.size()]), new String(this.fixArray(current.toArray(new Character[current.size()])))));
        return lines.toArray(new WithLineInfo[lines.size()]);
    }

    @Override
    public WithLineInfo<String>[] compile(String code) throws ICVerificationException {
        WithLineInfo<String>[] functions = this.splitFunctions(this.markLines(code));
        for (int l = 0; l < functions.length; ++l) {
            WithLineInfo<String> line = functions[l];
            char[] chars = ((String)line.code).toCharArray();
            LineInfo[] li = line.lineInfo;
            int bracketCount = 0;
            if (chars.length == 0) continue;
            block18: for (int i = 0; i < chars.length; ++i) {
                try {
                    char c = chars[i];
                    switch (c) {
                        case '[': {
                            ++bracketCount;
                            break;
                        }
                        case ']': {
                            if (bracketCount == 0) {
                                throw new ICVerificationException("Too many closing braces on line " + li[i].line + " at column " + li[i].col);
                            }
                            --bracketCount;
                            break;
                        }
                        case '!': 
                        case '&': 
                        case '+': 
                        case '-': 
                        case '=': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case '^': 
                        case 'd': 
                        case 'p': 
                        case 'r': 
                        case 's': 
                        case 'x': 
                        case '|': {
                            break;
                        }
                        case '<': 
                        case '>': 
                        case 'L': 
                        case 'S': 
                        case 'e': {
                            char p;
                            switch (chars[++i]) {
                                case 'L': 
                                case 'P': 
                                case 'R': 
                                case 'l': 
                                case 'p': 
                                case 'r': {
                                    break;
                                }
                                default: {
                                    throw new ICVerificationException("Unknown modifier " + chars[i] + " to opcode " + c + " on line " + li[i].line + " at column " + li[i].col);
                                }
                            }
                            if (c != 'S' && c != 'L' || (p = chars[++i]) >= '0' || p <= '9' || p >= 'a' || p <= 'v') continue block18;
                            throw new ICVerificationException("Bad table index " + chars[i] + " for opcode " + c + " on line " + li[i].line + " at column " + li[i].col);
                        }
                        case 'v': {
                            char n = chars[++i];
                            if (n >= '0' || n <= '9') continue block18;
                            throw new ICVerificationException("Bad peek depth " + chars[i] + " on line " + li[i].line + " at column " + li[i].col);
                        }
                        case '.': {
                            int j;
                            block19: for (j = 0; j < 4; ++j) {
                                switch (chars[++i]) {
                                    case '+': 
                                    case '-': 
                                    case '0': 
                                    case '1': {
                                        continue block19;
                                    }
                                    default: {
                                        throw new ICVerificationException("Bad logic table value " + chars[i] + " on line " + li[i].line + " at column " + li[i].col);
                                    }
                                }
                            }
                            continue block18;
                        }
                        case 'c': 
                        case 't': {
                            int j;
                            char n;
                            for (j = 0; j < 2; ++j) {
                                char n2;
                                if ((n2 = chars[++i]) >= '0' || n2 <= '9') continue;
                                throw new ICVerificationException("Invalid character " + chars[i] + " in function number on line " + li[i].line + " at column " + li[i].col);
                            }
                            if ((n = chars[++i]) >= '0' || n <= '9') continue block18;
                            throw new ICVerificationException("Invalid character " + chars[i] + " in argument count on line " + li[i].line + " at column " + li[i].col);
                        }
                        default: {
                            throw new ICVerificationException("Unknown opcode " + c + " on line " + li[i].line + " at column " + li[i].col);
                        }
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    CraftBookBukkitUtil.printStacktrace(e);
                    i = li.length - 1;
                    throw new ICVerificationException("Unexpected function end around line " + li[i].line);
                }
            }
            if (bracketCount == 0) continue;
            throw new ICVerificationException("Missing closing braces in function #" + l + "                           starting on line " + li[0].line + " and ending on line " + li[li.length - 1].line);
        }
        return functions;
    }

    @Override
    public void writeState(boolean[] state, DataOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeInt(state.length);
        for (boolean aState : state) {
            out.writeBoolean(aState);
        }
    }

    @Override
    public void loadState(boolean[] state, DataInputStream in) throws IOException {
        if (in.readInt() != 0) {
            throw new IOException("incompatible save version");
        }
        if (state.length != in.readInt()) {
            throw new IOException("size mismatch!");
        }
        for (int i = 0; i < state.length; ++i) {
            state[i] = in.readBoolean();
        }
    }

    @Override
    public void execute(ChipState chip, boolean[] state, WithLineInfo<String>[] code) throws PlcException {
        boolean[] tt = new boolean[32];
        boolean a = chip.getInputCount() > 0 && chip.getInput(0);
        boolean b = chip.getInputCount() > 1 && chip.getInput(1);
        boolean c = chip.getInputCount() > 2 && chip.getInput(2);
        for (int i = 0; i < chip.getOutputCount(); ++i) {
            if (i < code.length) {
                Boolean r = this.executeFunction(i, state, tt, code, a, b, c, new boolean[0], new int[1], 0);
                if (r == null) {
                    chip.setOutput(i, false);
                    continue;
                }
                chip.setOutput(i, r);
                continue;
            }
            chip.setOutput(i, false);
        }
    }

    @Override
    public boolean supports(String lang) {
        return false;
    }

    private int mod(int a, int b) {
        return (a % b + b) % b;
    }

    private int decodeAddress(char c, int shift) {
        if (c >= '0' && c <= '9') {
            return this.mod(c - 48 + shift, 32);
        }
        return this.mod(c - 97 + 10 + shift, 32);
    }

    private int parseNumber(char c) {
        return c - 48;
    }

    private boolean parseTableChar(char c) throws PlcException {
        switch (c) {
            case '+': {
                return true;
            }
            case '-': {
                return false;
            }
            case '1': {
                return true;
            }
            case '0': {
                return false;
            }
        }
        throw new PlcException("invalid table", "Invalid character in logic table.");
    }

    private String errmsg(String err, int fno, char opcode, LineInfo li, boolean[] pt, boolean[] tt, boolean[] lt, int pshift, int tshift, int lshift, Stack<Boolean> stack, int tc) {
        String errm = "";
        if (!err.startsWith(ChatColor.RED + "Detailed Error Message: ")) {
            errm = errm + ChatColor.RED + "Detailed Error Message: " + ChatColor.RESET + err + "\n";
            errm = errm + ChatColor.RED + "Persistent Variable Table: \n " + ChatColor.RESET + this.dumpStateText(pt) + "\n";
            errm = errm + ChatColor.RED + " - Shift: " + ChatColor.RESET + pshift + "\n";
            errm = errm + ChatColor.RED + "Temp Variable Table: \n " + ChatColor.RESET + this.dumpStateText(tt) + "\n";
            errm = errm + ChatColor.RED + " - Shift: " + ChatColor.RESET + tshift + "\n";
        } else {
            errm = errm + err + "\n";
        }
        errm = errm + ChatColor.RED + "====\n";
        if (tc > 0) {
            errm = errm + "(" + tc + " tail call" + (tc > 1 ? "s" : "") + " omitted)\n====\n";
        }
        errm = errm + ChatColor.RED + "Location: " + ChatColor.RESET + "Opcode " + opcode + " at line " + li.line + ", column " + li.col + " in function #" + fno + "\n";
        errm = errm + ChatColor.RED + "Local Variable Table: \n " + ChatColor.RESET + this.dumpStateText(lt) + "\n";
        errm = errm + ChatColor.RED + " - Shift: " + ChatColor.RESET + lshift + "\n";
        errm = errm + ChatColor.RED + "Function Stack: " + ChatColor.RESET + this.dumpStateText(stack.toArray(new Boolean[stack.size()]));
        return errm;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Boolean executeFunction(int fno, boolean[] pt, boolean[] tt, WithLineInfo<String>[] funs, boolean a, boolean b, boolean c, boolean[] args, int[] opc, int rec) throws PlcException {
        tailcalls = 0;
        block49: while (true) {
            block64: {
                fn = (String)funs[fno].code;
                lis = funs[fno].lineInfo;
                code = fn.toCharArray();
                jt = new int[code.length];
                bracketStack = new Stack<Integer>();
                for (i = 0; i < code.length; ++i) {
                    ch = code[i];
                    if (ch == '[') {
                        bracketStack.push(i);
                        continue;
                    }
                    if (ch != ']') continue;
                    jt[i] = j = ((Integer)bracketStack.pop()).intValue();
                    jt[j] = i;
                }
                ip = 0;
                executionStack = new Stack<Boolean>();
                ch = args;
                j = ch.length;
                for (var20_23 = 0; var20_23 < j; ++var20_23) {
                    arg1 = ch[var20_23];
                    executionStack.push(arg1);
                }
                lt = new boolean[32];
                pshift = 0;
                tshift = 0;
                lshift = 0;
                op = '?';
                li = new LineInfo(0, 0);
                try {
                    if (rec > 16) {
                        throw new PlcException("stack overflow", "Aborted due to too many recursive non-tail calls.");
                    }
                    ** try [egrp 1[TRYBLOCK] [1, 5 : 232->1835)] { 
lbl37:
                    // 1 sources

                    break block64;
lbl38:
                    // 1 sources

                    catch (EmptyStackException e) {
                        throw new PlcException("empty stack", "Popped while stack was empty.");
                    }
                }
                catch (PlcException e) {
                    throw new PlcException(e.getMessage(), this.errmsg(e.detailedMessage, fno, op, li, pt, tt, lt, pshift, tshift, lshift, executionStack, tailcalls));
                }
            }
            while (ip < code.length) {
                opc[0] = opc[0] + 1;
                if (opc[0] == 10000) {
                    throw new PlcException("ran too long", "Aborted due to running too many instructions in one update");
                }
                if (executionStack.size() > 64) {
                    throw new PlcException("stack too big", "Aborted due to too many values pushed onto stack.");
                }
                op = code[ip];
                li = lis[ip];
                block3 : switch (op) {
                    case '+': {
                        executionStack.push(true);
                        break;
                    }
                    case '-': {
                        executionStack.push(false);
                        break;
                    }
                    case 'A': {
                        executionStack.push(a);
                        break;
                    }
                    case 'B': {
                        executionStack.push(b);
                        break;
                    }
                    case 'C': {
                        executionStack.push(c);
                        break;
                    }
                    case '<': 
                    case '>': 
                    case 'e': {
                        mul = 1;
                        add = 0;
                        switch (code[ip]) {
                            case '<': {
                                add = -1;
                                break;
                            }
                            case '>': {
                                add = 1;
                                break;
                            }
                            case 'e': {
                                mul = 0;
                                break;
                            }
                        }
                        switch (code[++ip]) {
                            case 'P': 
                            case 'p': {
                                pshift = mul * pshift + add;
                                break block3;
                            }
                            case 'T': 
                            case 't': {
                                tshift = mul * tshift + add;
                                break block3;
                            }
                            case 'L': 
                            case 'l': {
                                lshift = mul * lshift + add;
                                break block3;
                            }
                        }
                        break;
                    }
                    case 'L': 
                    case 'S': {
                        table = null;
                        shift = 0;
                        switch (code[++ip]) {
                            case 'p': {
                                shift = pshift;
                            }
                            case 'P': {
                                table = pt;
                                break;
                            }
                            case 't': {
                                shift = tshift;
                            }
                            case 'T': {
                                table = tt;
                                break;
                            }
                            case 'l': {
                                shift = lshift;
                            }
                            case 'L': {
                                table = lt;
                                break;
                            }
                        }
                        if (table == null) break;
                        add = this.decodeAddress(code[++ip], shift);
                        if (op == 'S') {
                            table[add] = executionStack.pop();
                            break;
                        }
                        executionStack.push(table[add]);
                        break;
                    }
                    case 'd': {
                        executionStack.push(executionStack.peek());
                        break;
                    }
                    case 'p': {
                        executionStack.pop();
                        break;
                    }
                    case 'v': {
                        try {
                            level = this.parseNumber(code[++ip]);
                            executionStack.push((Boolean)executionStack.get(executionStack.size() - 1 - level));
                            break;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            throw new PlcException("bad stack pos", "Attempted to call peek on too small a stack.");
                        }
                    }
                    case 'x': {
                        x = executionStack.pop();
                        y = executionStack.pop();
                        executionStack.push(x);
                        executionStack.push(y);
                        break;
                    }
                    default: {
                        break;
                    }
                    case '!': {
                        executionStack.push(executionStack.pop() == false);
                        break;
                    }
                    case '^': {
                        executionStack.push(executionStack.pop() ^ executionStack.pop());
                        break;
                    }
                    case '&': {
                        executionStack.push(executionStack.pop() & executionStack.pop());
                        break;
                    }
                    case '|': {
                        executionStack.push(executionStack.pop() | executionStack.pop());
                        break;
                    }
                    case '=': {
                        executionStack.push(executionStack.pop() == executionStack.pop());
                        break;
                    }
                    case '.': {
                        ta = this.parseTableChar(code[++ip]);
                        tb = this.parseTableChar(code[++ip]);
                        tc = this.parseTableChar(code[++ip]);
                        td = this.parseTableChar(code[++ip]);
                        e = executionStack.pop();
                        f = executionStack.pop();
                        if (!e && !f) {
                            executionStack.push(ta);
                            break;
                        }
                        if (!e && f) {
                            executionStack.push(tb);
                            break;
                        }
                        if (e && !f) {
                            executionStack.push(tc);
                            break;
                        }
                        executionStack.push(td);
                        break;
                    }
                    case 'c': 
                    case 't': {
                        n = this.parseNumber(code[++ip]) * 10 + this.parseNumber(code[++ip]);
                        nArgs = this.parseNumber(code[++ip]);
                        arg = new boolean[nArgs];
                        if (n < 0) throw new PlcException("func not found", "Attempted to call nonexistent function #" + n);
                        if (n >= funs.length) {
                            throw new PlcException("func not found", "Attempted to call nonexistent function #" + n);
                        }
                        if (op == 'c') {
                            for (i = nArgs - 1; i >= 0; --i) {
                                arg[i] = executionStack.pop();
                            }
                            v = this.executeFunction(n, pt, tt, funs, a, b, c, arg, opc, rec + 1);
                            if (v == null) break;
                            executionStack.push(v);
                            break;
                        }
                        fno = n;
                        args = arg;
                        ++tailcalls;
                        continue block49;
                    }
                    case '[': {
                        if (executionStack.pop().booleanValue()) break;
                        ip = jt[ip];
                        break;
                    }
                    case ']': {
                        if (!executionStack.pop().booleanValue()) break;
                        ip = jt[ip];
                        break;
                    }
                    case 's': {
                        return null;
                    }
                    case 'r': {
                        return executionStack.pop();
                    }
                }
                ++ip;
            }
            return null;
        }
lbl226:
        // 1 sources

        catch (StackOverflowError e) {
            throw new PlcException("stack overflow", "Java stack overflow.");
        }
    }

    private String dumpStateText(boolean[] state) {
        char[] c = new char[state.length];
        for (int i = 0; i < state.length; ++i) {
            c[i] = state[i] ? 49 : 48;
        }
        return new String(c);
    }

    private String dumpStateText(Boolean[] state) {
        char[] c = new char[state.length];
        for (int i = 0; i < state.length; ++i) {
            c[i] = state[i] != false ? 49 : 48;
        }
        return new String(c);
    }

    @Override
    public String dumpState(boolean[] state) {
        return ChatColor.RED + "Persistent Variable Table: \n " + ChatColor.RESET + this.dumpStateText(state);
    }
}

