/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.weather;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.RegexUtil;
import org.bukkit.Server;
import org.bukkit.World;

public class WeatherControl
extends AbstractIC {
    public WeatherControl(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Weather Control";
    }

    @Override
    public String getSignTitle() {
        return "WEATHER CONTROL";
    }

    @Override
    public void trigger(ChipState chip) {
        int duration;
        boolean tstorm = false;
        int thunderDuration = duration = 24000;
        try {
            String[] st = RegexUtil.RIGHT_BRACKET_PATTERN.split(this.getSign().getLine(1), 2);
            if (st.length > 1) {
                tstorm = st[1].equalsIgnoreCase("t");
            }
            duration = Integer.parseInt(this.getSign().getLine(2));
        }
        catch (Exception st) {
            // empty catch block
        }
        try {
            thunderDuration = Integer.parseInt(this.getSign().getLine(3));
        }
        catch (Exception st) {
            // empty catch block
        }
        if (duration > 24000) {
            duration = 24000;
        }
        if (duration < 1) {
            duration = 1;
        }
        if (thunderDuration > 24000) {
            thunderDuration = 24000;
        }
        if (thunderDuration < 1) {
            thunderDuration = 1;
        }
        World world = CraftBookBukkitUtil.toSign(this.getSign()).getWorld();
        if (chip.getInput(0)) {
            world.setStorm(true);
            world.setWeatherDuration(duration);
            if (tstorm) {
                world.setThundering(true);
                world.setThunderDuration(thunderDuration);
            }
            chip.setOutput(0, true);
        } else {
            world.setThundering(false);
            world.setStorm(false);
            chip.setOutput(0, false);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new WeatherControl(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Set rain and thunder duration.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Set weather state", "Input 1"};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"rain duration", "thunder duration"};
        }
    }
}

