/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.weather;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import org.bukkit.Server;

public class TimeSet
extends AbstractSelfTriggeredIC {
    long time;

    public TimeSet(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Time Set";
    }

    @Override
    public String getSignTitle() {
        return "TIME SET";
    }

    @Override
    public void load() {
        try {
            this.time = Long.parseLong(this.getSign().getLine(2));
        }
        catch (NumberFormatException ex) {
            this.time = -1L;
        }
    }

    @Override
    public void trigger(ChipState chip) {
        try {
            if (chip.getInput(0) && this.time >= 0L) {
                CraftBookBukkitUtil.toSign(this.getSign()).getWorld().setTime(this.time);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void think(ChipState chip) {
        try {
            if (chip.getInput(0) && this.time >= 0L) {
                CraftBookBukkitUtil.toSign(this.getSign()).getWorld().setTime(this.time);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new TimeSet(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Set time when triggered.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"time to set", null};
        }
    }
}

