/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.weather;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import org.bukkit.Server;

public class ServerTimeModulus
extends AbstractIC {
    public ServerTimeModulus(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Server Time Modulus";
    }

    @Override
    public String getSignTitle() {
        return "SERVER TIME MOD";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isServerTimeOdd());
        }
    }

    private boolean isServerTimeOdd() {
        long time = Math.abs(CraftBookBukkitUtil.toSign(this.getSign()).getBlock().getWorld().getTime()) % 2L;
        return time == 1L;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new ServerTimeModulus(this.getServer(), sign, this);
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC1025''' outputs whether the world time is either odd or even based on the application of the modulus of two on the server time.", "If the server time is even, a low will be outputted. If the server time is odd, a high will be outputted."};
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "Output is world time is odd"};
        }

        @Override
        public String getShortDescription() {
            return "Outputs high if time is odd.";
        }
    }
}

