/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.util.ICUtil;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.data.Waterlogged;

public class WaterSensor
extends AbstractSelfTriggeredIC {
    private Block center;

    public WaterSensor(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.center = ICUtil.parseBlockLocation(this.getSign());
    }

    @Override
    public String getTitle() {
        return "Water Sensor";
    }

    @Override
    public String getSignTitle() {
        return "WATER SENSOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.hasWater());
        }
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.hasWater());
    }

    protected boolean hasWater() {
        return this.center.getType() == Material.WATER || this.center.getBlockData() instanceof Waterlogged && ((Waterlogged)this.center.getBlockData()).isWaterlogged();
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new WaterSensor(this.getServer(), sign, this);
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }

        @Override
        public String getShortDescription() {
            return "Outputs high if water is at the given offset.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+ox:y:z offset", null};
        }
    }
}

