/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.PlayerType;
import com.sk89q.craftbook.util.SearchArea;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class PlayerSensor
extends AbstractSelfTriggeredIC {
    private static final Pattern NAME_STRIPPER = Pattern.compile("[gpnta!^]*:");
    private SearchArea area;
    private PlayerType type;
    private String nameLine;
    private boolean invertOutput = false;
    private boolean invertDetection = false;

    public PlayerSensor(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Player Detection";
    }

    @Override
    public String getSignTitle() {
        return "P-DETECTION";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.invertOutput != this.isDetected());
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, this.invertOutput != this.isDetected());
    }

    @Override
    public void load() {
        this.type = this.getLine(3).contains(":") ? PlayerType.getFromChar(this.getLine(3).replace("!", "").replace("^", "").trim().toCharArray()[0]) : PlayerType.NAME;
        this.invertOutput = this.getLine(3).contains("!");
        this.invertDetection = this.getLine(3).contains("^");
        this.nameLine = NAME_STRIPPER.matcher(this.getLine(3)).replaceAll(Matcher.quoteReplacement("")).trim();
        this.area = SearchArea.createArea(CraftBookBukkitUtil.toSign(this.getSign()).getBlock(), this.getLine(2));
    }

    private boolean isDetected() {
        if (!this.nameLine.isEmpty() && this.type == PlayerType.NAME && !this.invertDetection) {
            Player p = Bukkit.getPlayerExact((String)this.nameLine);
            return p != null && this.area.isWithinArea(p.getLocation());
        }
        for (Player p : this.area.getPlayersInArea()) {
            if (p == null || !p.isValid()) continue;
            if (this.nameLine.isEmpty()) {
                return true;
            }
            if (this.invertDetection == this.type.doesPlayerPass(p, this.nameLine)) continue;
            return true;
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new PlayerSensor(this.getServer(), sign, this);
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            if (!SearchArea.createArea(CraftBookBukkitUtil.toSign(sign).getBlock(), sign.getLine(2)).isValid()) {
                throw new ICVerificationException("Invalid SearchArea on line 3!");
            }
        }

        @Override
        public String getShortDescription() {
            return "Detects players within a radius.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"SearchArea", "PlayerType"};
        }
    }
}

