/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.util.ICUtil;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;

public class LavaSensor
extends AbstractSelfTriggeredIC {
    private Block center;

    public LavaSensor(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.center = ICUtil.parseBlockLocation(this.getSign());
    }

    @Override
    public String getTitle() {
        return "Lava Sensor";
    }

    @Override
    public String getSignTitle() {
        return "LAVA SENSOR";
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.hasLava());
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.hasLava());
        }
    }

    protected boolean hasLava() {
        Material blockID = this.center.getType();
        return blockID == Material.LAVA;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new LavaSensor(this.getServer(), sign, this);
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }

        @Override
        public String getShortDescription() {
            return "Outputs high if lava is at given offset.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"x:y:z Offset", null};
        }
    }
}

