/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.mechanics.ic.SelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.gates.world.sensors.ItemSensor;
import com.sk89q.craftbook.util.ICUtil;
import org.bukkit.Server;

public class ItemNotSensor
extends ItemSensor
implements SelfTriggeredIC {
    public ItemNotSensor(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Item Not Sensor";
    }

    @Override
    public String getSignTitle() {
        return "ITEM NOT SENSOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, !this.isDetected());
        }
    }

    @Override
    public void think(ChipState state) {
        state.setOutput(0, !this.isDetected());
    }

    public static class Factory
    extends ItemSensor.Factory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new ItemNotSensor(this.getServer(), sign, this);
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }

        @Override
        public String getShortDescription() {
            return "Detects if an item is NOT within a given radius";
        }
    }
}

