/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.ConfigurableIC;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICMechanic;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.WirelessTransmitter;
import com.sk89q.craftbook.util.profile.Profile;
import com.sk89q.craftbook.util.profile.resolver.HttpRepositoryService;
import com.sk89q.craftbook.util.profile.resolver.ProfileService;
import com.sk89q.util.yaml.YAMLProcessor;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;

public class WirelessReceiver
extends AbstractSelfTriggeredIC {
    private String band;

    public WirelessReceiver(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.band = this.getSign().getLine(2);
        if (!this.getLine(3).trim().isEmpty()) {
            if (CraftBookPlugin.inst().getConfiguration().convertNamesToCBID && CraftBookPlugin.inst().getUUIDMappings().getUUID(this.getLine(3)) == null) {
                String line3 = this.getLine(3);
                OfflinePlayer player = Bukkit.getOfflinePlayer((String)this.getLine(3));
                if (player.hasPlayedBefore()) {
                    try {
                        ProfileService resolver = HttpRepositoryService.forMinecraft();
                        Profile profile = resolver.findByName(player.getName());
                        UUID uuid = profile.getUniqueId();
                        this.band = CraftBookPlugin.inst().getUUIDMappings().getCBID(uuid);
                        this.getSign().setLine(3, line3);
                        this.getSign().update(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.band = this.band + this.getSign().getLine(3);
        }
    }

    @Override
    public String getTitle() {
        return "Wireless Receiver";
    }

    @Override
    public String getSignTitle() {
        return "RECEIVER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.getOutput());
        }
    }

    public boolean getOutput() {
        Boolean val = WirelessTransmitter.getValue(this.band);
        if (val == null) {
            return false;
        }
        return val;
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.getOutput());
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public static class Factory
    extends AbstractICFactory
    implements ConfigurableIC {
        public boolean requirename;

        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new WirelessReceiver(this.getServer(), sign, this);
        }

        @Override
        public String[] getLongDescription() {
            return new String[]{"The '''MC1111''' receives the state in a particular ''band'' or ''network'' when the clock input goes from low to high.", "The corresponding transmitter is the [[../MC1110/]] IC.", "", "If there are multiple transmitters for the same band, the last one to transmit to a particular band will have its state apply until the next transmission."};
        }

        @Override
        public String getShortDescription() {
            return "Recieves signal from wireless transmitter.";
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "State of Wireless Band"};
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Wireless Band", "Player's CBID (Automatic)"};
        }

        @Override
        public void checkPlayer(ChangedSign sign, CraftBookPlayer player) throws ICVerificationException {
            if (this.requirename && (sign.getLine(3).isEmpty() || !ICMechanic.hasRestrictedPermissions(player, this, "MC1111"))) {
                sign.setLine(3, player.getCraftBookId());
            } else if (!sign.getLine(3).isEmpty() && !ICMechanic.hasRestrictedPermissions(player, this, "MC1111")) {
                sign.setLine(3, player.getCraftBookId());
            }
            sign.update(false);
        }

        @Override
        public void addConfiguration(YAMLProcessor config, String path) {
            config.setComment(path + "per-player", "Require a name to be entered on the sign. This allows for 'per-player' wireless bands. This is done automatically.");
            this.requirename = config.getBoolean(path + "per-player", false);
        }
    }
}

