/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.ConfigurableIC;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.EntityType;
import com.sk89q.craftbook.util.EntityUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.SearchArea;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.math.Vector3;
import java.util.EnumSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.projectiles.ProjectileSource;

public class SentryGun
extends AbstractSelfTriggeredIC {
    private Set<EntityType> types;
    private SearchArea area;
    private float speed;
    private boolean manned;

    public SentryGun(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public void load() {
        this.speed = 0.8f;
        this.types = EntityType.getDetected(this.getSign().getLine(2).split(":")[0]);
        if (this.types == null || this.types.isEmpty()) {
            this.types = EnumSet.of(EntityType.MOB_HOSTILE);
        }
        if (this.getSign().getLine(2).split(":").length > 1) {
            this.speed = Float.parseFloat(this.getSign().getLine(2).split(":")[1]);
        }
        this.area = SearchArea.createArea(this.getLocation().getBlock(), this.getLine(3));
        this.manned = this.getSign().getLine(2).split(":").length > 2 && this.getSign().getLine(2).split(":")[2].equalsIgnoreCase("MAN");
    }

    @Override
    public String getTitle() {
        return "Sentry Gun";
    }

    @Override
    public String getSignTitle() {
        return "SENTRY GUN";
    }

    @Override
    public void trigger(ChipState chip) {
        this.shoot();
    }

    @Override
    public void think(ChipState chip) {
        if (((Factory)this.getFactory()).inverted == chip.getInput(0)) {
            this.trigger(chip);
        }
    }

    public void shoot() {
        Player shooter;
        Player player = shooter = this.manned ? this.getShootingPlayer() : null;
        if (shooter != null) {
            Arrow ar = this.area.getWorld().spawnArrow(BlockUtil.getBlockCentre(this.area.getCenter() == null ? this.area.getCenter().getBlock() : this.getBackBlock()).add(0.0, 1.0, 0.0), shooter.getLocation().getDirection().normalize(), this.speed, 0.0f);
            ar.setShooter((ProjectileSource)shooter);
            ar.setTicksLived(2500);
        } else {
            for (Entity ent : this.area.getEntitiesInArea()) {
                if (!(ent instanceof LivingEntity)) continue;
                boolean hasFound = false;
                for (EntityType type : this.types) {
                    if (!type.is(ent)) continue;
                    hasFound = true;
                    break;
                }
                if (!hasFound) continue;
                double yOff = ((LivingEntity)ent).getEyeHeight();
                Location k = LocationUtil.getCenterOfBlock(LocationUtil.getNextFreeSpace(this.getBackBlock(), BlockFace.UP));
                Arrow ar = this.area.getWorld().spawnArrow(k, ent.getLocation().add(0.0, yOff, 0.0).subtract(k.clone().add(0.5, 0.5, 0.5)).toVector().normalize(), this.speed, 0.0f);
                if (((LivingEntity)ent).hasLineOfSight((Entity)ar)) break;
                ar.remove();
            }
        }
    }

    public Player getShootingPlayer() {
        Block b = this.getBackBlock().getRelative(0, 1, 0);
        for (Entity ent : LocationUtil.getNearbyEntities(BlockUtil.getBlockCentre(b), Vector3.at((double)2.0, (double)2.0, (double)2.0))) {
            if (!EntityUtil.isEntityInBlock(ent, b) || !(ent instanceof Player)) continue;
            return (Player)ent;
        }
        return null;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC,
    ConfigurableIC {
        public boolean inverted = false;

        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new SentryGun(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Shoots nearby mobs with arrows.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Mob Type{:power:MAN}", "SearchArea"};
        }

        @Override
        public void addConfiguration(YAMLProcessor config, String path) {
            this.inverted = config.getBoolean(path + "inverted", false);
        }
    }
}

