/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICManager;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.RegexUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ProgrammableFireworkShow
extends AbstractSelfTriggeredIC {
    private String show;
    private FireworkShowHandler handler;
    private boolean stopOnLow;

    public ProgrammableFireworkShow(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public boolean isAlwaysST() {
        return true;
    }

    @Override
    public String getTitle() {
        return "Programmable Firework Show";
    }

    @Override
    public String getSignTitle() {
        return "FIREWORKS";
    }

    @Override
    public void load() {
        this.show = this.getLine(2).trim();
        try {
            this.handler = new FireworkShowHandler(this.show);
        }
        catch (IOException e) {
            CraftBookPlugin.logger().severe("Failed to load firework file for IC at " + this.getSign().getBlock().getLocation().toString());
            CraftBookBukkitUtil.printStacktrace(e);
        }
        String[] bits = RegexUtil.COMMA_PATTERN.split(this.getLine(3));
        if (bits.length > 0) {
            this.stopOnLow = Boolean.getBoolean(bits[0]);
        }
    }

    @Override
    public void trigger(ChipState chip) {
        if (this.handler == null) {
            return;
        }
        if (chip.getInput(0) && !this.handler.isShowRunning()) {
            this.handler.startShow();
        } else if (this.handler.isShowRunning() && this.stopOnLow) {
            this.handler.stopShow();
        }
    }

    @Override
    public void think(ChipState chip) {
        if (this.handler == null) {
            return;
        }
        if (this.handler.isShowRunning() != chip.getOutput(0)) {
            chip.setOutput(0, this.handler.isShowRunning());
        }
    }

    public static interface ShowInterpreter
    extends Runnable {
        public void setRunning(boolean var1);

        public boolean isRunning();
    }

    public class FireworkShowHandler {
        ShowInterpreter show;
        String showName;
        int position;
        List<String> lines = new ArrayList<String>();
        BukkitTask task;
        boolean fyrestone = false;

        public FireworkShowHandler(String showName) throws IOException {
            this.showName = showName;
            this.readShow();
        }

        public void readShow() throws IOException {
            this.lines.clear();
            File firework = new File(ICManager.inst().getFireworkFolder(), this.showName + ".txt");
            if (!firework.exists()) {
                this.fyrestone = true;
                firework = new File(ICManager.inst().getFireworkFolder(), this.showName + ".fwk");
                if (!firework.exists()) {
                    throw new FileNotFoundException("Firework File Not Found! " + firework.getName());
                }
            } else {
                this.fyrestone = false;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(firework), "UTF-8"));
            String line = "";
            while ((line = br.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                this.lines.add(line);
            }
            br.close();
        }

        public boolean isShowRunning() {
            return this.show != null && this.show.isRunning();
        }

        public void stopShow() {
            this.show.setRunning(false);
        }

        public void startShow() {
            this.position = 0;
            if (this.task != null) {
                this.task.cancel();
            }
            ShowInterpreter show = !this.fyrestone ? new BasicShowInterpreter() : new FyrestoneInterpreter();
            this.task = Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), (Runnable)show);
        }

        private class BasicShowInterpreter
        implements ShowInterpreter {
            private boolean isRunning = false;

            private BasicShowInterpreter() {
            }

            @Override
            public void run() {
                this.isRunning = true;
                while (this.isRunning && FireworkShowHandler.this.position < FireworkShowHandler.this.lines.size()) {
                    String[] bits;
                    String line = FireworkShowHandler.this.lines.get(FireworkShowHandler.this.position);
                    ++FireworkShowHandler.this.position;
                    if (line.startsWith("#") || (bits = RegexUtil.COLON_PATTERN.split(line, 2)).length < 2) continue;
                    if (bits[0].equalsIgnoreCase("wait")) {
                        BasicShowInterpreter show = new BasicShowInterpreter();
                        FireworkShowHandler.this.task = Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)show, Long.parseLong(bits[1]));
                        return;
                    }
                    if (!bits[0].equalsIgnoreCase("launch")) continue;
                    String errorLocation = "Unknown";
                    try {
                        String[] data = RegexUtil.SEMICOLON_PATTERN.split(bits[1]);
                        errorLocation = "Offset";
                        String[] offset = RegexUtil.COMMA_PATTERN.split(data[0]);
                        Location location = CraftBookBukkitUtil.toSign(ProgrammableFireworkShow.this.getSign()).getLocation();
                        location.add(Double.parseDouble(offset[0]), Double.parseDouble(offset[1]), Double.parseDouble(offset[2]));
                        errorLocation = "Duration";
                        double duration = Double.parseDouble(data[1]);
                        errorLocation = "Shape";
                        FireworkEffect.Type type = data[2].equalsIgnoreCase("sball") || data[2].equalsIgnoreCase("smallball") ? FireworkEffect.Type.BALL : (data[2].equalsIgnoreCase("lball") || data[2].equalsIgnoreCase("largeball") ? FireworkEffect.Type.BALL_LARGE : (data[2].equalsIgnoreCase("burst") ? FireworkEffect.Type.BURST : (data[2].equalsIgnoreCase("creeper") ? FireworkEffect.Type.CREEPER : (data[2].equalsIgnoreCase("star") ? FireworkEffect.Type.STAR : FireworkEffect.Type.BALL))));
                        errorLocation = "Colour";
                        String[] rgb = RegexUtil.COMMA_PATTERN.split(data[3]);
                        Color colour = Color.fromRGB((int)Integer.parseInt(rgb[0]), (int)Integer.parseInt(rgb[1]), (int)Integer.parseInt(rgb[2]));
                        errorLocation = "Fade";
                        rgb = RegexUtil.COMMA_PATTERN.split(data[4]);
                        Color fade = Color.fromRGB((int)Integer.parseInt(rgb[0]), (int)Integer.parseInt(rgb[1]), (int)Integer.parseInt(rgb[2]));
                        boolean flicker = false;
                        boolean trail = false;
                        if (data.length > 5) {
                            errorLocation = "Effects";
                            if (data[5].equalsIgnoreCase("twinkle")) {
                                flicker = true;
                            } else if (data[5].equalsIgnoreCase("trail")) {
                                trail = true;
                            }
                        }
                        errorLocation = "Creation";
                        FireworkEffect effect = FireworkEffect.builder().with(type).withColor(colour).withFade(fade).flicker(flicker).trail(trail).build();
                        if (!location.getWorld().isChunkLoaded(location.getBlockX() >> 4, location.getBlockZ() >> 4)) continue;
                        Firework firework = (Firework)location.getWorld().spawnEntity(location, EntityType.FIREWORK);
                        FireworkMeta meta = firework.getFireworkMeta();
                        meta.addEffect(effect);
                        meta.setPower((int)duration * 2);
                        firework.setFireworkMeta(meta);
                    }
                    catch (Exception e) {
                        CraftBookPlugin.logger().severe("Error occured while doing: " + errorLocation + ". Whilst reading line " + FireworkShowHandler.this.position + " of the firework file " + FireworkShowHandler.this.showName + "!");
                        CraftBookBukkitUtil.printStacktrace(e);
                    }
                }
                this.isRunning = false;
            }

            @Override
            public void setRunning(boolean isRunning) {
                this.isRunning = isRunning;
            }

            @Override
            public boolean isRunning() {
                return this.isRunning;
            }
        }

        private class FyrestoneInterpreter
        implements ShowInterpreter {
            Map<String, List<FireworkEffect>> effects = new HashMap<String, List<FireworkEffect>>();
            String currentBuilding = null;
            Location location;
            float duration;
            boolean preciseDuration;
            FireworkEffect.Builder builder;
            boolean isRunning;

            public FyrestoneInterpreter() {
                this.location = CraftBookBukkitUtil.toSign(ProgrammableFireworkShow.this.getSign()).getLocation();
                this.duration = 0.5f;
                this.preciseDuration = false;
                this.builder = FireworkEffect.builder();
                this.isRunning = false;
                this.isRunning = true;
            }

            public FyrestoneInterpreter(Map<String, List<FireworkEffect>> effects, String currentBuilding, Location location, float duration, FireworkEffect.Builder builder) {
                this.location = CraftBookBukkitUtil.toSign(ProgrammableFireworkShow.this.getSign()).getLocation();
                this.duration = 0.5f;
                this.preciseDuration = false;
                this.builder = FireworkEffect.builder();
                this.isRunning = false;
                this.effects = effects;
                this.currentBuilding = currentBuilding;
                this.location = location;
                this.duration = duration;
                this.builder = builder;
            }

            @Override
            public void run() {
                while (this.isRunning && FireworkShowHandler.this.position < FireworkShowHandler.this.lines.size()) {
                    String[] bits;
                    String line = FireworkShowHandler.this.lines.get(FireworkShowHandler.this.position);
                    ++FireworkShowHandler.this.position;
                    if (line.trim().startsWith("#") || line.trim().isEmpty()) continue;
                    int commentIndex = line.indexOf(35);
                    if (commentIndex >= 0) {
                        line = line.substring(0, commentIndex).trim();
                    }
                    if (line.startsWith("set.")) {
                        String[] rgb;
                        if (this.currentBuilding == null) continue;
                        String[] args = RegexUtil.SPACE_PATTERN.split(line = line.replace("set.", "").trim());
                        if (args[0].equalsIgnoreCase("shape")) {
                            FireworkEffect.Type type = args[1].equalsIgnoreCase("sball") || args[1].equalsIgnoreCase("smallball") ? FireworkEffect.Type.BALL : (args[1].equalsIgnoreCase("lball") || args[1].equalsIgnoreCase("largeball") ? FireworkEffect.Type.BALL_LARGE : (args[1].equalsIgnoreCase("burst") ? FireworkEffect.Type.BURST : (args[1].equalsIgnoreCase("creeper") ? FireworkEffect.Type.CREEPER : (args[1].equalsIgnoreCase("star") ? FireworkEffect.Type.STAR : FireworkEffect.Type.BALL))));
                            this.builder.with(type);
                            continue;
                        }
                        if (args[0].equalsIgnoreCase("color")) {
                            rgb = RegexUtil.COMMA_PATTERN.split(args[1]);
                            Color color = Color.fromRGB((int)Integer.parseInt(rgb[0]), (int)Integer.parseInt(rgb[1]), (int)Integer.parseInt(rgb[2]));
                            this.builder.withColor(color);
                            continue;
                        }
                        if (args[0].equalsIgnoreCase("fade")) {
                            rgb = RegexUtil.COMMA_PATTERN.split(args[1]);
                            Color fade = Color.fromRGB((int)Integer.parseInt(rgb[0]), (int)Integer.parseInt(rgb[1]), (int)Integer.parseInt(rgb[2]));
                            this.builder.withFade(fade);
                            continue;
                        }
                        if (args[0].equalsIgnoreCase("flicker") || args[0].equalsIgnoreCase("twinkle")) {
                            this.builder.flicker(true);
                            continue;
                        }
                        if (!args[0].equalsIgnoreCase("trail")) continue;
                        this.builder.trail(true);
                        continue;
                    }
                    if (line.startsWith("location ")) {
                        String[] args = RegexUtil.COMMA_PATTERN.split(line.replace("location ", ""));
                        double x = Double.parseDouble(args[0]);
                        double y = Double.parseDouble(args[1]);
                        double z = Double.parseDouble(args[2]);
                        this.location = CraftBookBukkitUtil.toSign(ProgrammableFireworkShow.this.getSign()).getLocation().add(x, y, z);
                        continue;
                    }
                    if (line.startsWith("duration ")) {
                        bits = RegexUtil.SPACE_PATTERN.split(line.replace("duration ", ""));
                        this.duration = Float.parseFloat(bits[0]);
                        this.preciseDuration = bits.length > 1 && bits[1].equalsIgnoreCase("precise");
                        continue;
                    }
                    if (line.startsWith("wait ")) {
                        FyrestoneInterpreter nshow = new FyrestoneInterpreter(this.effects, this.currentBuilding, this.location, this.duration, this.builder);
                        nshow.setRunning(this.isRunning);
                        FireworkShowHandler.this.task = Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)nshow, Long.parseLong(line.replace("wait ", "")));
                        FireworkShowHandler.this.show = nshow;
                        return;
                    }
                    if (line.startsWith("sound ")) {
                        bits = RegexUtil.SPACE_PATTERN.split(line.replace("sound ", ""));
                        Sound sound = Sound.valueOf((String)bits[0]);
                        Location sloc = this.location.clone();
                        float volume = 1.0f;
                        float pitch = 1.0f;
                        if (bits.length > 1) {
                            String[] args = RegexUtil.COMMA_PATTERN.split(bits[1]);
                            double x = Double.parseDouble(args[0]);
                            double y = Double.parseDouble(args[1]);
                            double z = Double.parseDouble(args[2]);
                            sloc = CraftBookBukkitUtil.toSign(ProgrammableFireworkShow.this.getSign()).getLocation().add(x, y, z);
                            if (bits.length > 2) {
                                volume = Float.parseFloat(bits[2]);
                                if (bits.length > 3) {
                                    pitch = Float.parseFloat(bits[3]);
                                }
                            }
                        }
                        sloc.getWorld().playSound(sloc, sound, volume, pitch);
                        continue;
                    }
                    if (line.startsWith("start ")) {
                        this.currentBuilding = line.replace("start ", "");
                        this.builder = FireworkEffect.builder();
                        continue;
                    }
                    if (line.startsWith("build")) {
                        List<Object> effectList;
                        if (this.currentBuilding == null) continue;
                        if (this.effects.containsKey(this.currentBuilding)) {
                            effectList = this.effects.get(this.currentBuilding);
                            effectList.add(this.builder.build());
                            this.effects.put(this.currentBuilding, effectList);
                        } else {
                            effectList = new ArrayList<FireworkEffect>();
                            effectList.add(this.builder.build());
                            this.effects.put(this.currentBuilding, effectList);
                        }
                        this.currentBuilding = null;
                        continue;
                    }
                    if (!line.startsWith("launch ") || !this.effects.containsKey(line.replace("launch ", "")) || !this.location.getWorld().isChunkLoaded(this.location.getBlockX() >> 4, this.location.getBlockZ() >> 4)) continue;
                    Firework firework = (Firework)this.location.getWorld().spawnEntity(this.location, EntityType.FIREWORK);
                    FireworkMeta meta = firework.getFireworkMeta();
                    for (FireworkEffect effect : this.effects.get(line.replace("launch ", ""))) {
                        meta.addEffect(effect);
                    }
                    meta.setPower((int)this.duration * 2);
                    firework.setFireworkMeta(meta);
                    if (!this.preciseDuration) continue;
                    Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> ((Firework)firework).detonate(), (long)(this.duration * 10.0f));
                }
                this.isRunning = false;
            }

            @Override
            public void setRunning(boolean isRunning) {
                this.isRunning = isRunning;
            }

            @Override
            public boolean isRunning() {
                return this.isRunning;
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new ProgrammableFireworkShow(this.getServer(), sign, this);
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            if (sign.getLine(2).trim().isEmpty() || !new File(ICManager.inst().getFireworkFolder(), sign.getLine(2).trim() + ".txt").exists() && !new File(ICManager.inst().getFireworkFolder(), sign.getLine(2).trim() + ".fwk").exists()) {
                throw new ICVerificationException("A valid firework show is required on line 3!");
            }
        }

        @Override
        public String getShortDescription() {
            return "Plays a firework show from a file.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Name of firework show", "true to stop on low"};
        }
    }
}

