/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICMechanic;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.util.PlayerType;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SearchArea;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class MessageSender
extends AbstractIC {
    PlayerType type;
    String name;
    String message;
    SearchArea area;

    public MessageSender(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Message Sender";
    }

    @Override
    public String getSignTitle() {
        return "MESSAGE SENDER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.sendMessage());
        }
    }

    @Override
    public void load() {
        String[] bits;
        for (String bit : bits = RegexUtil.AMPERSAND_PATTERN.split(this.getLine(2))) {
            if (bit.contains(":")) {
                this.type = PlayerType.getFromChar(bit.trim().toCharArray()[0]);
            } else if (this.type == null) {
                this.type = PlayerType.ALL;
            }
            bit = bit.replace("g:", "").replace("p:", "").replace("n:", "").replace("t:", "").replace("a:", "").trim();
            if (SearchArea.isValidArea(this.getLocation().getBlock(), bit)) {
                this.area = SearchArea.createArea(this.getLocation().getBlock(), bit);
                continue;
            }
            this.name = bit;
        }
        this.message = this.getLine(3);
    }

    private boolean sendMessage() {
        boolean sent = false;
        if (this.area != null) {
            for (Player p : this.area.getPlayersInArea()) {
                if (!this.type.doesPlayerPass(p, this.name)) continue;
                p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.message));
                sent = true;
            }
        } else {
            Player player;
            if (this.type == PlayerType.NAME && (player = Bukkit.getPlayer((String)this.name)) != null) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.message));
                sent = true;
            }
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                if (this.type.doesPlayerPass(player2, this.name)) {
                    player2.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.message));
                    sent = true;
                    continue;
                }
                if (!this.name.equalsIgnoreCase("BROADCAST") && !this.name.isEmpty()) continue;
                this.getServer().broadcastMessage(this.message);
                sent = true;
            }
        }
        return sent;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new MessageSender(this.getServer(), sign, this);
        }

        @Override
        public void checkPlayer(ChangedSign sign, CraftBookPlayer player) throws ICVerificationException {
            if (!sign.getLine(2).equalsIgnoreCase(player.getName()) && !ICMechanic.hasRestrictedPermissions(player, this, "mc1510")) {
                throw new ICVerificationException("You don't have permission to use other players!");
            }
        }

        @Override
        public String getShortDescription() {
            return "Sends a pre-written message on high.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"PlayerType, SearchArea, or BROADCAST for whole server", "Message to send."};
        }
    }
}

