/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.util.SearchArea;
import com.sk89q.craftbook.util.jinglenote.Playlist;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class Jukebox
extends AbstractSelfTriggeredIC {
    public static Map<Location, Playlist> playlists;
    Map<String, SearchArea> players;
    SearchArea area;

    public Jukebox(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void unload() {
        if (playlists.containsKey(this.getBackBlock().getLocation())) {
            playlists.remove(this.getBackBlock().getLocation()).stopPlaylist();
        }
    }

    @Override
    public boolean isAlwaysST() {
        return true;
    }

    @Override
    public void load() {
        String plist = this.getLine(2);
        if (!this.getLine(3).isEmpty()) {
            this.area = SearchArea.createArea(this.getLocation().getBlock(), this.getLine(3));
        }
        if (!playlists.containsKey(this.getBackBlock().getLocation())) {
            playlists.put(this.getBackBlock().getLocation(), new Playlist(plist));
        }
        this.players = new HashMap<String, SearchArea>();
    }

    @Override
    public String getTitle() {
        return "Jukebox";
    }

    @Override
    public String getSignTitle() {
        return "JUKEBOX";
    }

    @Override
    public void trigger(ChipState chip) {
        Playlist playlist = playlists.get(this.getBackBlock().getLocation());
        if (playlist == null) {
            return;
        }
        if (chip.getInput(0) && !playlist.isPlaying()) {
            playlist.startPlaylist();
        } else if (!chip.getInput(0) && playlist.isPlaying()) {
            playlist.stopPlaylist();
        }
        if (chip.getInput(0)) {
            boolean hasChanged = false;
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                if (this.area != null && !this.area.isWithinArea(p.getLocation())) {
                    if (!this.players.containsKey(p.getName())) continue;
                    this.players.remove(p.getName());
                    hasChanged = true;
                    continue;
                }
                if (this.players.containsKey(p.getName())) continue;
                this.players.put(p.getName(), this.area);
                hasChanged = true;
            }
            if (hasChanged) {
                playlist.getPlaylistInterpreter().setPlayers(this.players);
            }
        }
        chip.setOutput(0, playlist.isPlaying());
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
            playlists = new HashMap<Location, Playlist>();
        }

        @Override
        public IC create(ChangedSign sign) {
            return new Jukebox(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Plays a Playlist.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"Playlist Name", "Radius"};
        }
    }
}

