/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.items;

import com.google.common.collect.Lists;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ranged.RangedCollectEvent;
import com.sk89q.craftbook.util.ICUtil;
import com.sk89q.craftbook.util.InventoryUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.math.Vector3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class RangedCollector
extends AbstractSelfTriggeredIC {
    private Vector3 radius;
    private Location centre;
    private boolean include = false;
    private Block chest;
    private List<ItemStack> filters = new ArrayList<ItemStack>();

    public RangedCollector(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Ranged Collector";
    }

    @Override
    public String getSignTitle() {
        return "RANGED COLLECTOR";
    }

    @Override
    public void think(ChipState chip) {
        if (chip.getInput(0)) {
            return;
        }
        chip.setOutput(0, this.collect());
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.collect());
        }
    }

    @Override
    public void load() {
        this.radius = ICUtil.parseRadius(this.getSign());
        String radiusString = this.radius.getX() + "," + this.radius.getY() + "," + this.radius.getZ();
        if (this.radius.getX() == this.radius.getY() && this.radius.getY() == this.radius.getZ()) {
            radiusString = String.valueOf(this.radius.getX());
        }
        if (this.getLine(2).contains("=")) {
            this.getSign().setLine(2, radiusString + "=" + RegexUtil.EQUALS_PATTERN.split(this.getLine(2))[1]);
            this.centre = ICUtil.parseBlockLocation(this.getSign(), 2).getLocation();
        } else {
            this.getSign().setLine(2, radiusString);
            this.centre = this.getBackBlock().getLocation();
        }
        this.include = !this.getLine(3).startsWith("-");
        for (String bit : this.getLine(3).replace("-", "").split(",")) {
            ItemStack item;
            if (bit.trim().length() <= 0 || !ItemUtil.isStackValid(item = ItemSyntax.getItem(bit))) continue;
            this.filters.add(ItemSyntax.getItem(bit));
        }
        this.chest = this.getBackBlock().getRelative(0, 1, 0);
    }

    public boolean collect() {
        boolean collected = false;
        ArrayList itemsForChest = Lists.newArrayList();
        for (Entity entity : LocationUtil.getNearbyEntities(this.centre, this.radius)) {
            if (!entity.isValid() || !(entity instanceof Item)) continue;
            ItemStack stack = ((Item)entity).getItemStack();
            if (!ItemUtil.isStackValid(stack)) {
                return false;
            }
            boolean passed = this.filters.isEmpty() || !this.include;
            for (ItemStack filter : this.filters) {
                if (!ItemUtil.isStackValid(filter)) continue;
                if (this.include && ItemUtil.areItemsIdentical(filter, stack)) {
                    passed = true;
                    break;
                }
                if (this.include || !ItemUtil.areItemsIdentical(filter, stack)) continue;
                passed = false;
                break;
            }
            if (!passed) continue;
            BlockFace back = SignUtil.getBack(CraftBookBukkitUtil.toSign(this.getSign()).getBlock());
            Block pipe = this.getBackBlock().getRelative(back);
            RangedCollectEvent event = new RangedCollectEvent(pipe, (Item)entity, new ArrayList<ItemStack>(Collections.singletonList(stack)), this.getBackBlock());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            if (event.getItems().isEmpty()) {
                entity.remove();
                return true;
            }
            itemsForChest.add((Item)entity);
        }
        if (!itemsForChest.isEmpty()) {
            if (!InventoryUtil.doesBlockHaveInventory(this.chest)) {
                return false;
            }
            InventoryHolder chestState = (InventoryHolder)this.chest.getState();
            for (Item entity : itemsForChest) {
                ItemStack stack = entity.getItemStack();
                List<ItemStack> leftovers = InventoryUtil.addItemsToInventory(chestState, false, stack);
                if (leftovers.isEmpty()) {
                    entity.remove();
                } else if (ItemUtil.areItemsIdentical(leftovers.get(0), stack) && leftovers.get(0).getAmount() != stack.getAmount()) {
                    entity.setItemStack(leftovers.get(0));
                }
                collected = true;
            }
        }
        return collected;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new RangedCollector(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Collects items at a range into above chest.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"radius=x:y:z offset", "{-}id:data{,id:data}"};
        }
    }
}

