/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.items;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.mechanics.pipe.PipeRequestEvent;
import com.sk89q.craftbook.util.ICUtil;
import com.sk89q.craftbook.util.InventoryUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.SignUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ContainerStocker
extends AbstractSelfTriggeredIC {
    ItemStack item;
    Location offset;

    public ContainerStocker(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.offset = this.getLine(3).isEmpty() ? this.getBackBlock().getRelative(0, 1, 0).getLocation() : ICUtil.parseBlockLocation(this.getSign(), 3).getLocation();
        this.item = ItemSyntax.getItem(this.getLine(2));
    }

    @Override
    public String getTitle() {
        return "Container Stocker";
    }

    @Override
    public String getSignTitle() {
        return "STOCKER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.stock());
        }
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.stock());
    }

    public boolean stock() {
        if (InventoryUtil.doesBlockHaveInventory(this.offset.getBlock())) {
            BlockFace back = SignUtil.getBack(CraftBookBukkitUtil.toSign(this.getSign()).getBlock());
            Block pipe = this.getBackBlock().getRelative(back);
            PipeRequestEvent event = new PipeRequestEvent(pipe, new ArrayList<ItemStack>(Collections.singletonList(this.item.clone())), this.getBackBlock());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isValid()) {
                return false;
            }
            InventoryHolder c = (InventoryHolder)this.offset.getBlock().getState();
            for (ItemStack stack : event.getItems()) {
                if (!c.getInventory().addItem(new ItemStack[]{stack}).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new ContainerStocker(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Adds item into container at specified offset.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"item id:data", "x:y:z offset"};
        }
    }
}

