/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.items;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.pipe.PipeRequestEvent;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.SignUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.Chest;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Furnace;
import org.bukkit.event.Event;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ContainerDispenser
extends AbstractSelfTriggeredIC {
    ItemStack item;
    int amount;

    public ContainerDispenser(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        try {
            this.amount = Integer.parseInt(this.getSign().getLine(2));
        }
        catch (Exception e) {
            this.amount = 1;
        }
        this.item = ItemSyntax.getItem(this.getLine(3));
        if (this.item != null) {
            this.item.setAmount(this.amount);
        }
    }

    @Override
    public String getTitle() {
        return "Container Dispenser";
    }

    @Override
    public String getSignTitle() {
        return "CONTAINER DISPENSER";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.dispense());
        }
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.dispense());
    }

    protected boolean dispense() {
        FurnaceInventory inv;
        ItemStack stack;
        block3: {
            Block bl;
            block6: {
                block5: {
                    block4: {
                        Block b = this.getBackBlock();
                        int x = b.getX();
                        int y = b.getY() + 1;
                        int z = b.getZ();
                        bl = CraftBookBukkitUtil.toSign(this.getSign()).getBlock().getWorld().getBlockAt(x, y, z);
                        stack = null;
                        inv = null;
                        if (bl.getType() != Material.CHEST) break block4;
                        Chest c = (Chest)bl.getState();
                        for (ItemStack it : c.getInventory().getContents()) {
                            if (!ItemUtil.isStackValid(it) || this.item != null && !ItemUtil.areItemsIdentical(it, this.item)) continue;
                            stack = it;
                            inv = c.getInventory();
                            break block3;
                        }
                        break block3;
                    }
                    if (bl.getType() != Material.FURNACE) break block5;
                    Furnace c = (Furnace)bl.getState();
                    stack = c.getInventory().getResult();
                    inv = c.getInventory();
                    break block3;
                }
                if (bl.getType() != Material.BREWING_STAND) break block6;
                BrewingStand c = (BrewingStand)bl.getState();
                for (ItemStack it : c.getInventory().getContents()) {
                    if (!ItemUtil.isStackValid(it) || ItemUtil.areItemsIdentical(it, c.getInventory().getIngredient()) || this.item != null && !ItemUtil.areItemsIdentical(it, this.item)) continue;
                    stack = it;
                    inv = c.getInventory();
                    break block3;
                }
                break block3;
            }
            if (bl.getType() != Material.DISPENSER) break block3;
            Dispenser c = (Dispenser)bl.getState();
            for (ItemStack it : c.getInventory().getContents()) {
                if (!ItemUtil.isStackValid(it) || this.item != null && !ItemUtil.areItemsIdentical(it, this.item)) continue;
                stack = it;
                inv = c.getInventory();
                break;
            }
        }
        return stack != null && inv != null && this.dispenseItem((Inventory)inv, stack);
    }

    public boolean dispenseItem(Inventory inv, ItemStack old) {
        ItemStack item = old.clone();
        item.setAmount(this.amount);
        if (inv == null) {
            return false;
        }
        HashMap over = inv.removeItem(new ItemStack[]{item.clone()});
        if (over.isEmpty()) {
            BlockFace back = SignUtil.getBack(CraftBookBukkitUtil.toSign(this.getSign()).getBlock());
            Block pipe = this.getBackBlock().getRelative(back);
            PipeRequestEvent event = new PipeRequestEvent(pipe, new ArrayList<ItemStack>(Collections.singletonList(item.clone())), this.getBackBlock());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isValid()) {
                return true;
            }
            for (ItemStack stack : event.getItems()) {
                CraftBookBukkitUtil.toSign(this.getSign()).getWorld().dropItemNaturally(CraftBookBukkitUtil.toSign(this.getSign()).getLocation(), stack);
            }
            return true;
        }
        BlockFace back = SignUtil.getBack(CraftBookBukkitUtil.toSign(this.getSign()).getBlock());
        Block pipe = this.getBackBlock().getRelative(back);
        PipeRequestEvent event = new PipeRequestEvent(pipe, new ArrayList<ItemStack>(over.values()), this.getBackBlock());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isValid()) {
            return true;
        }
        for (ItemStack it : event.getItems()) {
            if (item.getAmount() - it.getAmount() < 1) continue;
            CraftBookBukkitUtil.toSign(this.getSign()).getWorld().dropItemNaturally(CraftBookBukkitUtil.toSign(this.getSign()).getLocation(), new ItemStack(it.getType(), item.getAmount() - it.getAmount(), it.getDurability()));
            return true;
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new ContainerDispenser(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Dispenses items out of containers.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"amount to dispense", null};
        }
    }
}

