/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.items;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.pipe.PipeRequestEvent;
import com.sk89q.craftbook.util.InventoryUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.SignUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ContainerCollector
extends AbstractSelfTriggeredIC {
    ItemStack doWant;
    ItemStack doNotWant;
    Block chest;

    public ContainerCollector(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Container Collector";
    }

    @Override
    public String getSignTitle() {
        return "CONTAINER COLLECT";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.scanForItems());
        }
    }

    @Override
    public void think(ChipState chip) {
        chip.setOutput(0, this.scanForItems());
    }

    @Override
    public void load() {
        this.doWant = ItemSyntax.getItem(this.getLine(2));
        this.doNotWant = ItemSyntax.getItem(this.getLine(3));
        this.chest = this.getBackBlock().getRelative(0, 1, 0);
    }

    protected boolean scanForItems() {
        boolean collected = false;
        for (Item item : ItemUtil.getItemsAtBlock(CraftBookBukkitUtil.toSign(this.getSign()).getBlock())) {
            if (!item.isValid() || item.isDead() || !this.collectItem(item)) continue;
            collected = true;
        }
        return collected;
    }

    public boolean collectItem(Item item) {
        ItemStack stack = item.getItemStack();
        if (!ItemUtil.isStackValid(stack)) {
            return false;
        }
        if (this.doWant != null && !ItemUtil.areItemsIdentical(this.doWant, stack)) {
            return false;
        }
        if (this.doNotWant != null && ItemUtil.areItemsIdentical(this.doNotWant, stack)) {
            return false;
        }
        BlockFace back = SignUtil.getBack(CraftBookBukkitUtil.toSign(this.getSign()).getBlock());
        Block pipe = this.getBackBlock().getRelative(back);
        PipeRequestEvent event = new PipeRequestEvent(pipe, new ArrayList<ItemStack>(Collections.singletonList(stack)), this.getBackBlock());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.getItems().isEmpty()) {
            item.remove();
            return true;
        }
        if (!InventoryUtil.doesBlockHaveInventory(this.chest)) {
            return false;
        }
        List<ItemStack> leftovers = InventoryUtil.addItemsToInventory((InventoryHolder)this.chest.getState(), stack);
        if (leftovers.isEmpty()) {
            item.remove();
            return true;
        }
        if (ItemUtil.areItemsIdentical(leftovers.get(0), stack) && leftovers.get(0).getAmount() != stack.getAmount()) {
            if (!ItemUtil.isStackValid(leftovers.get(0))) {
                item.remove();
            } else {
                item.setItemStack(leftovers.get(0));
            }
            return true;
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new ContainerCollector(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Collects items into above chest.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"included id:data", "excluded id:data"};
        }
    }
}

