/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.entity;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.EntityUtil;
import com.sk89q.craftbook.util.ICUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class AdvancedEntitySpawner
extends AbstractIC {
    private Location location;
    private EntityType type;
    private int amount;

    public AdvancedEntitySpawner(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Advanced Entity Spawner";
    }

    @Override
    public String getSignTitle() {
        return "ADV ENT SPAWNER";
    }

    @Override
    public void load() {
        String[] splitLine3 = RegexUtil.ASTERISK_PATTERN.split(this.getSign().getLine(3).trim());
        try {
            this.type = EntityType.valueOf((String)splitLine3[0].trim().toLowerCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            try {
                this.type = EntityType.valueOf((String)splitLine3[0].trim().toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException ee) {
                this.type = EntityType.PIG;
            }
        }
        try {
            this.amount = Integer.parseInt(splitLine3[1]);
        }
        catch (Exception e) {
            this.amount = 1;
        }
        this.location = ICUtil.parseBlockLocation(this.getSign(), 2).getLocation();
    }

    @Override
    public void trigger(ChipState chip) {
        if (!this.location.getChunk().isLoaded()) {
            return;
        }
        if (!chip.getInput(0)) {
            return;
        }
        Block left = SignUtil.getLeftBlock(CraftBookBukkitUtil.toSign(this.getSign()).getBlock());
        ChangedSign effectSign = null;
        if (SignUtil.isWallSign(left)) {
            effectSign = CraftBookBukkitUtil.toChangedSign(left);
        }
        Block right = SignUtil.getRightBlock(CraftBookBukkitUtil.toSign(this.getSign()).getBlock());
        ChangedSign armourSign = null;
        if (SignUtil.isWallSign(right)) {
            armourSign = CraftBookBukkitUtil.toChangedSign(right);
        }
        block10: for (int i = 0; i < this.amount; ++i) {
            Entity ent = CraftBookBukkitUtil.toSign(this.getSign()).getWorld().spawn(this.location, this.type.getEntityClass());
            if (armourSign != null && ent instanceof LivingEntity) {
                block11: for (int s = 0; s < 4; ++s) {
                    String bit = armourSign.getLine(s);
                    ItemStack slot = ItemUtil.makeItemValid(ItemSyntax.getItem(bit));
                    switch (s) {
                        case 0: {
                            ((LivingEntity)ent).getEquipment().setHelmet(slot);
                            continue block11;
                        }
                        case 1: {
                            ((LivingEntity)ent).getEquipment().setChestplate(slot);
                            continue block11;
                        }
                        case 2: {
                            ((LivingEntity)ent).getEquipment().setLeggings(slot);
                            continue block11;
                        }
                        case 3: {
                            ((LivingEntity)ent).getEquipment().setBoots(slot);
                        }
                    }
                }
            }
            Boolean upwards = null;
            while (effectSign != null) {
                for (int s = 0; s < 4; ++s) {
                    String bit = effectSign.getLine(s);
                    if (bit == null || bit.trim().isEmpty()) continue;
                    String[] data = RegexUtil.COLON_PATTERN.split(bit);
                    if (data[0].equalsIgnoreCase("e")) {
                        EntityUtil.setEntityData(ent, bit.substring(2));
                        continue;
                    }
                    if (data[0].equalsIgnoreCase("r")) {
                        EntityType rider = EntityType.fromName((String)data[1].trim());
                        Entity rid = CraftBookBukkitUtil.toSign(this.getSign()).getWorld().spawnEntity(this.location, rider);
                        ent.setPassenger(rid);
                        continue;
                    }
                    if (data[0].equalsIgnoreCase("p") && ent instanceof LivingEntity) {
                        for (int a = 1; a < data.length; ++a) {
                            try {
                                String[] potionBits = RegexUtil.SEMICOLON_PATTERN.split(data[a]);
                                PotionEffect effect = new PotionEffect(PotionEffectType.getById((int)Integer.parseInt(potionBits[0])), Integer.parseInt(potionBits[1]), Integer.parseInt(potionBits[2]));
                                ((LivingEntity)ent).addPotionEffect(effect, true);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    if (data[0].equalsIgnoreCase("v")) {
                        try {
                            String[] coords = RegexUtil.COMMA_PATTERN.split(data[1]);
                            double x = Double.parseDouble(coords[0]);
                            double y = Double.parseDouble(coords[1]);
                            double z = Double.parseDouble(coords[2]);
                            ent.setVelocity(new Vector(x, y, z));
                        }
                        catch (Exception x) {}
                        continue;
                    }
                    if (!data[0].equalsIgnoreCase("s") || !(ent instanceof LivingEntity)) continue;
                    ItemStack slot = ItemUtil.makeItemValid(ItemSyntax.getItem(bit.replace("s:", "")));
                    ((LivingEntity)ent).getEquipment().setItemInHand(slot);
                }
                if (upwards == null) {
                    if (SignUtil.isWallSign(CraftBookBukkitUtil.toSign(effectSign).getBlock().getRelative(0, 1, 0))) {
                        effectSign = CraftBookBukkitUtil.toChangedSign(CraftBookBukkitUtil.toSign(effectSign).getBlock().getRelative(0, 1, 0));
                        upwards = true;
                        continue;
                    }
                    if (!SignUtil.isWallSign(CraftBookBukkitUtil.toSign(effectSign).getBlock().getRelative(0, -1, 0))) continue block10;
                    effectSign = CraftBookBukkitUtil.toChangedSign(CraftBookBukkitUtil.toSign(effectSign).getBlock().getRelative(0, -1, 0));
                    upwards = false;
                    continue;
                }
                if (!SignUtil.isWallSign(CraftBookBukkitUtil.toSign(effectSign).getBlock().getRelative(0, upwards != false ? 1 : -1, 0))) continue block10;
                effectSign = CraftBookBukkitUtil.toChangedSign(CraftBookBukkitUtil.toSign(effectSign).getBlock().getRelative(0, upwards != false ? 1 : -1, 0));
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new AdvancedEntitySpawner(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Spawns a mob with many customizations.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"+ox:y:z", "entitytype{*amount}"};
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            String[] splitLine3 = RegexUtil.ASTERISK_PATTERN.split(sign.getLine(3).trim());
            EntityType type = EntityType.fromName((String)splitLine3[0].trim().toLowerCase(Locale.ENGLISH));
            if (type == null) {
                try {
                    EntityType.valueOf((String)splitLine3[0].trim().toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    throw new ICVerificationException("Invalid Entity! See bukkit EntityType list!");
                }
            } else if (!type.isSpawnable()) {
                throw new ICVerificationException("Entity is not spawnable!");
            }
        }
    }
}

