/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;

public class SetDoor
extends AbstractIC {
    private BlockData onBlock;
    private BlockData offBlock;
    private int width;
    private int height;
    private int offsetX = 0;
    private int offsetY = 1;
    private int offsetZ = 0;
    private Block center;
    private BlockFace faceing;

    public SetDoor(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public void load() {
        this.faceing = SignUtil.getFacing(CraftBookBukkitUtil.toSign(this.getSign()).getBlock());
        String line = this.getSign().getLine(2);
        if (!line.isEmpty()) {
            String[] split = RegexUtil.MINUS_PATTERN.split(line);
            if (split.length > 1) {
                this.offBlock = BlockSyntax.getBukkitBlock(split[1]);
            }
            this.onBlock = BlockSyntax.getBukkitBlock(split[0]);
        }
        if (!(line = this.getSign().getLine(3)).isEmpty()) {
            boolean relativeOffset;
            boolean bl = relativeOffset = !line.contains("!");
            if (!relativeOffset) {
                line = line.replace("!", "");
            }
            String[] split = RegexUtil.COLON_PATTERN.split(line);
            try {
                String[] offsetSplit = RegexUtil.COMMA_PATTERN.split(split[0]);
                this.offsetX = Integer.parseInt(offsetSplit[0]);
                this.offsetY = Integer.parseInt(offsetSplit[1]);
                this.offsetZ = Integer.parseInt(offsetSplit[2]);
            }
            catch (IndexOutOfBoundsException | NumberFormatException offsetSplit) {
                // empty catch block
            }
            try {
                String[] sizeSplit = RegexUtil.COMMA_PATTERN.split(split[1]);
                this.width = Integer.parseInt(sizeSplit[0]);
                this.height = Integer.parseInt(sizeSplit[1]);
            }
            catch (NumberFormatException e) {
                this.width = 1;
                this.height = 1;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.height = 1;
            }
            this.center = relativeOffset ? LocationUtil.getRelativeOffset(this.getSign(), this.offsetX, this.offsetY, this.offsetZ) : LocationUtil.getOffset(this.getBackBlock(), this.offsetX, this.offsetY, this.offsetZ);
        } else {
            this.center = this.getBackBlock().getRelative(BlockFace.UP);
        }
    }

    @Override
    public String getTitle() {
        return "Set P-Door";
    }

    @Override
    public String getSignTitle() {
        return "SET P-DOOR";
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.setDoor(true);
        } else {
            this.setDoor(false);
        }
        chip.setOutput(0, chip.getInput(0));
    }

    private void setDoor(boolean open) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                Block block = LocationUtil.getRelativeOffset(this.center, this.faceing, x, y, 0);
                boolean isSource = block.equals(this.getBackBlock());
                if (open) {
                    if (isSource && BlockUtil.isBlockReplacable(this.onBlock.getMaterial())) continue;
                    block.setBlockData(this.onBlock);
                    continue;
                }
                if (isSource && BlockUtil.isBlockReplacable(this.offBlock.getMaterial())) continue;
                block.setBlockData(this.offBlock);
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new SetDoor(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Generates a door out of the set materials with set size.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"onID{:onData-offID:offData}", "offset x,y,z:width,height"};
        }
    }
}

