/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

public abstract class SetBlock
extends AbstractSelfTriggeredIC {
    BlockStateHolder item;
    String force;

    public SetBlock(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        this.force = this.getSign().getLine(3).toUpperCase(Locale.ENGLISH).trim();
        this.item = BlockSyntax.getBlock(this.getLine(2));
    }

    public void onTrigger() {
        Block body = this.getBackBlock();
        this.doSet(body, this.item, this.force.equals("FORCE"));
    }

    @Override
    public void trigger(ChipState chip) {
        chip.setOutput(0, chip.getInput(0));
        this.onTrigger();
    }

    @Override
    public void think(ChipState chip) {
        this.onTrigger();
    }

    protected abstract void doSet(Block var1, BlockStateHolder var2, boolean var3);

    public boolean takeFromChest(Block bl, ItemType item) {
        if (bl.getType() != Material.CHEST) {
            return false;
        }
        Material material = BukkitAdapter.adapt((ItemType)item);
        BlockState state = bl.getState();
        if (!(state instanceof Chest)) {
            return false;
        }
        Chest c = (Chest)state;
        ItemStack[] is = c.getInventory().getContents();
        for (int i = 0; i < is.length; ++i) {
            ItemStack stack = is[i];
            if (stack == null || stack.getAmount() <= 0 || stack.getType() != material) continue;
            if (stack.getAmount() == 1) {
                is[i] = new ItemStack(Material.AIR, 0);
            } else {
                stack.setAmount(stack.getAmount() - 1);
            }
            c.getInventory().setContents(is);
            return true;
        }
        return false;
    }
}

