/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.RegexUtil;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public class MultipleSetBlock
extends AbstractIC {
    private int x;
    private int y;
    private int z;
    private BlockData onBlock;
    private BlockData offblock;
    private String[] dim;

    public MultipleSetBlock(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public void load() {
        String line3 = this.getSign().getLine(2).replace("+", "").toUpperCase(Locale.ENGLISH);
        String line4 = this.getSign().getLine(3);
        this.getSign().setLine(2, line3);
        this.getSign().update(false);
        String[] coords = RegexUtil.COLON_PATTERN.split(line3, 4);
        Block body = this.getBackBlock();
        this.x = body.getX();
        this.y = body.getY();
        this.z = body.getZ();
        if (coords.length < 4) {
            return;
        }
        String[] blocks = RegexUtil.MINUS_PATTERN.split(coords[3]);
        this.onBlock = BlockSyntax.getBukkitBlock(blocks[0]);
        this.offblock = blocks.length > 1 ? BlockSyntax.getBukkitBlock(blocks[1]) : Material.AIR.createBlockData();
        this.x += Integer.parseInt(coords[0]);
        this.y += Integer.parseInt(coords[1]);
        this.z += Integer.parseInt(coords[2]);
        this.dim = RegexUtil.COLON_PATTERN.split(line4);
    }

    @Override
    public String getTitle() {
        return "Multiple SetBlock";
    }

    @Override
    public String getSignTitle() {
        return "MULTI-SET BLOCK";
    }

    @Override
    public void trigger(ChipState chip) {
        BlockData setBlock = this.onBlock;
        chip.setOutput(0, chip.getInput(0));
        boolean inp = chip.getInput(0);
        if (!inp) {
            setBlock = this.offblock;
        }
        Block body = this.getBackBlock();
        if (this.dim.length == 3) {
            int dimX = Integer.parseInt(this.dim[0]);
            int dimY = Integer.parseInt(this.dim[1]);
            int dimZ = Integer.parseInt(this.dim[2]);
            for (int lx = 0; lx < dimX; ++lx) {
                for (int ly = 0; ly < dimY; ++ly) {
                    for (int lz = 0; lz < dimZ; ++lz) {
                        body.getWorld().getBlockAt(this.x + lx, this.y + ly, this.z + lz).setBlockData(setBlock, true);
                    }
                }
            }
        } else {
            body.getWorld().getBlockAt(this.x, this.y, this.z).setBlockData(setBlock, true);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new MultipleSetBlock(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Sets multiple blocks.";
        }

        @Override
        public String[] getLineHelp() {
            return new String[]{"x:y:z:onid:ondata-offid:offdata", "width:height:depth"};
        }
    }
}

