/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.gates.logic.SimpleAnyInputLogicGate;
import org.bukkit.Server;

public class NandGate
extends SimpleAnyInputLogicGate {
    public NandGate(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Nand Gate";
    }

    @Override
    public String getSignTitle() {
        return "NAND";
    }

    @Override
    protected boolean getResult(int wires, int on) {
        return wires > 0 && on != wires;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new NandGate(this.getServer(), sign, this);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Input", "Input", "Input", "High if one or more inputs are high, but not all are high"};
        }

        @Override
        public String getShortDescription() {
            return "NAND Gate. Outputs high if all inputs are low.";
        }
    }
}

