/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.AbstractSelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.util.RegexUtil;
import java.util.Locale;
import org.bukkit.Server;

public class Monostable
extends AbstractSelfTriggeredIC {
    public Monostable(Server server, ChangedSign psign, ICFactory factory) {
        super(server, psign, factory);
    }

    @Override
    public String getTitle() {
        return "Monostable";
    }

    @Override
    public String getSignTitle() {
        return "MONOSTABLE";
    }

    @Override
    public boolean isAlwaysST() {
        return true;
    }

    @Override
    public void trigger(ChipState chip) {
        String setting = this.getSign().getLine(2).toUpperCase(Locale.ENGLISH);
        boolean triggered = chip.getInput(0);
        if (triggered && setting.contains("H") || !triggered && setting.contains("L")) {
            int colon = setting.indexOf(58);
            if (colon <= 0) {
                return;
            }
            chip.setOutput(0, true);
            this.getSign().setLine(3, setting.substring(0, colon));
            this.getSign().update(false);
        }
    }

    @Override
    public void think(ChipState chip) {
        int tick;
        try {
            tick = Integer.parseInt(this.getSign().getLine(3));
        }
        catch (NumberFormatException e) {
            tick = 0;
        }
        if (tick == 0) {
            chip.setOutput(0, false);
        } else {
            --tick;
        }
        this.getSign().setLine(3, Integer.toString(tick));
        this.getSign().update(false);
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new Monostable(this.getServer(), sign, this);
        }

        @Override
        public String getShortDescription() {
            return "Outputs a pulse for a set amount of time on high.";
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            boolean lo;
            boolean hi;
            int ticks;
            try {
                String set = sign.getLine(2).toUpperCase(Locale.ENGLISH);
                if (!set.contains(":")) {
                    throw new ICVerificationException("Invalid syntax");
                }
                String[] settings = RegexUtil.COLON_PATTERN.split(set);
                if (settings.length != 2) {
                    throw new ICVerificationException("Invalid syntax");
                }
                ticks = Integer.parseInt(settings[0]);
                hi = settings[1].contains("H");
                lo = settings[1].contains("L");
                if (!hi && !lo) {
                    throw new ICVerificationException("Missing trigger levels");
                }
            }
            catch (NumberFormatException e) {
                throw new ICVerificationException("Invalid number format");
            }
            ticks = Math.max(ticks, 2);
            ticks = Math.min(ticks, 6000);
            sign.setLine(2, ticks + ":" + (hi ? "H" : "") + (lo ? "L" : ""));
            sign.setLine(3, "0");
            sign.update(false);
        }
    }
}

