/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.mechanics.ic.AbstractIC;
import com.sk89q.craftbook.mechanics.ic.AbstractICFactory;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class LowDelayer
extends AbstractIC {
    private BukkitTask taskId;

    public LowDelayer(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    @Override
    public String getTitle() {
        return "Low Delayer";
    }

    @Override
    public String getSignTitle() {
        return "LOW_DELAYER";
    }

    @Override
    public void trigger(ChipState chip) {
        long delay = Long.parseLong(this.getSign().getLine(2));
        if (chip.getInput(0)) {
            if (this.taskId != null) {
                this.taskId.cancel();
            }
            chip.setOutput(0, true);
        } else {
            this.taskId = Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
                if (!chip.getInput(0)) {
                    chip.setOutput(0, false);
                }
            }, delay * 20L);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        @Override
        public IC create(ChangedSign sign) {
            return new LowDelayer(this.getServer(), sign, this);
        }

        @Override
        public String[] getPinDescription(ChipState state) {
            return new String[]{"Trigger IC", "Delayed Output"};
        }

        @Override
        public void verify(ChangedSign sign) throws ICVerificationException {
            try {
                Integer.parseInt(sign.getLine(2));
            }
            catch (Exception ignored) {
                throw new ICVerificationException("The third line needs to be a number.");
            }
        }
    }
}

