/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.IC;
import com.sk89q.craftbook.mechanics.ic.ICConfiguration;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICFamily;
import com.sk89q.craftbook.mechanics.ic.ICMechanic;
import com.sk89q.craftbook.mechanics.ic.RegisteredICFactory;
import com.sk89q.craftbook.mechanics.ic.RestrictedIC;
import com.sk89q.craftbook.mechanics.ic.SelfTriggeredIC;
import com.sk89q.craftbook.mechanics.ic.families.Family3I3O;
import com.sk89q.craftbook.mechanics.ic.families.Family3ISO;
import com.sk89q.craftbook.mechanics.ic.families.FamilyAISO;
import com.sk89q.craftbook.mechanics.ic.families.FamilySI3O;
import com.sk89q.craftbook.mechanics.ic.families.FamilySI5O;
import com.sk89q.craftbook.mechanics.ic.families.FamilySISO;
import com.sk89q.craftbook.mechanics.ic.families.FamilyVIVO;
import com.sk89q.craftbook.mechanics.ic.gates.logic.AndGate;
import com.sk89q.craftbook.mechanics.ic.gates.logic.Clock;
import com.sk89q.craftbook.mechanics.ic.gates.logic.ClockDivider;
import com.sk89q.craftbook.mechanics.ic.gates.logic.CombinationLock;
import com.sk89q.craftbook.mechanics.ic.gates.logic.Counter;
import com.sk89q.craftbook.mechanics.ic.gates.logic.DeMultiplexer;
import com.sk89q.craftbook.mechanics.ic.gates.logic.Delayer;
import com.sk89q.craftbook.mechanics.ic.gates.logic.Dispatcher;
import com.sk89q.craftbook.mechanics.ic.gates.logic.DownCounter;
import com.sk89q.craftbook.mechanics.ic.gates.logic.EdgeTriggerDFlipFlop;
import com.sk89q.craftbook.mechanics.ic.gates.logic.FullAdder;
import com.sk89q.craftbook.mechanics.ic.gates.logic.FullSubtractor;
import com.sk89q.craftbook.mechanics.ic.gates.logic.HalfAdder;
import com.sk89q.craftbook.mechanics.ic.gates.logic.HalfSubtractor;
import com.sk89q.craftbook.mechanics.ic.gates.logic.InvertedRsNandLatch;
import com.sk89q.craftbook.mechanics.ic.gates.logic.Inverter;
import com.sk89q.craftbook.mechanics.ic.gates.logic.JkFlipFlop;
import com.sk89q.craftbook.mechanics.ic.gates.logic.LevelTriggeredDFlipFlop;
import com.sk89q.craftbook.mechanics.ic.gates.logic.LowDelayer;
import com.sk89q.craftbook.mechanics.ic.gates.logic.LowNotPulser;
import com.sk89q.craftbook.mechanics.ic.gates.logic.LowPulser;
import com.sk89q.craftbook.mechanics.ic.gates.logic.Marquee;
import com.sk89q.craftbook.mechanics.ic.gates.logic.MemoryAccess;
import com.sk89q.craftbook.mechanics.ic.gates.logic.MemorySetter;
import com.sk89q.craftbook.mechanics.ic.gates.logic.Monostable;
import com.sk89q.craftbook.mechanics.ic.gates.logic.Multiplexer;
import com.sk89q.craftbook.mechanics.ic.gates.logic.NandGate;
import com.sk89q.craftbook.mechanics.ic.gates.logic.NotDelayer;
import com.sk89q.craftbook.mechanics.ic.gates.logic.NotLowDelayer;
import com.sk89q.craftbook.mechanics.ic.gates.logic.NotPulser;
import com.sk89q.craftbook.mechanics.ic.gates.logic.Pulser;
import com.sk89q.craftbook.mechanics.ic.gates.logic.Random3Bit;
import com.sk89q.craftbook.mechanics.ic.gates.logic.Random5Bit;
import com.sk89q.craftbook.mechanics.ic.gates.logic.RandomBit;
import com.sk89q.craftbook.mechanics.ic.gates.logic.RangedOutput;
import com.sk89q.craftbook.mechanics.ic.gates.logic.Repeater;
import com.sk89q.craftbook.mechanics.ic.gates.logic.RsNandLatch;
import com.sk89q.craftbook.mechanics.ic.gates.logic.RsNorFlipFlop;
import com.sk89q.craftbook.mechanics.ic.gates.logic.ToggleFlipFlop;
import com.sk89q.craftbook.mechanics.ic.gates.logic.XnorGate;
import com.sk89q.craftbook.mechanics.ic.gates.logic.XorGate;
import com.sk89q.craftbook.mechanics.ic.gates.variables.IsAtLeast;
import com.sk89q.craftbook.mechanics.ic.gates.variables.ItemCounter;
import com.sk89q.craftbook.mechanics.ic.gates.variables.NumericModifier;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.BlockBreaker;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.BlockLauncher;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.BlockReplacer;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.BonemealTerraformer;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.CombineHarvester;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.Cultivator;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.Driller;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.FlexibleSetBlock;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.Irrigator;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.LiquidFlood;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.MultipleSetBlock;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.Planter;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.Pump;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.SetBlockAdmin;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.SetBlockChest;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.SetBridge;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.SetDoor;
import com.sk89q.craftbook.mechanics.ic.gates.world.blocks.Spigot;
import com.sk89q.craftbook.mechanics.ic.gates.world.entity.AdvancedEntitySpawner;
import com.sk89q.craftbook.mechanics.ic.gates.world.entity.AnimalBreeder;
import com.sk89q.craftbook.mechanics.ic.gates.world.entity.AnimalHarvester;
import com.sk89q.craftbook.mechanics.ic.gates.world.entity.CreatureSpawner;
import com.sk89q.craftbook.mechanics.ic.gates.world.entity.EntityCannon;
import com.sk89q.craftbook.mechanics.ic.gates.world.entity.EntityTrap;
import com.sk89q.craftbook.mechanics.ic.gates.world.entity.PlayerTrap;
import com.sk89q.craftbook.mechanics.ic.gates.world.entity.TeleportReciever;
import com.sk89q.craftbook.mechanics.ic.gates.world.entity.TeleportTransmitter;
import com.sk89q.craftbook.mechanics.ic.gates.world.items.AutomaticCrafter;
import com.sk89q.craftbook.mechanics.ic.gates.world.items.ContainerCollector;
import com.sk89q.craftbook.mechanics.ic.gates.world.items.ContainerDispenser;
import com.sk89q.craftbook.mechanics.ic.gates.world.items.ContainerStacker;
import com.sk89q.craftbook.mechanics.ic.gates.world.items.ContainerStocker;
import com.sk89q.craftbook.mechanics.ic.gates.world.items.Distributer;
import com.sk89q.craftbook.mechanics.ic.gates.world.items.ItemDispenser;
import com.sk89q.craftbook.mechanics.ic.gates.world.items.ItemFan;
import com.sk89q.craftbook.mechanics.ic.gates.world.items.RangedCollector;
import com.sk89q.craftbook.mechanics.ic.gates.world.items.Sorter;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.ArrowBarrage;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.ArrowShooter;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.FireBarrage;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.FireShooter;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.FlameThrower;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.Jukebox;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.LightningSummon;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.Melody;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.MessageSender;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.ParticleEffect;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.PotionInducer;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.ProgrammableFireworkShow;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.RadioPlayer;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.RadioStation;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.SentryGun;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.SoundEffect;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.TimedExplosion;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.Tune;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.WirelessReceiver;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.WirelessTransmitter;
import com.sk89q.craftbook.mechanics.ic.gates.world.miscellaneous.XPSpawner;
import com.sk89q.craftbook.mechanics.ic.gates.world.sensors.BlockSensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.sensors.ContentsSensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.sensors.DaySensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.sensors.EntitySensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.sensors.ItemNotSensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.sensors.ItemSensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.sensors.LavaSensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.sensors.LightSensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.sensors.PlayerInventorySensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.sensors.PlayerSensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.sensors.PowerSensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.sensors.WaterSensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.weather.RainSensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.weather.ServerTimeModulus;
import com.sk89q.craftbook.mechanics.ic.gates.world.weather.TStormSensor;
import com.sk89q.craftbook.mechanics.ic.gates.world.weather.TimeControl;
import com.sk89q.craftbook.mechanics.ic.gates.world.weather.TimeControlAdvanced;
import com.sk89q.craftbook.mechanics.ic.gates.world.weather.TimeFaker;
import com.sk89q.craftbook.mechanics.ic.gates.world.weather.TimeSet;
import com.sk89q.craftbook.mechanics.ic.gates.world.weather.WeatherControl;
import com.sk89q.craftbook.mechanics.ic.gates.world.weather.WeatherControlAdvanced;
import com.sk89q.craftbook.mechanics.ic.gates.world.weather.WeatherFaker;
import com.sk89q.craftbook.mechanics.ic.plc.PlcFactory;
import com.sk89q.craftbook.mechanics.ic.plc.lang.Perlstone;
import com.sk89q.craftbook.mechanics.variables.VariableManager;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class ICManager {
    public static final ICFamily familySISO = new FamilySISO();
    public static final ICFamily family3ISO = new Family3ISO();
    public static final ICFamily familySI3O = new FamilySI3O();
    public static final ICFamily familyAISO = new FamilyAISO();
    public static final ICFamily family3I3O = new Family3I3O();
    public static final ICFamily familyVIVO = new FamilyVIVO();
    public static final ICFamily familySI5O = new FamilySI5O();
    private ICConfiguration icConfiguration;
    private File romFolder;
    private File midiFolder;
    private File fireworkFolder;
    private static ICManager INSTANCE;
    public final Map<String, RegisteredICFactory> registered = new LinkedHashMap<String, RegisteredICFactory>();
    public final Map<String, String> longRegistered = new HashMap<String, String>();
    private static final Map<Location, IC> cachedICs;
    private static final Set<String> customPrefix;

    public ICManager() {
        INSTANCE = this;
    }

    public static ICManager inst() {
        return INSTANCE;
    }

    public void enable() {
        CraftBookPlugin.inst().createDefaultConfiguration(new File(CraftBookPlugin.inst().getDataFolder(), "ic-config.yml"), "ic-config.yml");
        this.icConfiguration = new ICConfiguration(new YAMLProcessor(new File(CraftBookPlugin.inst().getDataFolder(), "ic-config.yml"), true, YAMLFormat.EXTENDED), CraftBookPlugin.logger());
        this.midiFolder = new File(CraftBookPlugin.inst().getDataFolder(), "midi/");
        new File(this.midiFolder, "playlists").mkdirs();
        this.romFolder = new File(CraftBookPlugin.inst().getDataFolder(), "rom/");
        this.fireworkFolder = new File(CraftBookPlugin.inst().getDataFolder(), "fireworks/");
        this.registerICs(CraftBookPlugin.inst().getServer());
        try {
            this.icConfiguration.load();
        }
        catch (Throwable e) {
            CraftBookBukkitUtil.printStacktrace(e);
        }
    }

    public void disable() {
        for (RegisteredICFactory factory : this.registered.values()) {
            factory.getFactory().unload();
        }
        this.icConfiguration = null;
        ICManager.emptyCache();
        INSTANCE = null;
    }

    public File getFireworkFolder() {
        return this.fireworkFolder;
    }

    public File getMidiFolder() {
        return this.midiFolder;
    }

    public File getRomFolder() {
        return this.romFolder;
    }

    public boolean registerIC(String name, String longName, ICFactory factory, ICFamily ... families) {
        for (String ic : ICMechanic.instance.disabledICs) {
            if (!ic.equalsIgnoreCase(name)) continue;
            return false;
        }
        return this.register(name, longName, factory, families);
    }

    public void register(String id, ICFactory factory, ICFamily ... families) {
        this.register(id, null, factory, families);
    }

    public boolean register(String id, String longId, ICFactory factory, ICFamily ... families) {
        if (families.length < 1) {
            return false;
        }
        String id2 = "[" + id + "]";
        if (this.registered.containsKey(id.toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        Matcher matcher = RegexUtil.IC_PATTERN.matcher(id2);
        if (!matcher.matches()) {
            return false;
        }
        String prefix = matcher.group(2).toLowerCase(Locale.ENGLISH);
        customPrefix.add(prefix);
        RegisteredICFactory registration = new RegisteredICFactory(id, longId, factory, families);
        this.registered.put(id.toLowerCase(Locale.ENGLISH), registration);
        if (longId != null) {
            String toRegister = longId.toLowerCase(Locale.ENGLISH);
            if (toRegister.length() > 15) {
                toRegister = toRegister.substring(0, 15);
            }
            this.longRegistered.put(toRegister, id);
        }
        factory.load();
        return true;
    }

    public RegisteredICFactory get(String id) {
        return this.registered.get(id.toLowerCase(Locale.ENGLISH));
    }

    public static boolean isCachedIC(Location pt) {
        return cachedICs.containsKey(pt);
    }

    public static IC getCachedIC(Location pt) {
        return cachedICs.get(pt);
    }

    public static void addCachedIC(Location pt, IC ic) {
        if (!ICMechanic.instance.cache) {
            return;
        }
        if (cachedICs.containsKey(pt)) {
            return;
        }
        CraftBookPlugin.logDebugMessage("Caching IC at: " + pt.toString(), "ic-cache");
        cachedICs.put(pt, ic);
    }

    public static IC removeCachedIC(Location pt) {
        if (cachedICs.containsKey(pt)) {
            CraftBookPlugin.logDebugMessage("Removing cached IC at: " + pt.toString(), "ic-cache");
            return cachedICs.remove(pt);
        }
        return null;
    }

    public static void unloadIC(Location pt) {
        ICManager.removeCachedIC(pt);
    }

    public static void emptyCache() {
        CraftBookPlugin.logDebugMessage("Culling cached IC list.", "ic-cache");
        cachedICs.clear();
    }

    public static Map<Location, IC> getCachedICs() {
        return cachedICs;
    }

    public static boolean hasCustomPrefix(String prefix) {
        return customPrefix.contains(prefix.toLowerCase(Locale.ENGLISH));
    }

    public List<RegisteredICFactory> getICList() {
        return new LinkedList<RegisteredICFactory>(this.registered.values());
    }

    public void registerICs(Server server) {
        this.registerIC("MC1000", "repeater", new Repeater.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1001", "inverter", new Inverter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1017", "re t flip", new ToggleFlipFlop.Factory(server, true), familySISO, familyAISO);
        this.registerIC("MC1018", "fe t flip", new ToggleFlipFlop.Factory(server, false), familySISO, familyAISO);
        this.registerIC("MC1020", "random bit", new RandomBit.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1025", "server time", new ServerTimeModulus.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1110", "transmitter", new WirelessTransmitter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1111", "receiver", new WirelessReceiver.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1112", "tele-out", new TeleportTransmitter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1113", "tele-in", new TeleportReciever.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1200", "spawner", new CreatureSpawner.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1201", "dispenser", new ItemDispenser.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1202", "c dispense", new ContainerDispenser.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1203", "strike", new LightningSummon.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1204", "trap", new EntityTrap.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1205", "set above", new SetBlockAdmin.Factory(server, true), familySISO, familyAISO);
        this.registerIC("MC1206", "set below", new SetBlockAdmin.Factory(server, false), familySISO, familyAISO);
        this.registerIC("MC1207", "flex set", new FlexibleSetBlock.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1208", "mult set", new MultipleSetBlock.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1209", "collector", new ContainerCollector.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1210", "emitter", new ParticleEffect.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1211", "set bridge", new SetBridge.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1212", "set door", new SetDoor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1213", "sound", new SoundEffect.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1214", "range coll", new RangedCollector.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1215", "set a chest", new SetBlockChest.Factory(server, true), familySISO, familyAISO);
        this.registerIC("MC1216", "set b chest", new SetBlockChest.Factory(server, false), familySISO, familyAISO);
        this.registerIC("MC1217", "pot induce", new PotionInducer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1218", "block launch", new BlockLauncher.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1219", "auto craft", new AutomaticCrafter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1220", "a b break", new BlockBreaker.Factory(server, false), familySISO, familyAISO);
        this.registerIC("MC1221", "b b break", new BlockBreaker.Factory(server, true), familySISO, familyAISO);
        this.registerIC("MC1222", "liq flood", new LiquidFlood.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1223", "terraform", new BonemealTerraformer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1224", "time bomb", new TimedExplosion.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1225", "pump", new Pump.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1226", "spigot", new Spigot.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1227", "avd spawner", new AdvancedEntitySpawner.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1228", "ent cannon", new EntityCannon.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1229", "sorter", new Sorter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1230", "sense day", new DaySensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1231", "t control", new TimeControl.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1232", "time set", new TimeSet.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1233", "item fan", new ItemFan.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1234", "planter", new Planter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1235", "cultivator", new Cultivator.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1236", "fake weather", new WeatherFaker.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1237", "fake time", new TimeFaker.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1238", "irrigate", new Irrigator.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1239", "harvester", new CombineHarvester.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1240", "shoot arrow", new ArrowShooter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1241", "shoot arrows", new ArrowBarrage.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1242", "stocker", new ContainerStocker.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1243", "distributer", new Distributer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1244", "animal harv", new AnimalHarvester.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1245", "cont stkr", new ContainerStacker.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1246", "xp spawner", new XPSpawner.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1248", "driller", new Driller.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1249", "replacer", new BlockReplacer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1250", "shoot fire", new FireShooter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1251", "shoot fires", new FireBarrage.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1252", "flame thower", new FlameThrower.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1253", "firework show", new ProgrammableFireworkShow.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1260", "sense water", new WaterSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1261", "sense lava", new LavaSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1262", "sense light", new LightSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1263", "sense block", new BlockSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1264", "sense item", new ItemSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1265", "inv sns itm", new ItemNotSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1266", "sense power", new PowerSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1268", "sns cntns", new ContentsSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1269", "sns p cntns", new PlayerInventorySensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1270", "melody", new Melody.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1271", "sns entity", new EntitySensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1272", "sns player", new PlayerSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1273", "jukebox", new Jukebox.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1275", "tune", new Tune.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1276", "radio station", new RadioStation.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1277", "radio player", new RadioPlayer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1278", "sentry gun", new SentryGun.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1279", "player trap", new PlayerTrap.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1280", "animal brd", new AnimalBreeder.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1420", "divide clock", new ClockDivider.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1421", "clock", new Clock.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1422", "monostable", new Monostable.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1500", "range output", new RangedOutput.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1510", "send message", new MessageSender.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2100", "delayer", new Delayer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2101", "inv delayer", new NotDelayer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2110", "fe delayer", new LowDelayer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2111", "inv fe delayer", new NotLowDelayer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2500", "pulser", new Pulser.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2501", "inv pulser", new NotPulser.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2510", "fe pulser", new LowPulser.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2511", "inv fe pulser", new LowNotPulser.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2020", "random 3", new Random3Bit.Factory(server), familySI3O);
        this.registerIC("MC2999", "marquee", new Marquee.Factory(server), familySI3O);
        this.registerIC("MC3002", "and", new AndGate.Factory(server), family3ISO);
        this.registerIC("MC3003", "nand", new NandGate.Factory(server), family3ISO);
        this.registerIC("MC3020", "xor", new XorGate.Factory(server), family3ISO);
        this.registerIC("MC3021", "xnor", new XnorGate.Factory(server), family3ISO);
        this.registerIC("MC3030", "nor flip", new RsNorFlipFlop.Factory(server), family3ISO);
        this.registerIC("MC3031", "inv nand latch", new InvertedRsNandLatch.Factory(server), family3ISO);
        this.registerIC("MC3032", "jk flip", new JkFlipFlop.Factory(server), family3ISO);
        this.registerIC("MC3033", "nand latch", new RsNandLatch.Factory(server), family3ISO);
        this.registerIC("MC3034", "edge df flip", new EdgeTriggerDFlipFlop.Factory(server), family3ISO);
        this.registerIC("MC3036", "level df flip", new LevelTriggeredDFlipFlop.Factory(server), family3ISO);
        this.registerIC("MC3040", "multiplexer", new Multiplexer.Factory(server), family3ISO);
        this.registerIC("MC3050", "combo", new CombinationLock.Factory(server), family3ISO);
        this.registerIC("MC3101", "down counter", new DownCounter.Factory(server), family3ISO);
        this.registerIC("MC3102", "counter", new Counter.Factory(server), family3ISO);
        this.registerIC("MC3231", "t control adva", new TimeControlAdvanced.Factory(server), family3ISO);
        this.registerIC("MC3300", "ROM set", new MemorySetter.Factory(server), family3ISO);
        this.registerIC("MC3301", "ROM get", new MemoryAccess.Factory(server), familySI3O);
        this.registerIC("MC4000", "full adder", new FullAdder.Factory(server), family3I3O);
        this.registerIC("MC4010", "half adder", new HalfAdder.Factory(server), family3I3O);
        this.registerIC("MC4040", "demultiplexer", new DeMultiplexer.Factory(server), family3I3O);
        this.registerIC("MC4100", "full subtr", new FullSubtractor.Factory(server), family3I3O);
        this.registerIC("MC4110", "half subtr", new HalfSubtractor.Factory(server), family3I3O);
        this.registerIC("MC4200", "dispatcher", new Dispatcher.Factory(server), family3I3O);
        this.registerIC("MC6020", "random 5", new Random5Bit.Factory(server), familySI5O);
        this.registerIC("MC5000", "perlstone", PlcFactory.fromLang(server, new Perlstone(), false, "MC5000"), familyVIVO);
        this.registerIC("MC5001", "perlstone 3i3o", PlcFactory.fromLang(server, new Perlstone(), false, "MC5001"), family3I3O);
        this.registerIC("MCX230", "rain sense", new RainSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MCX231", "storm sense", new TStormSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MCX233", "weather set", new WeatherControl.Factory(server), familySISO, familyAISO);
        this.registerIC("MCT233", "weather set ad", new WeatherControlAdvanced.Factory(server), family3ISO);
        if (VariableManager.instance != null) {
            this.registerIC("VAR100", "num mod", new NumericModifier.Factory(server), familySISO, familyAISO);
            this.registerIC("VAR170", "at least", new IsAtLeast.Factory(server), familySISO, familyAISO);
            this.registerIC("VAR200", "item count", new ItemCounter.Factory(server), familySISO, familyAISO);
        }
    }

    public String getSearchID(Player p, String search) {
        ArrayList<String> icNameList = new ArrayList<String>(this.registered.keySet());
        Collections.sort(icNameList);
        for (String ic : icNameList) {
            try {
                RegisteredICFactory ric = this.registered.get(ic);
                IC tic = ric.getFactory().create(null);
                if (search != null && !tic.getTitle().toLowerCase(Locale.ENGLISH).contains(search.toLowerCase(Locale.ENGLISH)) && !ric.getId().toLowerCase(Locale.ENGLISH).contains(search.toLowerCase(Locale.ENGLISH))) continue;
                return ic;
            }
            catch (Exception exception) {
            }
        }
        return "";
    }

    public String[] generateICText(Player p, String search, char[] parameters) {
        ArrayList<String> icNameList = new ArrayList<String>(this.registered.keySet());
        Collections.sort(icNameList);
        ArrayList<String> strings = new ArrayList<String>();
        boolean col = true;
        block2: for (String ic : icNameList) {
            try {
                ChatColor colour;
                RegisteredICFactory ric = this.registered.get(ic);
                IC tic = ric.getFactory().create(null);
                if (search != null && !tic.getTitle().toLowerCase(Locale.ENGLISH).contains(search.toLowerCase(Locale.ENGLISH)) && !ric.getId().toLowerCase(Locale.ENGLISH).contains(search.toLowerCase(Locale.ENGLISH))) continue;
                if (parameters != null) {
                    for (char c : parameters) {
                        if (c == 'r' && !(ric.getFactory() instanceof RestrictedIC) || c == 's' && ric.getFactory() instanceof RestrictedIC || c == 'b' && !ric.getFactory().getClass().getPackage().getName().endsWith("blocks") || c == 'i' && !ric.getFactory().getClass().getPackage().getName().endsWith("items") || c == 'e' && !ric.getFactory().getClass().getPackage().getName().endsWith("entity") || c == 'w' && !ric.getFactory().getClass().getPackage().getName().endsWith("weather") || c == 'l' && !ric.getFactory().getClass().getPackage().getName().endsWith("logic") || c == 'm' && !ric.getFactory().getClass().getPackage().getName().endsWith("miscellaneous") || c == 'c' && !ric.getFactory().getClass().getPackage().getName().endsWith("sensors") || c == 'v' && !ric.getFactory().getClass().getPackage().getName().endsWith("variables")) continue block2;
                    }
                }
                col = !col;
                ChatColor chatColor = colour = col ? ChatColor.YELLOW : ChatColor.GOLD;
                if (!ICMechanic.checkPermissionsBoolean(CraftBookPlugin.inst().wrapPlayer(p), ric.getFactory(), ic.toLowerCase(Locale.ENGLISH))) {
                    colour = col ? ChatColor.RED : ChatColor.DARK_RED;
                }
                strings.add(colour + tic.getTitle() + " (" + ric.getId() + "): " + (tic instanceof SelfTriggeredIC ? "ST " : "T ") + (ric.getFactory() instanceof RestrictedIC ? ChatColor.DARK_RED + "R " : ""));
            }
            catch (Throwable e) {
                CraftBookPlugin.logger().warning("An error occurred generating the docs for IC: " + ic + ".");
                CraftBookPlugin.logger().warning("Please report this error on: http://youtrack.sk89q.com/.");
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    static {
        cachedICs = new HashMap<Location, IC>();
        customPrefix = new HashSet<String>();
    }
}

