/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.ic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.ic.ChipState;
import com.sk89q.craftbook.mechanics.ic.ICFactory;
import com.sk89q.craftbook.mechanics.ic.ICMechanic;
import com.sk89q.craftbook.mechanics.ic.ICVerificationException;
import com.sk89q.craftbook.mechanics.ic.PersistentDataIC;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.bukkit.Server;

public abstract class AbstractICFactory
implements ICFactory {
    private final Server server;

    public AbstractICFactory(Server server) {
        this.server = server;
    }

    protected Server getServer() {
        return this.server;
    }

    @Override
    public void verify(ChangedSign sign) throws ICVerificationException {
    }

    @Override
    public void checkPlayer(ChangedSign sign, CraftBookPlayer player) throws ICVerificationException {
    }

    @Override
    public String getShortDescription() {
        return "No Description.";
    }

    @Override
    public String[] getLongDescription() {
        return new String[]{"Missing Description"};
    }

    @Override
    public String[] getLineHelp() {
        return new String[]{null, null};
    }

    @Override
    public String[] getPinDescription(ChipState state) {
        return new String[state.getInputCount() + state.getOutputCount()];
    }

    @Override
    public void load() {
        if (this instanceof PersistentDataIC && ICMechanic.instance.savePersistentData) {
            try {
                if (((PersistentDataIC)((Object)this)).getStorageFile().exists()) {
                    ((PersistentDataIC)((Object)this)).loadPersistentData(new DataInputStream(new FileInputStream(((PersistentDataIC)((Object)this)).getStorageFile())));
                }
            }
            catch (FileNotFoundException e) {
                CraftBookBukkitUtil.printStacktrace(e);
            }
            catch (IOException e) {
                CraftBookPlugin.logger().severe("An invalid ic save file was found!");
                CraftBookBukkitUtil.printStacktrace(e);
            }
        }
    }

    @Override
    public void unload() {
    }
}

