/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.drops.legacy;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.mechanics.drops.BlockCustomDropDefinition;
import com.sk89q.craftbook.mechanics.drops.CustomDrops;
import com.sk89q.craftbook.mechanics.drops.DropItemStack;
import com.sk89q.craftbook.mechanics.drops.EntityCustomDropDefinition;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.TernaryState;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public final class LegacyCustomDropManager {
    public static final int BLOCK_ID_COUNT = 256;
    public static final int DATA_VALUE_COUNT = 127;
    private CustomItemDrop[] blockDropDefinitions = new CustomItemDrop[256];
    private Map<String, DropDefinition[]> mobDropDefinitions = new TreeMap<String, DropDefinition[]>();
    int converted = 0;

    public LegacyCustomDropManager(File source) {
        File blockDefinitions = new File(source, "custom-block-drops.txt");
        File mobDefinitions = new File(source, "custom-mob-drops.txt");
        if (blockDefinitions.exists()) {
            try {
                this.loadDropDefinitions(blockDefinitions, false);
            }
            catch (CustomDropParseException e) {
                CraftBookPlugin.logger().log(Level.WARNING, "Custom block drop definitions failed to parse", e);
            }
            catch (IOException e) {
                CraftBookPlugin.logger().log(Level.SEVERE, "Unknown IO error while loading custom block drop definitions", e);
            }
            catch (Exception e) {
                CraftBookPlugin.logger().log(Level.SEVERE, "Unknown exception while loading custom block drop definitions", e);
            }
        }
        if (mobDefinitions.exists()) {
            try {
                this.loadDropDefinitions(mobDefinitions, true);
            }
            catch (CustomDropParseException e) {
                CraftBookPlugin.logger().log(Level.WARNING, "Custom mob drop definitions failed to parse", e);
            }
            catch (IOException e) {
                CraftBookPlugin.logger().log(Level.SEVERE, "Unknown IO error while loading custom mob drop definitions", e);
            }
            catch (Exception e) {
                CraftBookPlugin.logger().log(Level.SEVERE, "Unknown exception while loading custom mob drop definitions", e);
            }
        }
    }

    public CustomItemDrop getBlockDrops(int block) {
        if (block < 0 || block >= 256) {
            return null;
        }
        return this.blockDropDefinitions[block];
    }

    public DropDefinition[] getMobDrop(LivingEntity mob) {
        if (mob.getCustomName() != null && this.mobDropDefinitions.containsKey(ChatColor.translateAlternateColorCodes((char)'&', (String)(mob.getType().name() + "|" + mob.getCustomName()).toLowerCase(Locale.ENGLISH)))) {
            return this.mobDropDefinitions.get(ChatColor.translateAlternateColorCodes((char)'&', (String)(mob.getType().name() + "|" + mob.getCustomName()).toLowerCase(Locale.ENGLISH)));
        }
        return this.mobDropDefinitions.get(mob.getType().name().toLowerCase(Locale.ENGLISH));
    }

    public void loadDropDefinitions(File file, boolean isMobDrop) throws IOException {
        String prelude = "on unknown line";
        try {
            String line;
            CustomItemDrop[] blockDropDefinitions = isMobDrop ? null : new CustomItemDrop[256];
            TreeMap<String, DropDefinition[]> mobDropDefinitions = isMobDrop ? new TreeMap<String, DropDefinition[]>() : null;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            int currentLine = 0;
            while ((line = reader.readLine()) != null) {
                if (line.length() == 0 || line.trim().startsWith("#")) continue;
                prelude = "Error on line " + ++currentLine + " of drop definition file " + file.getAbsolutePath() + ": " + line + "\n";
                try {
                    if (line.contains("#")) {
                        line = RegexUtil.COMMENT_PATTERN.split(line)[0];
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((line = line.trim()).length() == 0) continue;
                String[] split = RegexUtil.FIELD_SEPARATOR_PATTERN.split(line, 2);
                if (split.length != 2) {
                    reader.close();
                    throw new CustomDropParseException(prelude + "-> not found");
                }
                String itemsSource = StringUtils.replace((String)split[0], (String)"+", (String)"").trim();
                String targetDrops = split[1].trim();
                if (itemsSource.length() == 0 || targetDrops.length() == 0) {
                    reader.close();
                    throw new CustomDropParseException(prelude + "unexpected empty field");
                }
                DropDefinition[] drops = LegacyCustomDropManager.readDrops(targetDrops, prelude, split[0].contains("+"));
                if (!isMobDrop) {
                    split = RegexUtil.COLON_PATTERN.split(itemsSource);
                    if (split.length > 2) {
                        reader.close();
                        throw new CustomDropParseException(prelude + "too many source block fields");
                    }
                    int sourceId = Integer.parseInt(split[0]);
                    if (sourceId >= 256 || sourceId < 0) {
                        reader.close();
                        throw new CustomDropParseException(prelude + "block id out of range");
                    }
                    if (blockDropDefinitions[sourceId] == null) {
                        blockDropDefinitions[sourceId] = new CustomItemDrop();
                    }
                    CustomItemDrop drop = blockDropDefinitions[sourceId];
                    int data = 0;
                    if (split.length == 1) {
                        if (drop.defaultDrop != null) {
                            reader.close();
                            throw new CustomDropParseException(prelude + "double drop definition");
                        }
                        drop.defaultDrop = drops;
                    } else {
                        data = Integer.parseInt(split[1]);
                        if (data >= 127 || data < 0) {
                            reader.close();
                            throw new CustomDropParseException(prelude + "block data value out of range");
                        }
                        if (drop.drops[data] != null) {
                            reader.close();
                            throw new CustomDropParseException(prelude + "double drop definition");
                        }
                        drop.drops[data] = drops;
                    }
                    ArrayList<DropItemStack> stacks = new ArrayList<DropItemStack>();
                    boolean append = false;
                    for (DropDefinition dd : drops) {
                        DropItemStack nstack = new DropItemStack(dd.stack);
                        nstack.setChance(dd.chance);
                        nstack.setMaximum(dd.countMax);
                        nstack.setMinimum(dd.countMin);
                        stacks.add(nstack);
                        if (!dd.append) continue;
                        append = true;
                    }
                    BlockState state = LegacyMapper.getInstance().getBlockFromLegacy(sourceId, data);
                    if (state == null) {
                        throw new CustomDropParseException("Unknown block: " + sourceId + ":" + data);
                    }
                    BlockCustomDropDefinition converted = new BlockCustomDropDefinition(sourceId + "" + data + "" + this.converted++, stacks, null, TernaryState.NONE, (BlockStateHolder)state);
                    converted.setAppend(append);
                    ((CustomDrops)CraftBookPlugin.inst().getMechanic(CustomDrops.class)).addDefinition(converted);
                    continue;
                }
                if (mobDropDefinitions.containsKey(itemsSource = ChatColor.translateAlternateColorCodes((char)'&', (String)itemsSource.toLowerCase(Locale.ENGLISH)))) {
                    reader.close();
                    throw new CustomDropParseException(prelude + "double drop definition");
                }
                mobDropDefinitions.put(itemsSource, drops);
            }
            reader.close();
            if (isMobDrop) {
                this.mobDropDefinitions = mobDropDefinitions;
                for (Map.Entry def : mobDropDefinitions.entrySet()) {
                    ArrayList<DropItemStack> stacks = new ArrayList<DropItemStack>();
                    boolean append = false;
                    for (DropDefinition dd : (DropDefinition[])def.getValue()) {
                        DropItemStack nstack = new DropItemStack(dd.stack);
                        nstack.setChance(dd.chance);
                        nstack.setMaximum(dd.countMax);
                        nstack.setMinimum(dd.countMin);
                        stacks.add(nstack);
                        if (!dd.append) continue;
                        append = true;
                    }
                    EntityCustomDropDefinition converted = new EntityCustomDropDefinition(((String)def.getKey()).toUpperCase() + "" + this.converted++, stacks, null, TernaryState.NONE, EntityType.valueOf((String)((String)def.getKey()).toUpperCase()));
                    converted.setAppend(append);
                    ((CustomDrops)CraftBookPlugin.inst().getMechanic(CustomDrops.class)).addDefinition(converted);
                }
            } else {
                this.blockDropDefinitions = blockDropDefinitions;
            }
        }
        catch (NumberFormatException e) {
            throw new CustomDropParseException(prelude + "number field failed to parse", e);
        }
    }

    private static DropDefinition[] readDrops(String s, String prelude, boolean append) throws IOException {
        String[] split = RegexUtil.COMMA_PATTERN.split(s);
        DropDefinition[] drops = new DropDefinition[split.length];
        for (int i = 0; i < split.length; ++i) {
            drops[i] = LegacyCustomDropManager.readDrop(split[i].trim(), prelude, append);
        }
        return drops;
    }

    private static DropDefinition readDrop(String s, String prelude, boolean append) throws IOException {
        String[] split = RegexUtil.X_PATTERN.split(RegexUtil.PERCENT_PATTERN.split(s)[0]);
        if (split.length > 2) {
            ArrayList<String> temp = new ArrayList<String>();
            for (int i = 0; i < split.length; ++i) {
                if (temp.isEmpty()) {
                    temp.add(split[i]);
                    continue;
                }
                if (i < split.length - 1) {
                    temp.set(0, (String)temp.get(0) + "x" + split[i]);
                    continue;
                }
                temp.add(split[i]);
            }
            split = temp.toArray(new String[temp.size()]);
        }
        if (split.length > 2) {
            throw new CustomDropParseException(prelude + ": too many drop item fields");
        }
        ItemStack stack = ItemUtil.makeItemValid(ItemSyntax.getItem(split[0]));
        String[] split3 = RegexUtil.MINUS_PATTERN.split(split[1].trim());
        if (split3.length > 2) {
            throw new CustomDropParseException(prelude + ": invalid number drops range");
        }
        int countMin = Integer.parseInt(split3[0]);
        int countMax = split3.length == 1 ? countMin : Integer.parseInt(split3[1]);
        double chance = 100.0;
        try {
            chance = Double.parseDouble(RegexUtil.PERCENT_PATTERN.split(s)[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DropDefinition(stack, countMin, countMax, chance, append);
    }

    public static class DropDefinition {
        public final ItemStack stack;
        public final int countMin;
        public final int countMax;
        public final boolean append;
        public final double chance;

        public DropDefinition(ItemStack stack, int countMin, int countMax, double chance, boolean append) {
            if (countMax < countMin) {
                int temp = countMin;
                countMin = countMax;
                countMax = temp;
            }
            this.chance = Math.min(100.0, Math.max(0.0, chance));
            this.stack = stack;
            this.countMin = countMin;
            this.countMax = countMax;
            this.append = append;
        }

        public ItemStack getItemStack() {
            if ((double)CraftBookPlugin.inst().getRandom().nextInt(100) > this.chance) {
                return null;
            }
            ItemStack stack = this.stack.clone();
            stack.setAmount(this.countMin == this.countMax ? this.countMin : this.countMin + CraftBookPlugin.inst().getRandom().nextInt(this.countMax - this.countMin + 1));
            return stack;
        }
    }

    public static class CustomItemDrop {
        public final DropDefinition[][] drops = new DropDefinition[127][];
        public DropDefinition[] defaultDrop;

        public DropDefinition[] getDrop(int data) {
            if (data < 0 || data >= 127) {
                return this.defaultDrop;
            }
            DropDefinition[] drop = this.drops[data];
            if (drop == null) {
                return this.defaultDrop;
            }
            return drop;
        }
    }

    public static class CustomDropParseException
    extends IOException {
        private static final long serialVersionUID = -1147409575702887124L;

        public CustomDropParseException(String message) {
            super(message);
        }

        public CustomDropParseException(String message, Throwable cause) {
            super(message);
        }
    }
}

