/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.cauldron.legacy;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;

@Deprecated
public class CauldronCookbook {
    private static final Pattern AT_PATTERN = Pattern.compile("@", 16);
    private static final Pattern ANYTHING_MULTIPLIED_BY_NUMBER_PATTERN = Pattern.compile("^.*\\*([0-9]+)$");
    private final List<Recipe> recipes = new ArrayList<Recipe>();

    public CauldronCookbook() {
        try {
            CauldronCookbook recipes = this.readCauldronRecipes("cauldron-recipes.txt");
            if (recipes.size() != 0) {
                CraftBookPlugin.logger().info(recipes.size() + " cauldron recipe(s) loaded");
            } else {
                CraftBookPlugin.logger().warning("cauldron-recipes.txt had no recipes");
            }
        }
        catch (FileNotFoundException e) {
            CraftBookPlugin.logger().info("cauldron-recipes.txt not found: " + e.getMessage());
            try {
                CraftBookPlugin.logger().info("Looked in: " + CraftBookPlugin.inst().getDataFolder().getCanonicalPath());
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            CraftBookPlugin.logger().warning("cauldron-recipes.txt not loaded: " + e.getMessage());
        }
    }

    public void add(Recipe recipe) {
        this.recipes.add(recipe);
    }

    public Recipe find(Map<BlockStateHolder, Integer> ingredients) {
        for (Recipe recipe : this.recipes) {
            if (!recipe.hasAllIngredients(ingredients)) continue;
            return recipe;
        }
        return null;
    }

    public int size() {
        return this.recipes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CauldronCookbook readCauldronRecipes(String path) throws IOException {
        CraftBookPlugin.inst().createDefaultConfiguration(new File(CraftBookPlugin.inst().getDataFolder(), path), path);
        File file = new File(CraftBookPlugin.inst().getDataFolder(), path);
        InputStreamReader input = null;
        try {
            String line;
            input = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            BufferedReader buff = new BufferedReader(input);
            while ((line = buff.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == ';' || line.charAt(0) == '#') continue;
                String[] parts = RegexUtil.COLON_PATTERN.split(line);
                if (parts.length < 3) {
                    CraftBookPlugin.logger().log(Level.WARNING, "Invalid cauldron recipe line in " + file.getName() + ": '" + line + "'");
                    continue;
                }
                String name = parts[0];
                List<BlockStateHolder> ingredients = this.parseCauldronItems(parts[1]);
                List<BlockStateHolder> results = this.parseCauldronItems(parts[2]);
                String[] groups = null;
                if (parts.length >= 4 && !parts[3].trim().isEmpty()) {
                    groups = RegexUtil.COMMA_PATTERN.split(parts[3]);
                }
                Recipe recipe = new Recipe(name, ingredients, results, groups);
                this.add(recipe);
            }
            buff.close();
            CauldronCookbook cauldronCookbook = this;
            return cauldronCookbook;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private List<BlockStateHolder> parseCauldronItems(String list) {
        String[] parts = RegexUtil.COMMA_PATTERN.split(list);
        ArrayList<BlockStateHolder> out = new ArrayList<BlockStateHolder>();
        for (String part : parts) {
            int multiplier = 1;
            try {
                if (ANYTHING_MULTIPLIED_BY_NUMBER_PATTERN.matcher(part).matches()) {
                    int at = part.lastIndexOf(42);
                    multiplier = Integer.parseInt(part.substring(at + 1));
                    part = part.substring(0, at);
                }
                try {
                    String[] split = AT_PATTERN.split(part);
                    BaseBlock state = BlockSyntax.getBlock(StringUtil.joinString((String[])split, (String)":"));
                    if (state == null) continue;
                    for (int i = 0; i < multiplier; ++i) {
                        out.add((BlockStateHolder)state);
                    }
                }
                catch (NumberFormatException e) {
                    CraftBookPlugin.logger().log(Level.WARNING, "Cauldron: Unknown item " + part);
                }
            }
            catch (NumberFormatException e) {
                CraftBookPlugin.logger().log(Level.WARNING, "Cauldron: Bad multiplier in '" + part + "'");
            }
        }
        return out;
    }

    public static final class Recipe {
        private final String name;
        private final List<BlockStateHolder> ingredients;
        private final Map<BlockStateHolder, Integer> ingredientLookup = new HashMap<BlockStateHolder, Integer>();
        private final List<BlockStateHolder> results;
        private final String[] groups;

        public Recipe(String name, List<BlockStateHolder> ingredients, List<BlockStateHolder> results, String[] groups) {
            this.name = name;
            this.ingredients = Collections.unmodifiableList(ingredients);
            this.results = Collections.unmodifiableList(results);
            this.groups = groups;
            for (BlockStateHolder id : ingredients) {
                if (this.ingredientLookup.containsKey(id)) {
                    this.ingredientLookup.put(id, this.ingredientLookup.get(id) + 1);
                    continue;
                }
                this.ingredientLookup.put(id, 1);
            }
        }

        public String getName() {
            return this.name;
        }

        public List<BlockStateHolder> getIngredients() {
            return this.ingredients;
        }

        public String[] getGroups() {
            return this.groups;
        }

        public boolean hasAllIngredients(Map<BlockStateHolder, Integer> check) {
            for (Map.Entry<BlockStateHolder, Integer> entry : this.ingredientLookup.entrySet()) {
                BlockStateHolder id = entry.getKey();
                if (!check.containsKey(id)) {
                    return false;
                }
                if (check.get(id) >= entry.getValue()) continue;
                return false;
            }
            return true;
        }

        public List<BlockStateHolder> getResults() {
            return this.results;
        }
    }
}

