/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.boat;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.entity.Boat;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.vehicle.VehicleCreateEvent;

public class SpeedModifiers
extends AbstractCraftBookMechanic {
    private double maxSpeed;
    private double unnoccupiedDeceleration;
    private double occupiedDeceleration;

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleCreate(VehicleCreateEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!(event.getVehicle() instanceof Boat)) {
            return;
        }
        if (this.maxSpeed > 0.0) {
            ((Boat)event.getVehicle()).setMaxSpeed(((Boat)event.getVehicle()).getMaxSpeed() * this.maxSpeed);
        }
        if (this.unnoccupiedDeceleration > 0.0) {
            ((Boat)event.getVehicle()).setUnoccupiedDeceleration(((Boat)event.getVehicle()).getUnoccupiedDeceleration() * this.unnoccupiedDeceleration);
        }
        if (this.occupiedDeceleration > 0.0) {
            ((Boat)event.getVehicle()).setOccupiedDeceleration(((Boat)event.getVehicle()).getOccupiedDeceleration() * this.occupiedDeceleration);
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "max-speed", "Sets the maximum speed of a boat. 0.4D is normal maximum speed.");
        this.maxSpeed = config.getDouble(path + "max-speed", 0.4);
        config.setComment(path + "unnoccupied-deceleration", "Sets the unnoccupied deceleration of a boat. -1 is disabled.");
        this.unnoccupiedDeceleration = config.getDouble(path + "unnoccupied-deceleration", -1.0);
        config.setComment(path + "occupied-deceleration", "Sets the occupied deceleration of a boat. 0.3 is normal occupied deceleration");
        this.occupiedDeceleration = config.getDouble(path + "occupied-deceleration", 0.2);
    }
}

