/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.boat;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.entity.Boat;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.util.Vector;

public class RemoveEntities
extends AbstractCraftBookMechanic {
    private static final Vector HALF_BLOCK_UP = new Vector(0.0, 0.5, 0.0);
    private boolean removeOtherBoats;

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleEntityCollision(VehicleEntityCollisionEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!(event.getVehicle() instanceof Boat)) {
            return;
        }
        if (!this.removeOtherBoats && (event.getEntity() instanceof Boat || event.getEntity().isInsideVehicle())) {
            return;
        }
        if (event.getVehicle().isEmpty()) {
            return;
        }
        if (event.getEntity() instanceof LivingEntity) {
            if (event.getEntity().isInsideVehicle()) {
                return;
            }
            ((LivingEntity)event.getEntity()).damage(10.0);
            try {
                event.getEntity().setVelocity(event.getVehicle().getVelocity().normalize().multiply(1.8).add(HALF_BLOCK_UP));
            }
            catch (IllegalArgumentException e) {
                event.getEntity().setVelocity(HALF_BLOCK_UP);
            }
        } else if (event.getEntity() instanceof Vehicle) {
            if (!event.getEntity().isEmpty()) {
                return;
            }
            event.getEntity().remove();
        } else {
            event.getEntity().remove();
        }
        event.setCancelled(true);
        event.setPickupCancelled(true);
        event.setCollisionCancelled(true);
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "remove-other-boats", "Allows the remove entities boats to remove other boats.");
        this.removeOtherBoats = config.getBoolean(path + "remove-other-boats", false);
    }
}

