/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.area.simple;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.events.SignClickEvent;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Gate
extends AbstractCraftBookMechanic {
    private boolean allowRedstone;
    private boolean limitColumns;
    private int columnLimit;
    private List<BaseBlock> blocks;
    private boolean enforceType;
    private int columnHeight;
    private int searchRadius;

    public boolean toggleGates(CraftBookPlayer player, Block block, boolean smallSearchSize, Boolean close) {
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        boolean foundGate = false;
        HashSet<GateColumn> visitedColumns = new HashSet<GateColumn>();
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(block);
        if (smallSearchSize) {
            for (int x1 = x - 1; x1 <= x + 1; ++x1) {
                for (int y1 = y - 2; y1 <= y + 1; ++y1) {
                    for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                        if (!this.recurseColumn(player, sign, block.getWorld().getBlockAt(x1, y1, z1), visitedColumns, close, true)) continue;
                        foundGate = true;
                    }
                }
            }
        } else {
            for (int x1 = x - this.searchRadius; x1 <= x + this.searchRadius; ++x1) {
                for (int y1 = y - this.searchRadius; y1 <= y + this.searchRadius * 2; ++y1) {
                    for (int z1 = z - this.searchRadius; z1 <= z + this.searchRadius; ++z1) {
                        if (!this.recurseColumn(player, sign, block.getWorld().getBlockAt(x1, y1, z1), visitedColumns, close, false)) continue;
                        foundGate = true;
                    }
                }
            }
        }
        return foundGate && visitedColumns.size() > 0;
    }

    private boolean recurseColumn(CraftBookPlayer player, ChangedSign sign, Block block, Set<GateColumn> visitedColumns, Boolean close, boolean smallSearchSize) {
        if (this.limitColumns && visitedColumns.size() > this.columnLimit) {
            return false;
        }
        if (!this.isValidGateBlock(sign, smallSearchSize, (BlockStateHolder<?>)BukkitAdapter.adapt((BlockData)block.getBlockData()), true)) {
            return false;
        }
        CraftBookPlugin.logDebugMessage("Found a possible gate column at " + block.getX() + ':' + block.getY() + ':' + block.getZ(), "gates.search");
        int x = block.getX();
        int z = block.getZ();
        GateColumn column = new GateColumn(sign, block, smallSearchSize);
        if (BlockUtil.isAir(block.getWorld().getBlockAt(x, column.getStartingY() + 1, z).getType())) {
            return false;
        }
        if (visitedColumns.contains(column)) {
            return false;
        }
        visitedColumns.add(column);
        if (close == null) {
            close = !this.isValidGateBlock(sign, smallSearchSize, (BlockStateHolder<?>)BukkitAdapter.adapt((BlockData)block.getWorld().getBlockAt(x, column.getStartingY() - 1, z).getBlockData()), true);
        }
        CraftBookPlugin.logDebugMessage("Valid column at " + block.getX() + ':' + block.getY() + ':' + block.getZ() + " is being " + (close != false ? "closed" : "opened"), "gates.search");
        CraftBookPlugin.logDebugMessage("Column Top: " + column.getStartingY() + " End: " + column.getEndingY(), "gates.search");
        return this.toggleColumn(player, sign, block, column, close, visitedColumns, smallSearchSize);
    }

    private boolean toggleColumn(CraftBookPlayer player, ChangedSign sign, Block block, GateColumn column, boolean close, Set<GateColumn> visitedColumns, boolean smallSearchSize) {
        BlockData item = close ? column.getStartingPoint().getBlockData() : Material.AIR.createBlockData();
        CraftBookPlugin.logDebugMessage("Setting column at " + block.getX() + ':' + block.getY() + ':' + block.getZ() + " to " + item.toString(), "gates.search");
        if (sign == null) {
            CraftBookPlugin.logDebugMessage("Invalid Sign!", "gates.search");
            return false;
        }
        ChangedSign otherSign = null;
        Block ot = SignUtil.getNextSign(CraftBookBukkitUtil.toSign(sign).getBlock(), sign.getLine(1), 4);
        if (ot != null) {
            otherSign = CraftBookBukkitUtil.toChangedSign(ot);
        }
        for (BlockVector3 bl : column.getRegion()) {
            Block blo = CraftBookBukkitUtil.toLocation(block.getWorld(), bl.toVector3()).getBlock();
            if (!sign.getLine(2).equalsIgnoreCase("NoReplace") ? !this.canPassThrough(sign, smallSearchSize, (BlockStateHolder)BukkitAdapter.adapt((BlockData)blo.getBlockData())) : blo.getType() != Material.AIR && !this.isValidGateBlock(sign, smallSearchSize, (BlockStateHolder<?>)BukkitAdapter.adapt((BlockData)blo.getBlockData()), true)) break;
            if (CraftBookPlugin.inst().getConfiguration().safeDestruction) {
                boolean hasBlocks = this.hasEnoughBlocks(sign, otherSign);
                if (!close || hasBlocks) {
                    if (!close && this.isValidGateBlock(sign, smallSearchSize, (BlockStateHolder<?>)BukkitAdapter.adapt((BlockData)blo.getBlockData()), true)) {
                        this.addBlocks(sign, 1);
                    } else if (close && this.canPassThrough(sign, smallSearchSize, (BlockStateHolder)BukkitAdapter.adapt((BlockData)blo.getBlockData())) && this.isValidGateBlock(sign, smallSearchSize, (BlockStateHolder<?>)BukkitAdapter.adapt((BlockData)item), true) && item.getMaterial() != blo.getType()) {
                        this.removeBlocks(sign, 1);
                    }
                    blo.setBlockData(item, true);
                } else if (this.isValidGateBlock(sign, smallSearchSize, (BlockStateHolder<?>)BukkitAdapter.adapt((BlockData)item), true) && player != null) {
                    player.printError("mech.not-enough-blocks");
                    return false;
                }
            } else {
                blo.setBlockData(item, true);
            }
            CraftBookPlugin.logDebugMessage("Set block " + bl.getX() + ':' + bl.getY() + ':' + bl.getZ() + " to " + item.toString(), "gates.search");
            this.recurseColumn(player, sign, blo.getRelative(1, 0, 0), visitedColumns, close, smallSearchSize);
            this.recurseColumn(player, sign, blo.getRelative(-1, 0, 0), visitedColumns, close, smallSearchSize);
            this.recurseColumn(player, sign, blo.getRelative(0, 0, 1), visitedColumns, close, smallSearchSize);
            this.recurseColumn(player, sign, blo.getRelative(0, 0, -1), visitedColumns, close, smallSearchSize);
        }
        this.recurseColumn(player, sign, column.getStartingPoint().getRelative(1, 0, 0), visitedColumns, close, smallSearchSize);
        this.recurseColumn(player, sign, column.getStartingPoint().getRelative(-1, 0, 0), visitedColumns, close, smallSearchSize);
        this.recurseColumn(player, sign, column.getStartingPoint().getRelative(0, 0, 1), visitedColumns, close, smallSearchSize);
        this.recurseColumn(player, sign, column.getStartingPoint().getRelative(0, 0, -1), visitedColumns, close, smallSearchSize);
        this.recurseColumn(player, sign, column.getStartingPoint().getRelative(1, 1, 0), visitedColumns, close, smallSearchSize);
        this.recurseColumn(player, sign, column.getStartingPoint().getRelative(-1, 1, 0), visitedColumns, close, smallSearchSize);
        this.recurseColumn(player, sign, column.getStartingPoint().getRelative(0, 1, 1), visitedColumns, close, smallSearchSize);
        this.recurseColumn(player, sign, column.getStartingPoint().getRelative(0, 1, -1), visitedColumns, close, smallSearchSize);
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        ChangedSign sign = event.getSign();
        if (!sign.getLine(1).equals("[Gate]") && !sign.getLine(1).equals("[DGate]")) {
            return;
        }
        boolean smallSearchSize = sign.getLine(1).equals("[DGate]");
        BlockState gateBlock = this.getGateBlock(sign, smallSearchSize);
        if (CraftBookPlugin.inst().getConfiguration().safeDestruction && player.getItemInHand(HandSide.MAIN_HAND).getType().hasBlockType()) {
            BlockType heldType = player.getItemInHand(HandSide.MAIN_HAND).getType().getBlockType();
            if ((gateBlock == null || gateBlock.getBlockType().getMaterial().isAir() || gateBlock.getBlockType() == heldType) && this.isValidGateBlock(sign, smallSearchSize, (BlockStateHolder<?>)heldType.getDefaultState(), false)) {
                if (!player.hasPermission("craftbook.mech.gate.restock")) {
                    if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                        player.printError("mech.restock-permission");
                    }
                    return;
                }
                int amount = 1;
                if (event.getPlayer().isSneaking()) {
                    amount = Math.min(5, event.getPlayer().getItemInHand().getAmount());
                }
                this.addBlocks(sign, amount);
                if (this.enforceType) {
                    BlockType blockType = player.getItemInHand(HandSide.MAIN_HAND).getType().getBlockType();
                    sign.setLine(0, BlockSyntax.toMinifiedId(blockType));
                    sign.update(false);
                }
                if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    if (event.getPlayer().getItemInHand().getAmount() <= amount) {
                        event.getPlayer().setItemInHand(null);
                    } else {
                        event.getPlayer().getItemInHand().setAmount(event.getPlayer().getItemInHand().getAmount() - amount);
                    }
                }
                player.print("mech.restock");
                event.setCancelled(true);
                return;
            }
        }
        if (!player.hasPermission("craftbook.mech.gate.use")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("mech.use-permission");
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("area.use-permissions");
            }
            return;
        }
        if (this.toggleGates(player, event.getClickedBlock(), smallSearchSize, null)) {
            player.print("mech.gate.toggle");
        } else {
            player.printError("mech.gate.not-found");
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!this.allowRedstone) {
            return;
        }
        if (event.isMinor()) {
            return;
        }
        if (!SignUtil.isSign(event.getBlock())) {
            return;
        }
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(event.getBlock());
        if (!sign.getLine(1).equals("[Gate]") && !sign.getLine(1).equals("[DGate]")) {
            return;
        }
        CraftBookPlugin.inst().getServer().getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> this.toggleGates(null, event.getBlock(), sign.getLine(1).equals("[DGate]"), event.getNewCurrent() > 0), 2L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.getLine(1).equalsIgnoreCase("[Gate]") && !event.getLine(1).equalsIgnoreCase("[DGate]")) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (event.getLine(1).equalsIgnoreCase("[Gate]")) {
            if (!player.hasPermission("craftbook.mech.gate")) {
                if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                    player.printError("mech.create-permission");
                }
                SignUtil.cancelSign(event);
                return;
            }
            String line0 = event.getLine(0).trim();
            if (!line0.isEmpty() && !this.isValidGateBlock((BlockStateHolder)BlockSyntax.getBlock(line0, true))) {
                player.printError("Line 1 needs to be a valid block id.");
                SignUtil.cancelSign(event);
                return;
            }
            event.setLine(1, "[Gate]");
            if (event.getLine(3).equalsIgnoreCase("infinite") && !player.hasPermission("craftbook.mech.gate.infinite")) {
                event.setLine(3, "0");
            } else if (!event.getLine(3).equalsIgnoreCase("infinite")) {
                event.setLine(3, "0");
            }
            player.print("mech.gate.create");
        } else if (event.getLine(1).equalsIgnoreCase("[DGate]")) {
            if (!player.hasPermission("craftbook.mech.gate") && !player.hasPermission("craftbook.mech.dgate")) {
                if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                    player.printError("mech.create-permission");
                }
                SignUtil.cancelSign(event);
                return;
            }
            String line0 = event.getLine(0).trim();
            if (!line0.isEmpty() && !this.isValidGateBlock((BlockStateHolder)BlockSyntax.getBlock(line0, true))) {
                player.printError("mech.gate.valid-item");
                SignUtil.cancelSign(event);
                return;
            }
            event.setLine(1, "[DGate]");
            if (event.getLine(3).equalsIgnoreCase("infinite") && !player.hasPermission("craftbook.mech.gate.infinite")) {
                event.setLine(3, "0");
            } else if (!event.getLine(3).equalsIgnoreCase("infinite")) {
                event.setLine(3, "0");
            }
            player.print("mech.dgate.create");
        }
    }

    public boolean isValidGateBlock(BlockStateHolder block) {
        return Blocks.containsFuzzy(this.blocks, (BlockStateHolder)block);
    }

    public boolean isValidGateBlock(ChangedSign sign, boolean smallSearchSize, BlockStateHolder<?> block, boolean check) {
        BlockState type;
        if (sign != null && !sign.getLine(0).isEmpty()) {
            try {
                BaseBlock def = BlockSyntax.getBlock(sign.getLine(0), true);
                return block.equalsFuzzy((BlockStateHolder)def);
            }
            catch (Exception e) {
                BlockState type2;
                if (check && ((type2 = this.getGateBlock(sign, smallSearchSize)) == null || type2.getBlockType().getMaterial().isAir())) {
                    return block.getBlockType().getMaterial().isAir();
                }
                return this.isValidGateBlock(block);
            }
        }
        if (check && (type = this.getGateBlock(sign, smallSearchSize)) != null) {
            return block.equalsFuzzy((BlockStateHolder)type);
        }
        return this.isValidGateBlock(block);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!SignUtil.isSign(event.getBlock())) {
            return;
        }
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(event.getBlock());
        if (!sign.getLine(1).equals("[Gate]") && !sign.getLine(1).equals("[DGate]")) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!ProtectionUtil.canBuild(event.getPlayer(), event.getBlock().getLocation(), false)) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("area.break-permissions");
            }
            return;
        }
        int amount = this.getBlocks(sign);
        if (amount > 0) {
            BlockState type = this.getGateBlock(sign, sign.getLine(1).equals("[DGate]"));
            if (type == null || type.getBlockType().getMaterial().isAir()) {
                type = BlockTypes.OAK_FENCE.getFuzzyMatcher();
            }
            ItemStack toDrop = new ItemStack(BukkitAdapter.adapt((BlockType)type.getBlockType()), amount);
            event.getBlock().getWorld().dropItemNaturally(BlockUtil.getBlockCentre(event.getBlock()), toDrop);
        }
    }

    private boolean canPassThrough(ChangedSign sign, boolean smallSearchSize, BlockStateHolder t) {
        if (!t.getBlockType().getMaterial().isMovementBlocker()) {
            return true;
        }
        return this.isValidGateBlock(sign, smallSearchSize, t, true);
    }

    public BlockState getGateBlock(ChangedSign sign, boolean smallSearchSize) {
        BlockState gateBlock = null;
        if (sign != null) {
            if (!sign.getLine(0).isEmpty()) {
                try {
                    return BlockSyntax.getBlock(sign.getLine(0), true).toImmutableState();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int x = sign.getX();
            int y = sign.getY();
            int z = sign.getZ();
            if (smallSearchSize) {
                for (int x1 = x - 1; x1 <= x + 1; ++x1) {
                    block3: for (int y1 = y - 2; y1 <= y + 1; ++y1) {
                        for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                            if (this.getFirstBlock(sign, sign.getBlock().getWorld().getBlockAt(x1, y1, z1), true) == null) continue;
                            gateBlock = BukkitAdapter.adapt((BlockData)this.getFirstBlock(sign, sign.getBlock().getWorld().getBlockAt(x1, y1, z1), true).getBlockData());
                            continue block3;
                        }
                    }
                }
            } else {
                for (int x1 = x - this.searchRadius; x1 <= x + this.searchRadius; ++x1) {
                    block6: for (int y1 = y - this.searchRadius; y1 <= y + this.searchRadius * 2; ++y1) {
                        for (int z1 = z - this.searchRadius; z1 <= z + this.searchRadius; ++z1) {
                            if (this.getFirstBlock(sign, sign.getBlock().getWorld().getBlockAt(x1, y1, z1), false) == null) continue;
                            gateBlock = BukkitAdapter.adapt((BlockData)this.getFirstBlock(sign, sign.getBlock().getWorld().getBlockAt(x1, y1, z1), false).getBlockData());
                            continue block6;
                        }
                    }
                }
            }
            if (this.enforceType && gateBlock != null && !gateBlock.getBlockType().getMaterial().isAir()) {
                sign.setLine(0, BlockSyntax.toMinifiedId(gateBlock.getBlockType()));
                sign.update(false);
            }
        }
        return gateBlock;
    }

    public Block getFirstBlock(ChangedSign sign, Block block, boolean smallSearchSize) {
        if (!this.isValidGateBlock(sign, smallSearchSize, (BlockStateHolder<?>)BukkitAdapter.adapt((BlockData)block.getBlockData()), false)) {
            return null;
        }
        return block;
    }

    public void removeBlocks(ChangedSign s, int amount) {
        if (s.getLine(3).equalsIgnoreCase("infinite")) {
            return;
        }
        this.setBlocks(s, this.getBlocks(s) - amount);
    }

    public void addBlocks(ChangedSign s, int amount) {
        if (s.getLine(3).equalsIgnoreCase("infinite")) {
            return;
        }
        this.setBlocks(s, this.getBlocks(s) + amount);
    }

    public void setBlocks(ChangedSign s, int amount) {
        if (s.getLine(3).equalsIgnoreCase("infinite")) {
            return;
        }
        s.setLine(3, String.valueOf(amount));
        s.update(false);
    }

    public int getBlocks(ChangedSign s) {
        if (s.getLine(3).equalsIgnoreCase("infinite")) {
            return 0;
        }
        return this.getBlocks(s, null);
    }

    public int getBlocks(ChangedSign s, ChangedSign other) {
        int curBlocks;
        if (s.getLine(3).equalsIgnoreCase("infinite") || other != null && other.getLine(3).equalsIgnoreCase("infinite")) {
            return 0;
        }
        try {
            curBlocks = Integer.parseInt(s.getLine(3));
            if (other != null && other.getLine(0).equals(s.getLine(0))) {
                try {
                    this.setBlocks(s, curBlocks += Integer.parseInt(other.getLine(3)));
                    this.setBlocks(other, 0);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            curBlocks = 0;
        }
        return curBlocks;
    }

    public boolean hasEnoughBlocks(ChangedSign s) {
        return s.getLine(3).equalsIgnoreCase("infinite") || this.getBlocks(s) > 0;
    }

    public boolean hasEnoughBlocks(ChangedSign s, ChangedSign other) {
        if (other == null) {
            return this.hasEnoughBlocks(s);
        }
        return s.getLine(3).equalsIgnoreCase("infinite") || other.getLine(3).equalsIgnoreCase("infinite") || this.getBlocks(s, other) > 0;
    }

    public List<String> getDefaultBlocks() {
        ArrayList<String> materials = new ArrayList<String>();
        materials.add(BlockTypes.ACACIA_FENCE.getId());
        materials.add(BlockTypes.BIRCH_FENCE.getId());
        materials.add(BlockTypes.JUNGLE_FENCE.getId());
        materials.add(BlockTypes.OAK_FENCE.getId());
        materials.add(BlockTypes.SPRUCE_FENCE.getId());
        materials.add(BlockTypes.DARK_OAK_FENCE.getId());
        materials.add(BlockTypes.NETHER_BRICK_FENCE.getId());
        materials.add(BlockTypes.IRON_BARS.getId());
        materials.add(BlockTypes.GLASS_PANE.getId());
        return materials;
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "allow-redstone", "Allows the gate mechanic to be toggled via redstone.");
        this.allowRedstone = config.getBoolean(path + "allow-redstone", true);
        config.setComment(path + "limit-columns", "Limit the amount of columns a gate can toggle.");
        this.limitColumns = config.getBoolean(path + "limit-columns", true);
        config.setComment(path + "max-columns", "If limit-columns is enabled, the maximum number of columns that a gate can toggle.");
        this.columnLimit = config.getInt(path + "max-columns", 14);
        config.setComment(path + "blocks", "The list of blocks that a gate can use.");
        this.blocks = BlockSyntax.getBlocks(config.getStringList(path + "blocks", this.getDefaultBlocks()), true);
        config.setComment(path + "enforce-type", "Make sure gates are only able to toggle a specific material type. This prevents transmutation.");
        this.enforceType = config.getBoolean(path + "enforce-type", true);
        config.setComment(path + "max-column-height", "The max height of a column.");
        this.columnHeight = config.getInt(path + "max-column-height", 12);
        config.setComment(path + "gate-search-radius", "The radius around the sign the gate checks for fences in. Note: This is doubled upwards.");
        this.searchRadius = config.getInt(path + "gate-search-radius", 3);
    }

    protected class GateColumn {
        private final ChangedSign sign;
        private final Block block;
        private final boolean smallSearchSize;
        private int minY = -1;
        private int maxY = -1;
        private int remainingColumnHeight;

        public GateColumn(ChangedSign sign, Block block, boolean smallSearchSize) {
            this.sign = sign;
            this.block = block;
            this.smallSearchSize = smallSearchSize;
            this.remainingColumnHeight = Gate.this.columnHeight;
        }

        public Block getStartingPoint() {
            return this.block.getWorld().getBlockAt(this.block.getX(), this.getStartingY(), this.block.getZ());
        }

        public Block getEndingPoint() {
            return this.block.getWorld().getBlockAt(this.block.getX(), this.getEndingY(), this.block.getZ());
        }

        public int getStartingY() {
            if (this.maxY == -1) {
                int max = Math.min(this.block.getWorld().getMaxHeight() - 1, this.block.getY() + this.remainingColumnHeight);
                int y1 = this.block.getY() + 1;
                while (y1 <= max && this.remainingColumnHeight > 0 && Gate.this.isValidGateBlock(this.sign, this.smallSearchSize, (BlockStateHolder<?>)BukkitAdapter.adapt((BlockData)this.block.getWorld().getBlockAt(this.block.getX(), y1, this.block.getZ()).getBlockData()), true)) {
                    this.maxY = y1++;
                    --this.remainingColumnHeight;
                }
                if (this.maxY == -1) {
                    this.maxY = this.block.getY();
                }
            }
            return this.maxY;
        }

        public int getEndingY() {
            if (this.minY == -1) {
                BlockState currentBlock;
                int min = Math.max(0, this.block.getY() - this.remainingColumnHeight);
                int y = this.block.getY();
                while (y >= min && this.remainingColumnHeight > 0 && (Gate.this.canPassThrough(this.sign, this.smallSearchSize, (BlockStateHolder)(currentBlock = BukkitAdapter.adapt((BlockData)this.block.getWorld().getBlockAt(this.block.getX(), y, this.block.getZ()).getBlockData()))) || Gate.this.isValidGateBlock(this.sign, this.smallSearchSize, (BlockStateHolder<?>)currentBlock, true))) {
                    this.minY = y--;
                    --this.remainingColumnHeight;
                }
                if (this.minY == -1) {
                    this.minY = this.block.getY();
                }
            }
            return this.minY;
        }

        public int getX() {
            return this.block.getX();
        }

        public int getZ() {
            return this.block.getZ();
        }

        public CuboidRegion getRegion() {
            return new CuboidRegion(BukkitAdapter.adapt((Location)this.getStartingPoint().getRelative(0, -1, 0).getLocation()).toVector().toBlockPoint(), BukkitAdapter.adapt((Location)this.getEndingPoint().getLocation()).toVector().toBlockPoint());
        }

        public boolean equals(Object o) {
            return o instanceof GateColumn && ((GateColumn)o).getX() == this.getX() && ((GateColumn)o).getZ() == this.getZ() && this.block.getWorld().getName().equals(((GateColumn)o).block.getWorld().getName());
        }

        public int hashCode() {
            return (this.getX() * 1103515245 + 12345 ^ this.getZ() * 1103515245 + 12345) * 1103515245 + 12345;
        }
    }
}

