/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.area.simple;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.mechanics.area.simple.CuboidToggleMechanic;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.events.SignClickEvent;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.util.exceptions.InvalidMechanismException;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Door
extends CuboidToggleMechanic {
    private boolean allowRedstone;
    private int maxLength;
    private int maxWidth;
    private List<BaseBlock> blocks;

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!(event.getLine(1).equalsIgnoreCase("[door]") || event.getLine(1).equalsIgnoreCase("[door up]") || event.getLine(1).equalsIgnoreCase("[door down]"))) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.mech.door")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("mech.create-permission");
            }
            SignUtil.cancelSign(event);
            return;
        }
        if (event.getLine(0).equalsIgnoreCase("infinite") && !player.hasPermission("craftbook.mech.door.infinite")) {
            event.setLine(0, "0");
        } else if (!event.getLine(0).equalsIgnoreCase("infinite")) {
            event.setLine(0, "0");
        }
        player.print("mech.door.create");
        if (event.getLine(1).equalsIgnoreCase("[door]")) {
            event.setLine(1, "[Door]");
        } else if (event.getLine(1).equalsIgnoreCase("[door up]")) {
            event.setLine(1, "[Door Up]");
        } else if (event.getLine(1).equalsIgnoreCase("[door down]")) {
            event.setLine(1, "[Door Down]");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        block18: {
            if (!EventUtil.passesFilter((Event)event)) {
                return;
            }
            if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                return;
            }
            if (!this.isApplicableSign(CraftBookBukkitUtil.toChangedSign(event.getClickedBlock()).getLine(1))) {
                return;
            }
            CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
            if (!player.hasPermission("craftbook.mech.door.use")) {
                if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                    player.printError("mech.use-permission");
                }
                return;
            }
            if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
                if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                    player.printError("area.use-permissions");
                }
                return;
            }
            try {
                ChangedSign sign = event.getSign();
                if (CraftBookPlugin.inst().getConfiguration().safeDestruction && sign != null && !sign.getLine(0).equalsIgnoreCase("infinite") && event.getPlayer().getItemInHand().getType() != Material.AIR && this.getBlockBase(event.getClickedBlock()).getType() == event.getPlayer().getItemInHand().getType() && this.getBlockBase(event.getClickedBlock()).getData() == event.getPlayer().getItemInHand().getData().getData()) {
                    if (!player.hasPermission("craftbook.mech.door.restock")) {
                        if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                            player.printError("mech.restock-permission");
                        }
                        return;
                    }
                    int amount = 1;
                    if (event.getPlayer().isSneaking() && event.getPlayer().getItemInHand().getAmount() >= 5) {
                        amount = 5;
                    }
                    Door.addBlocks(sign, CraftBookBukkitUtil.toChangedSign(this.getFarSign(event.getClickedBlock())), amount);
                    if (this.enforceType) {
                        BlockType blockType = player.getItemInHand(HandSide.MAIN_HAND).getType().getBlockType();
                        sign.setLine(0, sign.getLine(0) + ',' + BlockSyntax.toMinifiedId((BlockStateHolder)blockType.getFuzzyMatcher()));
                        sign.update(false);
                    }
                    if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                        if (event.getPlayer().getItemInHand().getAmount() <= amount) {
                            event.getPlayer().setItemInHand(new ItemStack(Material.AIR, 0));
                        } else {
                            event.getPlayer().getItemInHand().setAmount(event.getPlayer().getItemInHand().getAmount() - amount);
                        }
                    }
                    player.print("mech.restock");
                    event.setCancelled(true);
                    return;
                }
                event.setCancelled(true);
                if (this.flipState(event.getClickedBlock(), player)) {
                    player.print("mech.door.toggle");
                }
            }
            catch (InvalidMechanismException e) {
                if (e.getMessage() == null) break block18;
                player.printError(e.getMessage());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!this.allowRedstone) {
            return;
        }
        if (event.isMinor()) {
            return;
        }
        if (!SignUtil.isSign(event.getBlock())) {
            return;
        }
        if (!this.isApplicableSign(CraftBookBukkitUtil.toChangedSign(event.getBlock()).getLine(1))) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
            try {
                this.flipState(event.getBlock(), null);
            }
            catch (InvalidMechanismException invalidMechanismException) {
                // empty catch block
            }
        }, 2L);
    }

    public boolean flipState(Block trigger, CraftBookPlayer player) throws InvalidMechanismException {
        BlockData doorType;
        if (!SignUtil.isCardinal(trigger)) {
            throw new InvalidMechanismException();
        }
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(trigger);
        Block proximalBaseCenter = this.getBlockBase(trigger);
        if (!BlockUtil.areBlocksIdentical(proximalBaseCenter, doorType = this.getBlockType(trigger))) {
            throw new InvalidMechanismException("mech.bridge.material");
        }
        Block farSide = this.getFarSign(trigger);
        if (farSide.getType() != trigger.getType()) {
            throw new InvalidMechanismException("mech.door.other-sign");
        }
        Block distalBaseCenter = null;
        if (sign.getLine(1).equalsIgnoreCase("[Door Up]")) {
            distalBaseCenter = farSide.getRelative(BlockFace.DOWN);
        } else if (sign.getLine(1).equalsIgnoreCase("[Door Down]")) {
            distalBaseCenter = farSide.getRelative(BlockFace.UP);
        }
        if (!BlockUtil.areBlocksIdentical(distalBaseCenter, proximalBaseCenter)) {
            throw new InvalidMechanismException("mech.door.material");
        }
        CuboidRegion toggle = this.getCuboidArea(trigger, proximalBaseCenter, distalBaseCenter);
        Block hinge = sign.getLine(1).equals("[Door Up]") ? proximalBaseCenter.getRelative(BlockFace.UP) : proximalBaseCenter.getRelative(BlockFace.DOWN);
        if (BlockUtil.isBlockReplacable(hinge.getType()) && proximalBaseCenter.getType() != hinge.getType()) {
            return Door.close(trigger, farSide, doorType, toggle, player);
        }
        return Door.open(trigger, farSide, doorType, toggle);
    }

    @Override
    public Block getFarSign(Block trigger) {
        String otherSignText;
        Block otherSide = null;
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(trigger);
        if (sign.getLine(1).equals("[Door Up]")) {
            otherSide = trigger.getRelative(BlockFace.UP);
        } else if (sign.getLine(1).equals("[Door Down]")) {
            otherSide = trigger.getRelative(BlockFace.DOWN);
        }
        for (int i = 0; !(i > this.maxLength || SignUtil.isSign(otherSide) && (this.isApplicableSign(otherSignText = CraftBookBukkitUtil.toChangedSign(otherSide).getLine(1)) || "[Door]".equals(otherSignText))); ++i) {
            if (sign.getLine(1).equals("[Door Up]")) {
                otherSide = otherSide.getRelative(BlockFace.UP);
                continue;
            }
            if (!sign.getLine(1).equals("[Door Down]")) continue;
            otherSide = otherSide.getRelative(BlockFace.DOWN);
        }
        return otherSide;
    }

    @Override
    public Block getBlockBase(Block trigger) throws InvalidMechanismException {
        ChangedSign s = CraftBookBukkitUtil.toChangedSign(trigger);
        Block proximalBaseCenter = null;
        if (s.getLine(1).equalsIgnoreCase("[Door Up]")) {
            proximalBaseCenter = trigger.getRelative(BlockFace.UP);
        } else if (s.getLine(1).equalsIgnoreCase("[Door Down]")) {
            proximalBaseCenter = trigger.getRelative(BlockFace.DOWN);
        } else {
            throw new InvalidMechanismException("Sign is incorrectly made.");
        }
        if (Blocks.containsFuzzy(this.blocks, (BlockStateHolder)BukkitAdapter.adapt((BlockData)proximalBaseCenter.getBlockData()))) {
            return proximalBaseCenter;
        }
        throw new InvalidMechanismException("mech.door.unusable");
    }

    @Override
    public CuboidRegion getCuboidArea(Block trigger, Block proximalBaseCenter, Block distalBaseCenter) throws InvalidMechanismException {
        int i;
        int right;
        int left;
        double distance = proximalBaseCenter.getLocation().distanceSquared(distalBaseCenter.getLocation());
        if (distance <= 4.0) {
            throw new InvalidMechanismException("Door too short!");
        }
        CuboidRegion toggle = new CuboidRegion(CraftBookBukkitUtil.toVector(proximalBaseCenter), CraftBookBukkitUtil.toVector(distalBaseCenter));
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(trigger);
        try {
            left = Math.max(0, Math.min(this.maxWidth, Integer.parseInt(sign.getLine(2))));
        }
        catch (Exception e) {
            left = 1;
        }
        try {
            right = Math.max(0, Math.min(this.maxWidth, Integer.parseInt(sign.getLine(3))));
        }
        catch (Exception e) {
            right = 1;
        }
        for (i = 0; i < left; ++i) {
            if (distalBaseCenter.getRelative(SignUtil.getLeft(trigger), i).getType() != proximalBaseCenter.getRelative(SignUtil.getLeft(trigger), i).getType()) {
                throw new InvalidMechanismException("mech.door.material");
            }
            toggle.expand(new BlockVector3[]{CraftBookBukkitUtil.toVector(SignUtil.getLeft(trigger)), BlockVector3.ZERO});
        }
        for (i = 0; i < right; ++i) {
            if (distalBaseCenter.getRelative(SignUtil.getRight(trigger), i).getType() != proximalBaseCenter.getRelative(SignUtil.getRight(trigger), i).getType()) {
                throw new InvalidMechanismException("mech.door.material");
            }
            toggle.expand(new BlockVector3[]{CraftBookBukkitUtil.toVector(SignUtil.getRight(trigger)), BlockVector3.ZERO});
        }
        toggle.contract(new BlockVector3[]{CraftBookBukkitUtil.toVector(BlockFace.UP), CraftBookBukkitUtil.toVector(BlockFace.DOWN)});
        return toggle;
    }

    @Override
    public boolean isApplicableSign(String line) {
        return line.equals("[Door Up]") || line.equals("[Door Down]");
    }

    public List<String> getDefaultBlocks() {
        ArrayList<String> materials = new ArrayList<String>();
        materials.add(BlockTypes.COBBLESTONE.getId());
        materials.add(BlockTypes.GLASS.getId());
        materials.addAll(BlockCategories.PLANKS.getAll().stream().map(BlockType::getId).collect(Collectors.toList()));
        materials.addAll(BlockCategories.SLABS.getAll().stream().map(BlockType::getId).collect(Collectors.toList()));
        return materials;
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        super.loadConfiguration(config, path);
        config.setComment(path + "allow-redstone", "Allow doors to be toggled via redstone.");
        this.allowRedstone = config.getBoolean(path + "allow-redstone", true);
        config.setComment(path + "max-length", "The maximum length(height) of a door.");
        this.maxLength = config.getInt(path + "max-length", 30);
        config.setComment(path + "max-width", "Max width either side. 5 = 11, 1 in middle, 5 on either side");
        this.maxWidth = config.getInt(path + "max-width", 5);
        config.setComment(path + "blocks", "A list of blocks that a door can be made out of.");
        this.blocks = BlockSyntax.getBlocks(config.getStringList(path + "blocks", this.getDefaultBlocks().stream().sorted(String::compareToIgnoreCase).collect(Collectors.toList())), true);
    }
}

