/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics.area;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.HistoryHashMap;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CopyManager {
    private static CraftBookPlugin plugin = CraftBookPlugin.inst();
    private static final CopyManager INSTANCE = new CopyManager();
    private static final Pattern NAME_PATTERN = Pattern.compile("^[a-z0-9_]+$", 2);
    private final HistoryHashMap<String, BlockArrayClipboard> cache = new HistoryHashMap(10);
    private final HistoryHashMap<String, Long> missing = new HistoryHashMap(10);

    public static CopyManager getInstance() {
        return INSTANCE;
    }

    public static boolean isValidName(String name) {
        return !name.isEmpty() && name.length() <= 13 && NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isValidNamespace(String name) {
        return !name.isEmpty() && name.length() <= 14 && NAME_PATTERN.matcher(name).matches();
    }

    public static void renameNamespace(File dataFolder, String originalName, String newName) {
        File oldDir = new File(dataFolder, "areas/" + originalName);
        File newDir = new File(dataFolder, "areas/" + newName);
        if (oldDir.isDirectory()) {
            oldDir.renameTo(newDir);
        } else {
            oldDir.mkdir();
            oldDir.renameTo(newDir);
        }
    }

    public static boolean isExistingArea(File dataFolder, String namespace, String area) {
        area = StringUtils.replace((String)area, (String)"-", (String)"");
        File file = new File(dataFolder, "areas/" + namespace);
        if (!new File(file, area + CopyManager.getFileSuffix()).exists()) {
            return new File(file, area + '.' + BuiltInClipboardFormat.MCEDIT_SCHEMATIC.getPrimaryFileExtension()).exists();
        }
        return true;
    }

    public BlockArrayClipboard load(String namespace, String id) throws IOException {
        long lastCheck;
        id = id.toLowerCase(Locale.ENGLISH);
        String cacheKey = namespace + '/' + id;
        if (this.missing.containsKey(cacheKey) && (lastCheck = ((Long)this.missing.get(cacheKey)).longValue()) > System.currentTimeMillis()) {
            throw new FileNotFoundException(id);
        }
        BlockArrayClipboard copy = (BlockArrayClipboard)this.cache.get(cacheKey);
        if (copy == null) {
            File file = new File(new File(new File(plugin.getDataFolder(), "areas"), namespace), id + CopyManager.getFileSuffix());
            if (!file.exists()) {
                file = new File(new File(new File(plugin.getDataFolder(), "areas"), namespace), id + '.' + BuiltInClipboardFormat.MCEDIT_SCHEMATIC.getPrimaryFileExtension());
            }
            if (file.exists()) {
                ClipboardFormat format = ClipboardFormats.findByFile((File)file);
                if (format == null) {
                    this.missing.put(cacheKey, System.currentTimeMillis());
                    throw new IOException("Unknown clipboard format!");
                }
                try (ClipboardReader reader = format.getReader((InputStream)new FileInputStream(file));){
                    copy = (BlockArrayClipboard)reader.read();
                    this.missing.remove(cacheKey);
                    this.cache.put(cacheKey, copy);
                    BlockArrayClipboard blockArrayClipboard = copy;
                    return blockArrayClipboard;
                }
            }
            this.missing.put(cacheKey, System.currentTimeMillis());
            throw new FileNotFoundException(id);
        }
        return copy;
    }

    public void save(String namespace, String id, BlockArrayClipboard clipboard) throws IOException {
        File folder = new File(new File(plugin.getDataFolder(), "areas"), namespace);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        id = id.toLowerCase(Locale.ENGLISH);
        String cacheKey = namespace + '/' + id;
        File file = new File(folder, id + CopyManager.getFileSuffix());
        try (ClipboardWriter writer = CopyManager.getDefaultClipboardFormat().getWriter((OutputStream)new FileOutputStream(file));){
            writer.write((Clipboard)clipboard);
        }
        this.missing.remove(cacheKey);
        this.cache.put(cacheKey, clipboard);
    }

    public BlockArrayClipboard copy(Region region) throws WorldEditException {
        return this.copy(region, false, false);
    }

    public BlockArrayClipboard copy(Region region, boolean copyEntities, boolean copyBiomes) throws WorldEditException {
        BlockArrayClipboard copy = new BlockArrayClipboard(region);
        EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(region.getWorld(), -1);
        ForwardExtentCopy forwardExtentCopy = new ForwardExtentCopy((Extent)editSession, region, (Extent)copy, region.getMinimumPoint());
        forwardExtentCopy.setCopyingEntities(copyEntities);
        forwardExtentCopy.setCopyingBiomes(copyBiomes);
        Operations.complete((Operation)forwardExtentCopy);
        return copy;
    }

    public void paste(BlockArrayClipboard clipboard) throws WorldEditException {
        try (EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(clipboard.getRegion().getWorld(), -1);){
            Operation operation = new ClipboardHolder((Clipboard)clipboard).createPaste((Extent)editSession).to(clipboard.getOrigin()).copyBiomes(true).copyEntities(true).ignoreAirBlocks(false).build();
            Operations.complete((Operation)operation);
        }
    }

    public void clear(BlockArrayClipboard clipboard) {
        try (EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(clipboard.getRegion().getWorld(), -1);){
            editSession.setBlocks(clipboard.getRegion(), (BlockStateHolder)BlockTypes.AIR.getDefaultState());
        }
        catch (MaxChangedBlocksException maxChangedBlocksException) {
            // empty catch block
        }
    }

    public static int meetsQuota(String namespace, String ignore, int quota) {
        String ignoreFilename = ignore + CopyManager.getFileSuffix();
        String[] files = new File(new File(plugin.getDataFolder(), "areas"), namespace).list();
        if (files == null) {
            return quota > 0 ? -1 : 0;
        }
        if (ignore == null) {
            return files.length < quota ? -1 : files.length;
        }
        int count = 0;
        for (String f : files) {
            if (f.equals(ignoreFilename)) {
                return -1;
            }
            ++count;
        }
        return count < quota ? -1 : count;
    }

    private static ClipboardFormat getDefaultClipboardFormat() {
        return BuiltInClipboardFormat.SPONGE_SCHEMATIC;
    }

    private static String getFileSuffix() {
        return '.' + CopyManager.getDefaultClipboardFormat().getPrimaryFileExtension();
    }
}

