/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;

public class JackOLantern
extends AbstractCraftBookMechanic {
    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.isMinor()) {
            return;
        }
        if (event.getBlock().getType() != Material.CARVED_PUMPKIN && event.getBlock().getType() != Material.JACK_O_LANTERN) {
            return;
        }
        if (event.isOn() == (event.getBlock().getType() == Material.JACK_O_LANTERN)) {
            return;
        }
        JackOLantern.setPowered(event.getBlock(), event.isOn());
    }

    private static void setPowered(Block block, boolean on) {
        BlockFace data = ((Directional)block.getBlockData()).getFacing();
        block.setType(on ? Material.JACK_O_LANTERN : Material.CARVED_PUMPKIN);
        Directional directional = (Directional)block.getBlockData();
        directional.setFacing(data);
        block.setBlockData((BlockData)directional);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getBlock().getType() != Material.CARVED_PUMPKIN && event.getBlock().getType() != Material.JACK_O_LANTERN) {
            return;
        }
        if (event.getBlock().getType() == Material.JACK_O_LANTERN && (event.getBlock().isBlockIndirectlyPowered() || event.getBlock().isBlockPowered())) {
            event.setCancelled(true);
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
    }
}

