/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;

public class GlowStone
extends AbstractCraftBookMechanic {
    private BlockStateHolder offBlock;

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.isMinor()) {
            return;
        }
        if (!this.offBlock.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)event.getBlock().getBlockData())) && event.getBlock().getType() != Material.GLOWSTONE) {
            return;
        }
        if (event.isOn() == (event.getBlock().getType() == Material.GLOWSTONE)) {
            return;
        }
        if (event.isOn()) {
            event.getBlock().setType(Material.GLOWSTONE);
        } else {
            event.getBlock().setBlockData(BukkitAdapter.adapt((BlockStateHolder)this.offBlock));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!this.offBlock.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)event.getBlock().getBlockData())) && event.getBlock().getType() != Material.GLOWSTONE) {
            return;
        }
        if (event.getBlock().getType() == Material.GLOWSTONE && (event.getBlock().isBlockIndirectlyPowered() || event.getBlock().isBlockPowered())) {
            event.setCancelled(true);
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "glowstone-off-block", "Sets the block that the redstone glowstone mechanic turns into when turned off.");
        this.offBlock = BlockSyntax.getBlock(config.getString(path + "glowstone-off-block", BlockTypes.GLASS.getId()), true);
    }
}

