/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class Footprints
extends AbstractCraftBookMechanic {
    private Set<String> footsteps;
    private List<BaseBlock> blocks;

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getFrom().getX() == event.getTo().getX() && event.getFrom().getZ() == event.getTo().getZ()) {
            return;
        }
        if (!event.getPlayer().hasPermission("craftbook.mech.footprints.use")) {
            return;
        }
        Block below = event.getPlayer().getLocation().subtract(0.0, 1.0, 0.0).getBlock();
        double yOffset = 0.07;
        if (event.getPlayer().getLocation().getBlock().getType() == Material.SNOW || Tag.CARPETS.isTagged((Keyed)event.getPlayer().getLocation().getBlock().getType()) || event.getPlayer().getLocation().getBlock().getType() == Material.SOUL_SAND) {
            below = event.getPlayer().getLocation().getBlock();
            yOffset = 0.15;
            if (event.getPlayer().getLocation().getBlock().getType() == Material.SNOW && event.getPlayer().getLocation().getBlock().getData() == 0 || Tag.CARPETS.isTagged((Keyed)event.getPlayer().getLocation().getBlock().getType())) {
                yOffset = (double)below.getY() - event.getPlayer().getLocation().getY();
                yOffset += 0.15;
            }
        } else if (event.getPlayer().getLocation().getY() != (double)(below.getY() + 1)) {
            return;
        }
        if (Blocks.containsFuzzy(this.blocks, (BlockStateHolder)BukkitAdapter.adapt((BlockData)below.getBlockData()))) {
            if (this.footsteps.contains(event.getPlayer().getName())) {
                return;
            }
            try {
                for (Player play : CraftBookPlugin.inst().getServer().getOnlinePlayers()) {
                    if (play.canSee(event.getPlayer()) && play.hasPermission("craftbook.mech.footprints.see") && !play.getWorld().equals(event.getPlayer().getPlayer().getWorld())) continue;
                }
                this.footsteps.add(event.getPlayer().getName());
                CraftBookPlugin.inst().getServer().getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> this.footsteps.remove(event.getPlayer().getName()), event.getPlayer().isSprinting() ? 7L : 10L);
            }
            catch (Throwable e) {
                CraftBookPlugin.logger().log(Level.WARNING, "Failed to send footprints for " + event.getPlayer().getName(), e);
            }
        }
    }

    @Override
    public boolean enable() {
        this.footsteps = new HashSet<String>();
        return true;
    }

    @Override
    public void disable() {
        this.footsteps = null;
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "blocks", "The list of blocks that footprints appear on.");
        this.blocks = BlockSyntax.getBlocks(config.getStringList(path + "blocks", Arrays.asList(BlockTypes.DIRT.getId(), BlockTypes.SAND.getId(), BlockTypes.SNOW.getId(), BlockTypes.SNOW_BLOCK.getId(), BlockTypes.ICE.getId(), BlockTypes.RED_SAND.getId())), true);
    }
}

