/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.events.SelfTriggerPingEvent;
import com.sk89q.craftbook.util.events.SelfTriggerThinkEvent;
import com.sk89q.craftbook.util.events.SelfTriggerUnregisterEvent;
import com.sk89q.craftbook.util.events.SignClickEvent;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CookingPot
extends AbstractCraftBookMechanic {
    private HashSet<String> cookingSet = new HashSet();
    private boolean cookingPotAllowRedstone;
    private boolean cookingPotFuel;
    private boolean cookingPotOres;
    private boolean cookingPotSignOpen;
    private boolean cookingPotDestroyBuckets;
    private boolean cookingPotSuperFast;
    private boolean cookingPotChunkLimit;
    private boolean cookingPotHeating;

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.getLine(1).equalsIgnoreCase("[Cook]")) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.mech.cook")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("mech.create-permission");
            }
            SignUtil.cancelSign(event);
            return;
        }
        event.setLine(1, "[Cook]");
        event.setLine(2, "0");
        event.setLine(3, this.cookingPotFuel ? "0" : "1");
        player.print("mech.cook.create");
        CraftBookPlugin.inst().getSelfTriggerManager().registerSelfTrigger(event.getBlock().getLocation());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPing(SelfTriggerPingEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!SignUtil.isSign(event.getBlock())) {
            return;
        }
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(event.getBlock());
        if (!sign.getLine(1).equals("[Cook]")) {
            return;
        }
        if (this.cookingPotChunkLimit) {
            if (this.cookingSet.contains(event.getBlock().getChunk().getX() + ";" + event.getBlock().getChunk().getZ())) {
                return;
            }
            this.cookingSet.add(event.getBlock().getChunk().getX() + ";" + event.getBlock().getChunk().getZ());
        }
        CraftBookPlugin.inst().getSelfTriggerManager().registerSelfTrigger(event.getBlock().getLocation());
    }

    @EventHandler
    public void onUnregister(SelfTriggerUnregisterEvent event) {
        if (this.cookingPotChunkLimit) {
            this.cookingSet.remove(event.getBlock().getChunk().getX() + ";" + event.getBlock().getChunk().getZ());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onThink(SelfTriggerThinkEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!SignUtil.isSign(event.getBlock())) {
            return;
        }
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(event.getBlock());
        if (!sign.getLine(1).equals("[Cook]")) {
            return;
        }
        event.setHandled(true);
        if (this.cookingPotHeating && sign.getLine(0).equals("HEATING")) {
            if (CraftBookPlugin.inst().getRandom().nextInt(200) != 0) {
                return;
            }
            sign.setLine(0, "");
        }
        int lastTick = 0;
        try {
            lastTick = Math.max(0, Integer.parseInt(sign.getLine(2)));
        }
        catch (Exception e) {
            sign.setLine(2, String.valueOf(0));
        }
        int oldTick = lastTick;
        Block b = SignUtil.getBackBlock(event.getBlock());
        Block cb = b.getRelative(0, 2, 0);
        if (cb.getType() == Material.CHEST) {
            Block fire = b.getRelative(0, 1, 0);
            if (fire.getType() == Material.FIRE) {
                Chest chest = (Chest)cb.getState();
                Inventory inventory = chest.getInventory();
                List<ItemStack> items = this.cookingPotOres ? ItemUtil.getRawMaterials(inventory) : ItemUtil.getRawFood(inventory);
                if (items.size() == 0) {
                    if (this.cookingPotHeating) {
                        sign.setLine(0, "HEATING");
                        sign.update(false);
                    }
                    return;
                }
                if (lastTick < 500) {
                    int multiplier = this.getMultiplier(sign);
                    int n = lastTick = this.cookingPotSuperFast ? lastTick + multiplier : lastTick + Math.min(multiplier, 5);
                    if (multiplier > 0) {
                        this.setMultiplier(sign, multiplier - 1);
                    }
                }
                if (lastTick >= 50) {
                    for (ItemStack i : items) {
                        if (!ItemUtil.isStackValid(i)) continue;
                        ItemStack cooked = ItemUtil.getCookedResult(i);
                        if (cooked == null) {
                            if (!this.cookingPotOres) continue;
                            cooked = ItemUtil.getSmeletedResult(i);
                        }
                        if (!inventory.addItem(new ItemStack[]{cooked}).isEmpty()) continue;
                        ItemStack toRemove = i.clone();
                        toRemove.setAmount(1);
                        inventory.removeItem(new ItemStack[]{toRemove});
                        lastTick -= 50;
                        break;
                    }
                }
            } else {
                lastTick = 0;
            }
        }
        if (oldTick != lastTick) {
            sign.setLine(2, String.valueOf(lastTick));
            sign.update(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        ChangedSign sign = event.getSign();
        if (!sign.getLine(1).equals("[Cook]")) {
            return;
        }
        CraftBookPlugin.inst().getSelfTriggerManager().registerSelfTrigger(event.getClickedBlock().getLocation());
        CraftBookPlayer p = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Block b = SignUtil.getBackBlock(event.getClickedBlock());
            Block cb = b.getRelative(0, 2, 0);
            if (cb.getType() == Material.CHEST) {
                Player player = event.getPlayer();
                if (!player.hasPermission("craftbook.mech.cook.refuel")) {
                    if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                        p.printError("mech.restock-permission");
                    }
                    event.setCancelled(true);
                    return;
                }
                if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
                    if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                        p.printError("area.use-permissions");
                    }
                    return;
                }
                if (ItemUtil.isStackValid(player.getItemInHand()) && Ingredients.isIngredient(player.getItemInHand().getType())) {
                    Material itemID = player.getItemInHand().getType();
                    this.increaseMultiplier(sign, Ingredients.getTime(itemID));
                    if (player.getItemInHand().getAmount() <= 1) {
                        player.setItemInHand(null);
                    } else {
                        player.getItemInHand().setAmount(player.getItemInHand().getAmount() - 1);
                    }
                    if (itemID == Material.LAVA_BUCKET && !this.cookingPotDestroyBuckets) {
                        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET, 1)});
                    }
                    p.print("mech.cook.add-fuel");
                    event.setCancelled(true);
                } else if (this.cookingPotSignOpen) {
                    player.openInventory(((Chest)cb.getState()).getBlockInventory());
                    event.setCancelled(true);
                }
            }
            if (sign.hasChanged()) {
                sign.update(false);
            }
        } else {
            event.getPlayer().setFireTicks(this.getMultiplier(sign) + 40);
            CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
            player.printError("mech.cook.ouch");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockDestroy(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!SignUtil.isSign(event.getBlock())) {
            return;
        }
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(event.getBlock());
        if (!sign.getLine(1).equals("[Cook]")) {
            return;
        }
        CraftBookPlugin.inst().getSelfTriggerManager().unregisterSelfTrigger(event.getBlock().getLocation(), SelfTriggerUnregisterEvent.UnregisterReason.BREAK);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.cookingPotAllowRedstone) {
            return;
        }
        if (!SignUtil.isSign(event.getBlock())) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        ChangedSign sign = CraftBookBukkitUtil.toChangedSign(event.getBlock());
        if (!sign.getLine(1).equals("[Cook]")) {
            return;
        }
        CraftBookPlugin.inst().getSelfTriggerManager().registerSelfTrigger(event.getBlock().getLocation());
        if (event.isOn() && !event.isMinor()) {
            this.increaseMultiplier(sign, event.getNewCurrent() - event.getOldCurrent());
        }
        if (sign.hasChanged()) {
            sign.update(false);
        }
    }

    public void setMultiplier(ChangedSign sign, int amount) {
        if (!this.cookingPotFuel) {
            amount = Math.max(amount, 1);
        }
        sign.setLine(3, String.valueOf(amount));
    }

    public void increaseMultiplier(ChangedSign sign, int amount) {
        if (sign.getLine(0).equals("HEATING")) {
            sign.setLine(0, "");
        }
        this.setMultiplier(sign, this.getMultiplier(sign) + amount);
    }

    public int getMultiplier(ChangedSign sign) {
        int multiplier;
        try {
            multiplier = Integer.parseInt(sign.getLine(3));
        }
        catch (Exception e) {
            multiplier = this.cookingPotFuel ? 0 : 1;
            this.setMultiplier(sign, multiplier);
        }
        if (multiplier <= 0 && !this.cookingPotFuel) {
            return 1;
        }
        return Math.max(0, multiplier);
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "allow-redstone", "Allows for redstone to be used as a fuel source.");
        this.cookingPotAllowRedstone = config.getBoolean(path + "allow-redstone", true);
        config.setComment(path + "require-fuel", "Require fuel to cook.");
        this.cookingPotFuel = config.getBoolean(path + "require-fuel", true);
        config.setComment(path + "cook-ores", "Allows the cooking pot to cook ores and other smeltable items.");
        this.cookingPotOres = config.getBoolean(path + "cook-ores", false);
        config.setComment(path + "sign-click-open", "When enabled, right clicking the [Cook] sign will open the cooking pot.");
        this.cookingPotSignOpen = config.getBoolean(path + "sign-click-open", true);
        config.setComment(path + "take-buckets", "When enabled, lava buckets being used as fuel will consume the bucket.");
        this.cookingPotDestroyBuckets = config.getBoolean(path + "take-buckets", false);
        config.setComment(path + "super-fast-cooking", "When enabled, cooking pots cook at incredibly fast speeds. Useful for semi-instant cooking systems.");
        this.cookingPotSuperFast = config.getBoolean(path + "super-fast-cooking", false);
        this.cookingPotHeating = config.getBoolean(path + "heating", false);
        this.cookingPotChunkLimit = config.getBoolean(path + "chunk-limit", false);
    }

    private static enum Ingredients {
        COAL(Material.COAL, 40),
        COALBLOCK(Material.COAL_BLOCK, 360),
        LAVA(Material.LAVA_BUCKET, 6000),
        BLAZE(Material.BLAZE_ROD, 500),
        BLAZEDUST(Material.BLAZE_POWDER, 250),
        SNOWBALL(Material.SNOWBALL, -40),
        SNOW(Material.SNOW_BLOCK, -100),
        ICE(Material.ICE, -1000);

        private Material id;
        private int mult;

        private Ingredients(Material id, int mult) {
            this.id = id;
            this.mult = mult;
        }

        public static boolean isIngredient(Material id) {
            for (Ingredients in : Ingredients.values()) {
                if (in.id != id) continue;
                return true;
            }
            return false;
        }

        public static int getTime(Material id) {
            for (Ingredients in : Ingredients.values()) {
                if (in.id != id) continue;
                return in.mult;
            }
            return 0;
        }
    }
}

