/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.BukkitCraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ParsingUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.events.SignClickEvent;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;

public class CommandSigns
extends AbstractCraftBookMechanic {
    private boolean allowRedstone;

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.getLine(1).equalsIgnoreCase("[command]")) {
            return;
        }
        CraftBookPlayer lplayer = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!lplayer.hasPermission("craftbook.mech.command")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                lplayer.printError("mech.create-permission");
            }
            SignUtil.cancelSign(event);
            return;
        }
        event.setLine(1, "[Command]");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ChangedSign s = event.getSign();
        if (!s.getLine(1).equals("[Command]")) {
            return;
        }
        if (s.getLine(0).equals("EXPANSION")) {
            return;
        }
        CraftBookPlayer localPlayer = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!localPlayer.hasPermission("craftbook.mech.command.use")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                localPlayer.printError("mech.use-permission");
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                localPlayer.printError("area.use-permissions");
            }
            return;
        }
        CommandSigns.runCommandSign(s, localPlayer);
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!event.isOn() || event.isMinor() || !this.allowRedstone || !SignUtil.isSign(event.getBlock())) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        ChangedSign s = CraftBookBukkitUtil.toChangedSign(event.getBlock());
        if (!s.getLine(1).equals("[Command]")) {
            return;
        }
        if (s.getLine(0).equals("EXPANSION")) {
            return;
        }
        CommandSigns.runCommandSign(s, null);
    }

    public static void runCommandSign(ChangedSign sign, CraftBookPlayer player) {
        StringBuilder command = new StringBuilder(StringUtils.replace((String)sign.getLine(2), (String)"/", (String)"") + sign.getLine(3));
        while (BlockUtil.areBlocksIdentical(CraftBookBukkitUtil.toBlock(sign), CraftBookBukkitUtil.toBlock(sign).getRelative(0, -1, 0)) && (sign = CraftBookBukkitUtil.toChangedSign(CraftBookBukkitUtil.toBlock(sign).getRelative(0, -1, 0))).getLine(1).equals("[Command]") && sign.getLine(0).equals("EXPANSION")) {
            command.append(sign.getLine(2)).append(sign.getLine(3));
        }
        if (player == null && command.toString().contains("@p")) {
            return;
        }
        command = new StringBuilder(ParsingUtil.parseLine(command.toString(), player == null ? null : ((BukkitCraftBookPlayer)player).getPlayer()));
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.toString());
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "allow-redstone", "Enable CommandSigns via redstone.");
        this.allowRedstone = config.getBoolean(path + "allow-redstone", true);
    }
}

