/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.BlockUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class BetterPlants
extends AbstractCraftBookMechanic {
    private BukkitTask growthTask;
    private Set<World> tickedWorlds = new HashSet<World>();
    private boolean fernFarming;
    private boolean fastTickRandoms;

    @Override
    public boolean enable() {
        if (this.fernFarming) {
            this.tickedWorlds.addAll(Bukkit.getWorlds());
            this.growthTask = Bukkit.getScheduler().runTaskTimer((Plugin)CraftBookPlugin.inst(), (Runnable)new GrowthTicker(), 2L, 2L);
        }
        return this.fernFarming;
    }

    @Override
    public void disable() {
        this.tickedWorlds.clear();
        if (this.growthTask != null) {
            this.growthTask.cancel();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (this.fernFarming && event.getBlock().getType() == Material.LARGE_FERN && ((Bisected)event.getBlock().getBlockData()).getHalf() == Bisected.Half.TOP && event.getBlock().getRelative(0, -1, 0).getType() == Material.LARGE_FERN && ((Bisected)event.getBlock().getRelative(0, -1, 0).getBlockData()).getHalf() == Bisected.Half.BOTTOM) {
            Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
                event.getBlock().getWorld().dropItemNaturally(BlockUtil.getBlockCentre(event.getBlock()), new ItemStack(Material.FERN));
                event.getBlock().getRelative(0, -1, 0).setType(Material.FERN);
            }, 2L);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onWorldLoad(WorldLoadEvent event) {
        this.tickedWorlds.add(event.getWorld());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onWorldUnload(WorldUnloadEvent event) {
        this.tickedWorlds.remove(event.getWorld());
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "fern-farming", "Allows ferns to be farmed by breaking top half of a large fern. (And small ferns to grow)");
        this.fernFarming = config.getBoolean(path + "fern-farming", true);
        config.setComment(path + "fast-random-ticks", "Use a way of generating less random numbers, by only generating it once for all chunks, instead of one each chunk.");
        this.fastTickRandoms = config.getBoolean(path + "fast-random-ticks", true);
    }

    private class GrowthTicker
    implements Runnable {
        private GrowthTicker() {
        }

        @Override
        public void run() {
            for (World world : BetterPlants.this.tickedWorlds) {
                int x = 0;
                int y = 0;
                int z = 0;
                if (BetterPlants.this.fastTickRandoms) {
                    x = CraftBookPlugin.inst().getRandom().nextInt(16);
                    y = CraftBookPlugin.inst().getRandom().nextInt(world.getMaxHeight());
                    z = CraftBookPlugin.inst().getRandom().nextInt(16);
                }
                for (Chunk chunk : world.getLoadedChunks()) {
                    Block block = BetterPlants.this.fastTickRandoms ? chunk.getBlock(x, y, z) : chunk.getBlock(CraftBookPlugin.inst().getRandom().nextInt(16), CraftBookPlugin.inst().getRandom().nextInt(world.getMaxHeight()), CraftBookPlugin.inst().getRandom().nextInt(16));
                    if (!BetterPlants.this.fernFarming || block.getType() != Material.FERN) continue;
                    block.setType(Material.LARGE_FERN, false);
                    Bisected topHalfData = (Bisected)Material.LARGE_FERN.createBlockData();
                    topHalfData.setHalf(Bisected.Half.TOP);
                    block.getRelative(0, 1, 0).setBlockData((BlockData)topHalfData, false);
                }
            }
        }
    }
}

