/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.google.common.collect.Lists;
import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.BlockSyntax;
import com.sk89q.craftbook.util.EntityUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.InventoryUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.craftbook.util.Tuple2;
import com.sk89q.craftbook.util.events.SourcedBlockRedstoneEvent;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Piston;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class BetterPistons
extends AbstractCraftBookMechanic {
    protected static BetterPistons instance;
    private static final double movemod = 1.0;
    private int pistonMaxDistance;
    private boolean pistonsCrusher;
    private boolean pistonsCrusherInstaKill;
    private List<BaseBlock> pistonsCrusherBlacklist;
    private boolean pistonsSuperPush;
    private boolean pistonsSuperSticky;
    private List<BaseBlock> pistonsMovementBlacklist;
    private boolean pistonsBounce;
    private List<BaseBlock> pistonsBounceBlacklist;
    private double pistonBounceMaxVelocity;

    @Override
    public boolean enable() {
        instance = this;
        return true;
    }

    private static Types checkSign(Block sign) {
        Types type = null;
        if (SignUtil.isSign(sign)) {
            ChangedSign s = CraftBookBukkitUtil.toChangedSign(sign);
            switch (s.getLine(1)) {
                case "[Crush]": {
                    type = Types.CRUSH;
                    break;
                }
                case "[SuperSticky]": {
                    type = Types.SUPERSTICKY;
                    break;
                }
                case "[Bounce]": {
                    type = Types.BOUNCE;
                    break;
                }
                case "[SuperPush]": {
                    type = Types.SUPERPUSH;
                }
            }
        }
        return type != null && Types.isEnabled(type) ? type : null;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        Block block = SignUtil.getBackBlock(event.getBlock());
        Types type = null;
        if (block.getType() == Material.PISTON || block.getType() == Material.STICKY_PISTON) {
            if (event.getLine(1).equalsIgnoreCase("[Crush]") && Types.isEnabled(Types.CRUSH)) {
                event.setLine(1, "[Crush]");
                type = Types.CRUSH;
            } else if (event.getLine(1).equalsIgnoreCase("[SuperSticky]") && Types.isEnabled(Types.SUPERSTICKY)) {
                event.setLine(1, "[SuperSticky]");
                type = Types.SUPERSTICKY;
            } else if (event.getLine(1).equalsIgnoreCase("[Bounce]") && Types.isEnabled(Types.BOUNCE)) {
                event.setLine(1, "[Bounce]");
                type = Types.BOUNCE;
                double velocity = 1.0;
                try {
                    velocity = Double.parseDouble(event.getLine(2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                velocity = Math.min(Math.max(velocity, -this.pistonBounceMaxVelocity), this.pistonBounceMaxVelocity);
                event.setLine(2, String.valueOf(velocity));
            } else if (event.getLine(1).equalsIgnoreCase("[SuperPush]") && Types.isEnabled(Types.SUPERPUSH)) {
                event.setLine(1, "[SuperPush]");
                type = Types.SUPERPUSH;
            }
            if (type == null) {
                return;
            }
            if (!player.hasPermission("craftbook.mech.pistons." + type.name().toLowerCase(Locale.ENGLISH))) {
                if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                    player.printError("mech.create-permission");
                }
                SignUtil.cancelSign(event);
                return;
            }
            if (ProtectionUtil.shouldUseProtection()) {
                if (type == Types.BOUNCE || type == Types.CRUSH) {
                    Piston pis = (Piston)block.getBlockData();
                    Block off = block.getRelative(pis.getFacing());
                    if (!ProtectionUtil.canBuild(event.getPlayer(), off, false)) {
                        if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                            player.printError("area.use-permission");
                        }
                        SignUtil.cancelSign(event);
                        return;
                    }
                } else if (type == Types.SUPERPUSH || type == Types.SUPERSTICKY) {
                    Piston pis = (Piston)block.getBlockData();
                    int distance = 10;
                    try {
                        distance = Integer.parseInt(RegexUtil.MINUS_PATTERN.split(event.getLine(2))[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    distance = Math.min(this.pistonMaxDistance, distance);
                    Block off = block;
                    for (int i = 0; i < distance; ++i) {
                        off = off.getRelative(pis.getFacing());
                        if (ProtectionUtil.canBuild(event.getPlayer(), off, false)) continue;
                        if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                            player.printError("area.use-permission");
                        }
                        SignUtil.cancelSign(event);
                        return;
                    }
                }
            }
            player.print("mech.pistons." + type.name().toLowerCase(Locale.ENGLISH) + ".created");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getBlock().getType() != Material.PISTON && event.getBlock().getType() != Material.STICKY_PISTON) {
            return;
        }
        HashSet<Tuple2<Types, Block>> types = new HashSet<Tuple2<Types, Block>>();
        Piston piston = (Piston)event.getBlock().getBlockData();
        for (BlockFace face : LocationUtil.getDirectFaces()) {
            if (face == piston.getFacing()) continue;
            Block sign = event.getBlock().getRelative(face);
            if (face != BlockFace.UP && face != BlockFace.DOWN && !SignUtil.getBackBlock(sign).getLocation().equals((Object)event.getBlock().getLocation())) continue;
            Types type = BetterPistons.checkSign(sign);
            if (type != null) {
                types.add(new Tuple2<Types, Block>(type, sign));
            }
            if (type == null || !SignUtil.isSign(sign.getRelative(face)) || SignUtil.getFacing(sign.getRelative(face)) != SignUtil.getFacing(sign) || (type = BetterPistons.checkSign(sign = sign.getRelative(face))) == null) continue;
            types.add(new Tuple2<Types, Block>(type, sign));
        }
        for (Tuple2 tuple2 : types) {
            ChangedSign signState = CraftBookBukkitUtil.toChangedSign((Block)tuple2.b);
            switch ((Types)((Object)tuple2.a)) {
                case CRUSH: {
                    if (event.getNewCurrent() <= event.getOldCurrent()) break;
                    this.crush(event.getBlock(), piston, signState);
                    break;
                }
                case BOUNCE: {
                    if (event.getNewCurrent() <= event.getOldCurrent()) break;
                    this.bounce(event.getBlock(), piston, signState);
                    break;
                }
                case SUPERSTICKY: {
                    if (event.getNewCurrent() >= event.getOldCurrent()) break;
                    this.superSticky(event.getBlock(), piston, signState);
                    break;
                }
                case SUPERPUSH: {
                    if (event.getNewCurrent() <= event.getOldCurrent()) break;
                    this.superPush(event.getBlock(), piston, signState);
                }
            }
        }
    }

    public void crush(Block trigger, Piston piston, ChangedSign signState) {
        if (this.pistonsCrusherInstaKill) {
            for (Entity ent : trigger.getRelative(piston.getFacing()).getChunk().getEntities()) {
                if (!EntityUtil.isEntityInBlock(ent, trigger.getRelative(piston.getFacing()))) continue;
                EntityUtil.killEntity(ent);
            }
        }
        if (Blocks.containsFuzzy(this.pistonsCrusherBlacklist, (BlockStateHolder)BukkitAdapter.adapt((BlockData)trigger.getRelative(piston.getFacing()).getBlockData()))) {
            return;
        }
        trigger.getRelative(piston.getFacing()).breakNaturally();
        trigger.getRelative(piston.getFacing()).setType(Material.AIR, false);
    }

    public void bounce(Block trigger, Piston piston, ChangedSign signState) {
        double mult;
        if (piston.getMaterial() == Material.STICKY_PISTON) {
            return;
        }
        try {
            mult = Double.parseDouble(signState.getLine(2));
        }
        catch (Exception e) {
            mult = 1.0;
        }
        mult = Math.min(Math.max(mult, -this.pistonBounceMaxVelocity), this.pistonBounceMaxVelocity);
        Vector vel = new Vector(piston.getFacing().getModX(), piston.getFacing().getModY(), piston.getFacing().getModZ()).multiply(mult);
        if (trigger.getRelative(piston.getFacing()).getType() == Material.AIR || trigger.getRelative(piston.getFacing()).getState() != null && InventoryUtil.doesBlockHaveInventory(trigger.getRelative(piston.getFacing())) || trigger.getRelative(piston.getFacing()).getType() == Material.MOVING_PISTON || trigger.getRelative(piston.getFacing()).getType() == Material.PISTON_HEAD || Blocks.containsFuzzy(this.pistonsBounceBlacklist, (BlockStateHolder)BukkitAdapter.adapt((BlockData)trigger.getRelative(piston.getFacing()).getBlockData()))) {
            for (Entity ent : trigger.getRelative(piston.getFacing()).getChunk().getEntities()) {
                if (!EntityUtil.isEntityInBlock(ent, trigger.getRelative(piston.getFacing()))) continue;
                ent.setVelocity(ent.getVelocity().add(vel));
            }
        } else {
            FallingBlock fall = trigger.getWorld().spawnFallingBlock(trigger.getRelative(piston.getFacing()).getLocation().add(vel), trigger.getRelative(piston.getFacing()).getBlockData());
            trigger.getRelative(piston.getFacing()).setType(Material.AIR);
            fall.setVelocity(vel);
        }
    }

    public void superSticky(Block trigger, Piston piston, ChangedSign signState) {
        if (piston.getMaterial() != Material.STICKY_PISTON) {
            return;
        }
        if (trigger.getRelative(piston.getFacing()).getType() == Material.PISTON_HEAD || trigger.getRelative(piston.getFacing()).getType() == Material.MOVING_PISTON) {
            int block = 10;
            int amount = 1;
            try {
                block = Integer.parseInt(RegexUtil.MINUS_PATTERN.split(signState.getLine(2))[0]);
                if (RegexUtil.MINUS_PATTERN.split(signState.getLine(2)).length > 1) {
                    amount = Integer.parseInt(RegexUtil.MINUS_PATTERN.split(signState.getLine(2))[1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            block = Math.min(this.pistonMaxDistance, block);
            boolean air = signState.getLine(3).equalsIgnoreCase("AIR");
            int fblock = block;
            for (int p = 0; p < amount; ++p) {
                int fp = p;
                Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
                    for (int x = 1; x <= fblock + 2; ++x) {
                        int i = x;
                        if (x == 1 && !InventoryUtil.doesBlockHaveInventory(trigger.getRelative(piston.getFacing(), i)) && fp == 0) {
                            i = 2;
                            x = 2;
                        }
                        if (x >= fblock + 2 || trigger.getRelative(piston.getFacing(), i + 1).getType() == Material.AIR && !air || !this.canPistonPushBlock(trigger.getRelative(piston.getFacing(), i + 1))) {
                            trigger.getRelative(piston.getFacing(), i).setType(Material.AIR);
                            break;
                        }
                        for (Entity ent : trigger.getRelative(piston.getFacing(), i).getChunk().getEntities()) {
                            if (!EntityUtil.isEntityInBlock(ent, trigger.getRelative(piston.getFacing(), i))) continue;
                            ent.teleport(ent.getLocation().subtract((double)piston.getFacing().getModX() * 1.0, (double)piston.getFacing().getModY() * 1.0, (double)piston.getFacing().getModZ() * 1.0));
                        }
                        BetterPistons.copyData(trigger.getRelative(piston.getFacing(), i + 1), trigger.getRelative(piston.getFacing(), i));
                    }
                }, 3L * (long)(p + 1));
            }
        }
    }

    public void superPush(Block trigger, Piston piston, ChangedSign signState) {
        if (trigger.getRelative(piston.getFacing()).getType() != Material.PISTON_HEAD && trigger.getRelative(piston.getFacing()).getType() != Material.MOVING_PISTON) {
            int block = 10;
            int amount = 1;
            try {
                block = Integer.parseInt(RegexUtil.MINUS_PATTERN.split(signState.getLine(2))[0]);
                if (RegexUtil.MINUS_PATTERN.split(signState.getLine(2)).length > 1) {
                    amount = Integer.parseInt(RegexUtil.MINUS_PATTERN.split(signState.getLine(2))[1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            int fblock = block = Math.min(this.pistonMaxDistance, block);
            for (int p = 0; p < amount; ++p) {
                Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
                    for (int x = fblock + 2; x >= 1; --x) {
                        Block offset = trigger.getRelative(piston.getFacing(), x);
                        Block next = trigger.getRelative(piston.getFacing(), x + 1);
                        if (trigger.equals(offset) || offset.getType() == Material.MOVING_PISTON || offset.getType() == Material.PISTON_HEAD || !this.canPistonPushBlock(offset) || next.getType() != Material.AIR) continue;
                        for (Entity ent : next.getChunk().getEntities()) {
                            if (!EntityUtil.isEntityInBlock(ent, offset)) continue;
                            ent.teleport(ent.getLocation().add((double)piston.getFacing().getModX() * 1.0, (double)piston.getFacing().getModY() * 1.0, (double)piston.getFacing().getModZ() * 1.0));
                        }
                        if (!BetterPistons.copyData(offset, next)) continue;
                        offset.setType(Material.AIR);
                    }
                }, 3L * (long)(p + 1));
            }
        }
    }

    public static boolean copyData(Block from, Block to) {
        Powerable powerable;
        BlockState toState = to.getState();
        BlockState fromState = from.getState();
        if (fromState instanceof DoubleChest || toState instanceof DoubleChest) {
            return false;
        }
        BlockData oldBlock = from.getBlockData();
        ItemStack[] oldInventory = null;
        if (fromState instanceof InventoryHolder) {
            oldInventory = (ItemStack[])((InventoryHolder)fromState).getInventory().getContents().clone();
            ((InventoryHolder)fromState).getInventory().clear();
            from.setType(Material.AIR);
        }
        to.setBlockData(oldBlock);
        if (Tag.BUTTONS.isTagged((Keyed)to.getType()) && (powerable = (Powerable)to.getBlockData()).isPowered()) {
            powerable.setPowered(false);
        }
        if (toState instanceof Sign) {
            for (int i = 0; i < 4; ++i) {
                ((Sign)toState).setLine(i, ((Sign)fromState).getLine(i));
            }
            toState.update();
        } else if (toState instanceof InventoryHolder) {
            ((InventoryHolder)toState).getInventory().setContents(oldInventory);
        }
        return true;
    }

    private boolean canPistonPushBlock(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Chest && ((Chest)blockData).getType() != Chest.Type.SINGLE) {
            return false;
        }
        if (Blocks.containsFuzzy(this.pistonsMovementBlacklist, (BlockStateHolder)BukkitAdapter.adapt((BlockData)block.getBlockData()))) {
            return false;
        }
        return block.getType() != Material.MOVING_PISTON;
    }

    public static List<String> getDefaultBlacklist() {
        return Lists.newArrayList((Object[])new String[]{BlockTypes.OBSIDIAN.getId(), BlockTypes.BEDROCK.getId(), BlockTypes.NETHER_PORTAL.getId(), BlockTypes.END_PORTAL.getId(), BlockTypes.END_PORTAL_FRAME.getId(), BlockTypes.END_GATEWAY.getId()});
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "crushers", "Enables BetterPistons Crusher Mechanic.");
        this.pistonsCrusher = config.getBoolean(path + "crushers", true);
        config.setComment(path + "crushers-kill-mobs", "Causes crushers to kill mobs as well as break blocks. This includes players.");
        this.pistonsCrusherInstaKill = config.getBoolean(path + "crushers-kill-mobs", false);
        config.setComment(path + "crusher-blacklist", "A list of blocks that the Crusher piston can not break.");
        this.pistonsCrusherBlacklist = BlockSyntax.getBlocks(config.getStringList(path + "crusher-blacklist", BetterPistons.getDefaultBlacklist()), true);
        config.setComment(path + "super-sticky", "Enables BetterPistons SuperSticky Mechanic.");
        this.pistonsSuperSticky = config.getBoolean(path + "super-sticky", true);
        config.setComment(path + "super-push", "Enables BetterPistons SuperPush Mechanic.");
        this.pistonsSuperPush = config.getBoolean(path + "super-push", true);
        config.setComment(path + "movement-blacklist", "A list of blocks that the movement related BetterPistons can not interact with.");
        this.pistonsMovementBlacklist = BlockSyntax.getBlocks(config.getStringList(path + "movement-blacklist", BetterPistons.getDefaultBlacklist()), true);
        config.setComment(path + "bounce", "Enables BetterPistons Bounce Mechanic.");
        this.pistonsBounce = config.getBoolean(path + "bounce", true);
        config.setComment(path + "bounce-blacklist", "A list of blocks that the Bounce piston can not bounce.");
        this.pistonsBounceBlacklist = BlockSyntax.getBlocks(config.getStringList(path + "bounce-blacklist", BetterPistons.getDefaultBlacklist()), true);
        config.setComment(path + "max-distance", "The maximum distance a BetterPiston can interact with blocks from.");
        this.pistonMaxDistance = config.getInt(path + "max-distance", 12);
        config.setComment(path + "bounce-max-velocity", "The maximum velocity bounce pistons can provide.");
        this.pistonBounceMaxVelocity = config.getDouble(path + "bounce-max-velocity", 5.0);
    }

    public static enum Types {
        CRUSH,
        SUPERSTICKY,
        BOUNCE,
        SUPERPUSH;


        public static boolean isEnabled(Types type) {
            switch (type) {
                case CRUSH: {
                    return instance.pistonsCrusher;
                }
                case SUPERSTICKY: {
                    return instance.pistonsSuperSticky;
                }
                case BOUNCE: {
                    return instance.pistonsBounce;
                }
                case SUPERPUSH: {
                    return instance.pistonsSuperPush;
                }
            }
            return false;
        }
    }
}

