/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;

public class BetterPhysics
extends AbstractCraftBookMechanic {
    protected static BetterPhysics instance;
    private boolean ladders;

    @Override
    public boolean enable() {
        instance = this;
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        BetterPhysics.checkForPhysics(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        BetterPhysics.checkForPhysics(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockUpdate(BlockPhysicsEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        BetterPhysics.checkForPhysics(event.getBlock());
    }

    private static void checkForPhysics(Block block) {
        if (FallingLadders.isValid(block)) {
            Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), (Runnable)new FallingLadders(block));
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "falling-ladders", "Enables BetterPhysics Falling Ladders.");
        this.ladders = config.getBoolean(path + "falling-ladders", true);
    }

    private static class FallingLadders
    implements Runnable {
        private Block ladder;

        FallingLadders(Block ladder) {
            this.ladder = ladder;
        }

        public static boolean isValid(Block block) {
            return block.getType() == Material.LADDER && instance.ladders && block.getRelative(0, -1, 0).getType() == Material.AIR;
        }

        @Override
        public void run() {
            if (!FallingLadders.isValid(this.ladder)) {
                return;
            }
            this.ladder.getWorld().spawnFallingBlock(this.ladder.getLocation().add(0.5, 0.0, 0.5), this.ladder.getBlockData());
            this.ladder.setType(Material.AIR, false);
            BetterPhysics.checkForPhysics(this.ladder.getRelative(BlockFace.UP));
        }
    }
}

