/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.InventoryUtil;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BetterLeads
extends AbstractCraftBookMechanic {
    private boolean leadsStopTarget;
    private boolean leadsOwnerBreakOnly;
    private boolean leadsHitchPersists;
    private boolean leadsMobRepellant;
    private List<String> leadsAllowedMobs;

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerClick(PlayerInteractEntityEvent event) {
        if (!ItemUtil.isStackValid(InventoryUtil.getItemInHand(event.getPlayer(), event.getHand()))) {
            return;
        }
        if (!(event.getRightClicked() instanceof LivingEntity)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (InventoryUtil.getItemInHand(event.getPlayer(), event.getHand()).getType() != Material.LEAD) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlugin.logDebugMessage("A player has right clicked an entity with a lead!", "betterleads.allowed-mobs");
        String typeName = event.getRightClicked().getType().getName();
        if (typeName == null && event.getRightClicked().getType() == EntityType.PLAYER) {
            typeName = "PLAYER";
        } else if (typeName == null) {
            return;
        }
        CraftBookPlugin.logDebugMessage("It is of type: " + typeName, "betterleads.allowed-mobs");
        boolean found = false;
        for (String type : this.leadsAllowedMobs) {
            if (!type.equalsIgnoreCase(typeName)) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        CraftBookPlugin.logDebugMessage(typeName + " is allowed in the configuration.", "betterleads.allowed-mobs");
        if (!player.hasPermission("craftbook.mech.leads") && !player.hasPermission("craftbook.mech.leads.mobs." + typeName.toLowerCase())) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("mech.use-permission");
            }
            return;
        }
        CraftBookPlugin.logDebugMessage("Leashing entity!", "betterleads.allowed-mobs");
        if (event.getRightClicked() instanceof Creature && ((Creature)event.getRightClicked()).getTarget() != null && ((Creature)event.getRightClicked()).getTarget().equals(event.getPlayer())) {
            ((Creature)event.getRightClicked()).setTarget(null);
        }
        event.setCancelled(true);
        Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> {
            if (!((LivingEntity)event.getRightClicked()).setLeashHolder((Entity)event.getPlayer())) {
                CraftBookPlugin.logDebugMessage("Failed to leash entity!", "betterleads.allowed-mobs");
            }
        });
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (InventoryUtil.getItemInHand(event.getPlayer(), event.getHand()).getAmount() == 1) {
            InventoryUtil.setItemInHand(event.getPlayer(), event.getHand(), null);
        } else {
            ItemStack newStack = InventoryUtil.getItemInHand(event.getPlayer(), event.getHand());
            newStack.setAmount(newStack.getAmount() - 1);
            InventoryUtil.setItemInHand(event.getPlayer(), event.getHand(), newStack);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityTarget(EntityTargetEvent event) {
        if (!this.leadsStopTarget && !this.leadsMobRepellant) {
            return;
        }
        if (!(event.getEntity() instanceof Monster)) {
            return;
        }
        if (!((LivingEntity)event.getEntity()).isLeashed()) {
            return;
        }
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer((Player)event.getTarget());
        if (this.leadsStopTarget && player.hasPermission("craftbook.mech.leads.ignore-target") && ((LivingEntity)event.getEntity()).getLeashHolder().equals(event.getTarget())) {
            event.setTarget(null);
            event.setCancelled(true);
            return;
        }
        if (this.leadsMobRepellant && player.hasPermission("craftbook.mech.leads.mob-repel")) {
            for (Entity ent : event.getTarget().getNearbyEntities(5.0, 5.0, 5.0)) {
                if (ent == null || !ent.isValid() || ent.getType() != event.getEntity().getType() || !((LivingEntity)ent).getLeashHolder().equals(event.getTarget())) continue;
                event.setTarget(null);
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onHitchBreakRandomly(HangingBreakEvent event) {
        if (!this.leadsHitchPersists) {
            return;
        }
        if (!(event.getEntity() instanceof LeashHitch)) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        int amountConnected = 0;
        for (Entity ent : event.getEntity().getNearbyEntities(10.0, 10.0, 10.0)) {
            if (!(ent instanceof LivingEntity) || !((LivingEntity)ent).isLeashed() || !((LivingEntity)ent).getLeashHolder().equals(event.getEntity())) continue;
            ++amountConnected;
        }
        if (amountConnected == 0) {
            Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> ((Hanging)event.getEntity()).remove());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onHitchBreak(HangingBreakByEntityEvent event) {
        if (!this.leadsHitchPersists && !this.leadsOwnerBreakOnly) {
            return;
        }
        if (!(event.getEntity() instanceof LeashHitch)) {
            return;
        }
        if (!(event.getRemover() instanceof Player)) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        event.setCancelled(true);
        int amountConnected = 0;
        for (Entity ent : event.getEntity().getNearbyEntities(10.0, 10.0, 10.0)) {
            if (!(ent instanceof LivingEntity) || !((LivingEntity)ent).isLeashed() || !((LivingEntity)ent).getLeashHolder().equals(event.getEntity())) continue;
            boolean isOwner = false;
            if (ent instanceof Tameable && (!((Tameable)ent).isTamed() || ((Tameable)ent).getOwner().equals(event.getRemover()))) {
                isOwner = true;
            }
            if (isOwner || !(ent instanceof Tameable) || !this.leadsOwnerBreakOnly || event.getRemover().hasPermission("craftbook.mech.leads.owner-break-only.bypass")) {
                ((LivingEntity)ent).setLeashHolder(null);
                event.getEntity().getWorld().dropItemNaturally(event.getEntity().getLocation(), new ItemStack(Material.LEAD, 1));
                continue;
            }
            ++amountConnected;
        }
        if (!this.leadsHitchPersists && amountConnected == 0) {
            Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> ((Hanging)event.getEntity()).remove());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onUnleash(PlayerUnleashEntityEvent event) {
        if (!this.leadsOwnerBreakOnly) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!((LivingEntity)event.getEntity()).isLeashed() || !(((LivingEntity)event.getEntity()).getLeashHolder() instanceof LeashHitch)) {
            return;
        }
        if (!(event.getEntity() instanceof Tameable)) {
            return;
        }
        if (!((Tameable)event.getEntity()).isTamed()) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!((Tameable)event.getEntity()).getOwner().equals(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "stop-mob-target", "Stop hostile mobs targeting you if you are holding them on a leash.");
        this.leadsStopTarget = config.getBoolean(path + "stop-mob-target", false);
        config.setComment(path + "owner-unleash-only", "Only allow the owner of tameable entities to unleash them from a leash hitch.");
        this.leadsOwnerBreakOnly = config.getBoolean(path + "owner-unleash-only", false);
        config.setComment(path + "hitch-persists", "Stop leash hitches breaking when clicked no entities are attached. This allows for a public horse hitch or similar.");
        this.leadsHitchPersists = config.getBoolean(path + "hitch-persists", false);
        config.setComment(path + "mob-repel", "If you have a mob tethered to you, mobs of that type will not target you.");
        this.leadsMobRepellant = config.getBoolean(path + "mob-repel", false);
        config.setComment(path + "allowed-mobs", "The list of mobs that can be tethered with a lead.");
        this.leadsAllowedMobs = config.getStringList(path + "allowed-mobs", Arrays.asList("ZOMBIE", "SPIDER"));
    }
}

