/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mechanics;

import com.sk89q.craftbook.AbstractCraftBookMechanic;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.ItemSyntax;
import com.sk89q.craftbook.util.ProtectionUtil;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.AnaloguePowerable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Powerable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class Ammeter
extends AbstractCraftBookMechanic {
    private ItemType item;

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (player.getItemInHand(HandSide.MAIN_HAND).getType() != this.item) {
            return;
        }
        if (!player.hasPermission("craftbook.mech.ammeter.use")) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("mech.use-permission");
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBookPlugin.inst().getConfiguration().showPermissionMessages) {
                player.printError("area.use-permissions");
            }
            return;
        }
        Block block = event.getClickedBlock();
        int data = Ammeter.getSpecialData(block);
        if (data >= 0) {
            String line = Ammeter.getCurrentLine(data);
            player.print(player.translate("mech.ammeter.ammeter") + ": " + line + ChatColor.WHITE + ' ' + data + " A");
            event.setCancelled(true);
        }
    }

    private static int getSpecialData(Block block) {
        BlockData blockData = block.getBlockData();
        int current = -1;
        if (blockData instanceof Powerable) {
            current = ((Powerable)blockData).isPowered() ? 15 : 0;
        } else if (blockData instanceof AnaloguePowerable) {
            current = ((AnaloguePowerable)blockData).getPower();
        } else if (blockData instanceof Lightable) {
            current = ((Lightable)blockData).isLit() ? 15 : 0;
        } else if (block.getType() == Material.REDSTONE_BLOCK) {
            current = 15;
        }
        return current;
    }

    private static String getCurrentLine(int data) {
        int i;
        StringBuilder line = new StringBuilder(25);
        line.append(ChatColor.YELLOW).append('[');
        if (data > 10) {
            line.append(ChatColor.DARK_GREEN);
        } else if (data > 5) {
            line.append(ChatColor.GOLD);
        } else if (data > 0) {
            line.append(ChatColor.DARK_RED);
        }
        for (i = 0; i < data; ++i) {
            line.append('|');
        }
        line.append(ChatColor.BLACK);
        for (i = data; i < 15; ++i) {
            line.append('|');
        }
        line.append(ChatColor.YELLOW).append(']');
        return line.toString();
    }

    @Override
    public void loadConfiguration(YAMLProcessor config, String path) {
        config.setComment(path + "item", "Set the item that is the ammeter tool.");
        this.item = BukkitAdapter.asItemType((Material)ItemSyntax.getItem(config.getString(path + "item", ItemTypes.COAL.getId())).getType());
    }
}

