/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.core.st;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.bukkit.util.CraftBookBukkitUtil;
import com.sk89q.craftbook.util.EventUtil;
import com.sk89q.craftbook.util.events.SelfTriggerPingEvent;
import com.sk89q.craftbook.util.events.SelfTriggerThinkEvent;
import com.sk89q.craftbook.util.events.SelfTriggerUnregisterEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

public class SelfTriggeringManager
implements Listener {
    private final Collection<Location> thinkingMechanics = new HashSet<Location>();
    private Location[] registeredLocations;
    private boolean hasChanged = false;

    public void registerSelfTrigger(Chunk chunk) {
        block4: {
            if (!chunk.getWorld().isChunkLoaded(chunk)) {
                return;
            }
            try {
                for (BlockState state : chunk.getTileEntities()) {
                    if (!(state instanceof Sign) || this.thinkingMechanics.contains(state.getLocation())) continue;
                    SelfTriggerPingEvent event = new SelfTriggerPingEvent(state.getBlock());
                    Bukkit.getServer().getPluginManager().callEvent((Event)event);
                }
            }
            catch (Throwable e) {
                Bukkit.getLogger().warning("A corrupt tile entity was found in the chunk: (world: " + chunk.getWorld().getName() + " x: " + chunk.getX() + " z: " + chunk.getZ() + ") Self-Triggering mechanics may not work here until the issue is resolved.");
                if (!CraftBookPlugin.inst().getConfiguration().debugMode) break block4;
                CraftBookBukkitUtil.printStacktrace(e);
            }
        }
    }

    public void registerSelfTrigger(Location location) {
        if (this.thinkingMechanics.contains(location)) {
            return;
        }
        this.hasChanged = true;
        this.thinkingMechanics.add(location);
    }

    public void unregisterSelfTrigger(Location location, SelfTriggerUnregisterEvent.UnregisterReason reason) {
        if (this.thinkingMechanics.isEmpty()) {
            return;
        }
        if (!this.thinkingMechanics.contains(location)) {
            return;
        }
        SelfTriggerUnregisterEvent event = new SelfTriggerUnregisterEvent(location.getBlock(), reason);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.hasChanged = true;
            this.thinkingMechanics.remove(location);
            CraftBookPlugin.logDebugMessage("Unregistered ST at: " + location.toString() + " for reason: " + reason.name(), "st.unregister");
        }
    }

    public void unregisterSelfTrigger(Chunk chunk) {
        if (this.thinkingMechanics.isEmpty()) {
            return;
        }
        if (this.hasChanged || this.registeredLocations == null) {
            this.registeredLocations = this.thinkingMechanics.toArray(new Location[this.thinkingMechanics.size()]);
        }
        for (Location location : this.registeredLocations) {
            if (!location.getChunk().equals(chunk)) continue;
            this.unregisterSelfTrigger(location, SelfTriggerUnregisterEvent.UnregisterReason.UNLOAD);
        }
    }

    public Collection<Location> getSelfTriggeringMechanics() {
        return new ArrayList<Location>(this.thinkingMechanics);
    }

    public void think() {
        if (this.thinkingMechanics.isEmpty()) {
            return;
        }
        if (this.hasChanged || this.registeredLocations == null) {
            this.registeredLocations = this.thinkingMechanics.toArray(new Location[this.thinkingMechanics.size()]);
        }
        for (Location location : this.registeredLocations) {
            if (!location.getWorld().isChunkLoaded(location.getBlockX() >> 4, location.getBlockZ() >> 4)) {
                this.unregisterSelfTrigger(location, SelfTriggerUnregisterEvent.UnregisterReason.UNLOAD);
                continue;
            }
            try {
                SelfTriggerThinkEvent event = new SelfTriggerThinkEvent(location.getBlock());
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (event.isHandled()) continue;
                this.unregisterSelfTrigger(location, SelfTriggerUnregisterEvent.UnregisterReason.NOT_HANDLED);
            }
            catch (Throwable t) {
                CraftBookPlugin.logger().log(Level.WARNING, "CraftBook mechanic: Failed to think for " + location.toString());
                CraftBookBukkitUtil.printStacktrace(t);
                this.unregisterSelfTrigger(location, SelfTriggerUnregisterEvent.UnregisterReason.ERROR);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlugin.server().getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> this.registerSelfTrigger(event.getChunk()), 2L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.unregisterSelfTrigger(event.getChunk());
    }
}

