/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.core;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;

public class LanguageManager {
    private Map<String, YAMLProcessor> languageMap = new HashMap<String, YAMLProcessor>();
    public static final HashMap<String, String> defaultMessages = new HashMap<String, String>(32, 1.0f){
        {
            this.put("area.permissions", "You don't have permissions to do that in this area!");
            this.put("area.use-permissions", "You don't have permissions to use that in this area!");
            this.put("area.break-permissions", "You don't have permissions to break that in this area!");
            this.put("variable.missing", "This variable is missing!");
            this.put("variable.use-permissions", "You don't have permission to use that variable!");
            this.put("mech.create-permission", "You don't have permission to create this mechanic.");
            this.put("mech.use-permission", "You don't have permission to use this mechanic.");
            this.put("mech.restock-permission", "You don't have permission to restock this mechanic.");
            this.put("mech.not-enough-blocks", "Not enough blocks to trigger mechanic!");
            this.put("mech.group", "You are not in the required group!");
            this.put("mech.restock", "Mechanism Restocked!");
            this.put("mech.ammeter.ammeter", "Ammeter");
            this.put("mech.bounceblocks.create", "BounceBlock Created!");
            this.put("mech.bounceblocks.invalid-velocity", "You need to enter a valid velocity on the 3rd line!");
            this.put("mech.anchor.create", "Chunk Anchor Created!");
            this.put("mech.anchor.already-anchored", "This chunk is already anchored!");
            this.put("mech.area.create", "Toggle Area Created!");
            this.put("mech.area.missing", "The area or namespace does not exist.");
            this.put("mech.bookcase.fail-line", "Failed to fetch a line from the books file.");
            this.put("mech.bookcase.fail-file", "Failed to read the books file.");
            this.put("mech.bookcase.read-line", "You pick up a book...");
            this.put("mech.bridge.create", "Bridge Created!");
            this.put("mech.bridge.toggle", "Bridge Toggled!");
            this.put("mech.bridge.end-create", "Bridge End Created!");
            this.put("mech.bridge.unusable", "Material not usable for a bridge!");
            this.put("mech.bridge.material", "Bridge must be made entirely out of the same material!");
            this.put("mech.bridge.other-sign", "Bridge sign required on other side (or it was too far away).");
            this.put("mech.cauldron.create", "Cauldron Created!");
            this.put("mech.cauldron.too-small", "Cauldron is too small!");
            this.put("mech.cauldron.leaky", "Cauldron has a leak!");
            this.put("mech.cauldron.no-lava", "Cauldron lacks lava!");
            this.put("mech.cauldron.legacy-not-a-recipe", "Hmm, this doesn't make anything...");
            this.put("mech.cauldron.legacy-not-in-group", "Doesn't seem as if you have the ability...");
            this.put("mech.cauldron.legacy-create", "In a poof of smoke, you've made");
            this.put("mech.cauldron.stir", "You stir the cauldron but nothing happens.");
            this.put("mech.cauldron.permissions", "You dont have permission to cook this recipe.");
            this.put("mech.cauldron.cook", "You have cooked the recipe:");
            this.put("mech.chairs.sit", "You are now sitting!");
            this.put("mech.chairs.stand", "You are no longer sitting!");
            this.put("mech.chairs.in-use", "This chair is in use!");
            this.put("mech.chairs.floating", "This chair has nothing below it!");
            this.put("mech.chairs.too-far", "This chair is too far away!");
            this.put("mech.chairs.obstructed", "This chair is obstructed!");
            this.put("mech.command.create", "Command Sign Created!");
            this.put("mech.command-items.out-of-sync", "Inventory became out of sync during usage of command-items!");
            this.put("mech.command-items.wait", "You have to wait %time% seconds to use this again!");
            this.put("mech.command-items.need", "You need %item% to use this command!");
            this.put("mech.cook.create", "Cooking Pot Created!");
            this.put("mech.cook.ouch", "Ouch! That was hot!");
            this.put("mech.cook.add-fuel", "You put fuel into the cooking pot, and watch as the fire roars!");
            this.put("mech.custom-crafting.recipe-permission", "You do not have permission to craft this recipe.");
            this.put("mech.door.create", "Door Created!");
            this.put("mech.door.toggle", "Door Toggled!");
            this.put("mech.door.other-sign", "Door sign required on other side (or it was too far away).");
            this.put("mech.door.unusable", "Material not usable for a door!");
            this.put("mech.door.material", "Door must be made entirely out of the same material!");
            this.put("mech.gate.create", "Gate Created!");
            this.put("mech.gate.toggle", "Gate Toggled!");
            this.put("mech.gate.not-found", "Failed to find a gate!");
            this.put("mech.gate.valid-item", "Line 1 needs to be a valid block id.");
            this.put("mech.dgate.create", "Small Gate Created!");
            this.put("mech.hiddenswitch.key", "The key did not fit!");
            this.put("mech.hiddenswitch.toggle", "You hear the muffled click of a switch!");
            this.put("mech.headdrops.click-message", "This is the dismembered head of..");
            this.put("mech.headdrops.break-permission", "You don't have permission to break heads!");
            this.put("mech.lift.target-sign-created", "Elevator target sign created.");
            this.put("mech.lift.down-sign-created", "Elevator down sign created.");
            this.put("mech.lift.up-sign-created", "Elevator up sign created.");
            this.put("mech.lift.obstruct", "Your destination is obstructed!");
            this.put("mech.lift.no-floor", "There is no floor at your destination!");
            this.put("mech.lift.floor", "Floor");
            this.put("mech.lift.up", "You went up a floor!");
            this.put("mech.lift.down", "You went down a floor!");
            this.put("mech.lift.leave", "You have left the elevator!");
            this.put("mech.lift.no-destination", "This lift has no destination.");
            this.put("mech.lift.no-depart", "Cannot depart from this lift (can only arrive).");
            this.put("mech.lift.busy", "Elevator Busy!");
            this.put("mech.lightstone.lightstone", "LightStone:");
            this.put("mech.lightswitch.create", "Light Switch Created!");
            this.put("mech.map.create", "Map Changer Created!");
            this.put("mech.map.invalid", "Invalid Map ID!");
            this.put("mech.painting.editing", "You are now editing this painting!");
            this.put("mech.painting.stop", "You are no longer editing this painting!");
            this.put("mech.painting.used", "This painting is already being edited by");
            this.put("mech.painting.range", "You are too far away from the painting!");
            this.put("mech.pay.create", "Pay Created!");
            this.put("mech.pay.success", "Payment Successful! You paid: ");
            this.put("mech.pay.not-enough-money", "Payment Failed! You don't have enough money.");
            this.put("mech.pay.failed-to-pay", "Payment Failed! The money failed to be exchanged.");
            this.put("mech.pistons.crush.created", "Piston Crush Mechanic Created!");
            this.put("mech.pistons.supersticky.created", "Piston Super-Sticky Mechanic Created!");
            this.put("mech.pistons.bounce.created", "Piston Bounce Mechanic Created!");
            this.put("mech.pistons.superpush.created", "Piston Super-Push Mechanic Created!");
            this.put("mech.signcopy.copy", "You have copied the sign!");
            this.put("mech.signcopy.paste", "You have pasted the sign!");
            this.put("mech.teleport.create", "Teleporter Created!");
            this.put("mech.teleport.alert", "You Teleported!");
            this.put("mech.teleport.range", "Out of Range!");
            this.put("mech.teleport.sign", "There is no Sign at your Destination!");
            this.put("mech.teleport.arriveonly", "You can only arrive at this teleporter!");
            this.put("mech.teleport.invalidcoords", "The entered coordinates are invalid!");
            this.put("mech.teleport.obstruct", "Your destination is obstructed!");
            this.put("mech.xp-storer.create", "XP Storer Created!");
            this.put("mech.xp-storer.bottle", "You need a bottle to perform this mechanic!");
            this.put("mech.xp-storer.success", "You package your experience into a bottle!");
            this.put("mech.xp-storer.not-enough-xp", "You do not have enough experience to fill a bottle!");
            this.put("circuits.pipes.create", "Pipe created!");
            this.put("circuits.pipes.pipe-not-found", "Failed to find pipe!");
            this.put("vehicles.create-permission", "You don't have permissions to create this vehicle mechanic!");
            this.put("worldedit.ic.unsupported", "WorldEdit selection type currently unsupported for IC's!");
            this.put("worldedit.ic.notfound", "WorldEdit not found!");
            this.put("worldedit.ic.noselection", "No selection was found!");
        }
    };

    public void init() {
        this.checkForLanguages();
    }

    public void close() {
    }

    private void checkForLanguages() {
        for (String language : CraftBookPlugin.inst().getConfiguration().languages) {
            language = language.trim();
            File f = new File(CraftBookPlugin.inst().getDataFolder(), language + ".yml");
            if (!f.exists()) {
                try {
                    f.createNewFile();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            YAMLProcessor lang = new YAMLProcessor(f, true, YAMLFormat.EXTENDED);
            try {
                lang.load();
            }
            catch (Throwable e) {
                CraftBookPlugin.inst().getLogger().severe("An error occured loading the languages file for: " + language + "! This language WILL NOT WORK UNTIL FIXED!");
                e.printStackTrace();
                continue;
            }
            lang.setWriteDefaults(true);
            for (Map.Entry<String, String> s : defaultMessages.entrySet()) {
                lang.getString(s.getKey(), s.getValue());
            }
            lang.save();
            this.languageMap.put(language.toLowerCase(), lang);
        }
    }

    public String getString(String message, String language) {
        if (language == null || !this.languageMap.containsKey(language.toLowerCase())) {
            language = CraftBookPlugin.inst().getConfiguration().language;
        }
        YAMLProcessor languageData = this.languageMap.get(language.toLowerCase());
        String def = defaultMessages.get(message);
        if (languageData == null) {
            if (!CraftBookPlugin.inst().getConfiguration().languageScanText || def != null) {
                return def == null ? message : def;
            }
            String trans = message;
            for (Map.Entry<String, String> tran : defaultMessages.entrySet()) {
                trans = StringUtils.replace((String)trans, (String)tran.getKey(), (String)tran.getValue());
            }
            return trans;
        }
        String translated = def == null || languageData.getString(message) != null ? languageData.getString(message) : languageData.getString(message, def);
        if (!CraftBookPlugin.inst().getConfiguration().languageScanText || translated != null) {
            if (translated != null) {
                return translated;
            }
            return def == null ? message : def;
        }
        String trans = message;
        for (String tran : languageData.getMap().keySet()) {
            String trand;
            String string = trand = defaultMessages.get(tran) != null ? languageData.getString(tran, defaultMessages.get(tran)) : languageData.getString(tran);
            if (tran == null || trand == null) continue;
            trans = StringUtils.replace((String)trans, (String)tran, (String)trand);
        }
        return trans;
    }

    public static String getPlayersLanguage(Player p) {
        return p.getLocale();
    }

    public Set<String> getLanguages() {
        return this.languageMap.keySet();
    }
}

