/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit.util;

import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.minecraft.util.commands.CommandException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public final class PlayerUtil {
    public static Player checkPlayer(CommandSender sender) throws CommandException {
        if (sender instanceof Player) {
            return (Player)sender;
        }
        throw new CommandException("A player context is required. (Specify a world or player if the command supports it.)");
    }

    public static List<Player> matchPlayerNames(String filter) {
        Collection players = CraftBookPlugin.inst().getServer().getOnlinePlayers();
        boolean useDisplayNames = true;
        if ((filter = filter.toLowerCase(Locale.ENGLISH)).charAt(0) == '@' && filter.length() >= 2) {
            filter = filter.substring(1);
            for (Player player : players) {
                if (!player.getName().equalsIgnoreCase(filter) && (!useDisplayNames || !ChatColor.stripColor((String)player.getDisplayName()).equalsIgnoreCase(filter))) continue;
                ArrayList<Player> list = new ArrayList<Player>();
                list.add(player);
                return list;
            }
            return new ArrayList<Player>();
        }
        if (filter.charAt(0) == '*' && filter.length() >= 2) {
            filter = filter.substring(1);
            ArrayList<Player> list = new ArrayList<Player>();
            for (Player player : players) {
                if (!player.getName().toLowerCase(Locale.ENGLISH).contains(filter) && (!useDisplayNames || !ChatColor.stripColor((String)player.getDisplayName().toLowerCase(Locale.ENGLISH)).contains(filter))) continue;
                list.add(player);
            }
            return list;
        }
        ArrayList<Player> list = new ArrayList<Player>();
        for (Player player : players) {
            if (!player.getName().toLowerCase(Locale.ENGLISH).startsWith(filter) && (!useDisplayNames || !ChatColor.stripColor((String)player.getDisplayName().toLowerCase(Locale.ENGLISH)).startsWith(filter))) continue;
            list.add(player);
        }
        return list;
    }

    protected static Iterable<? extends Player> checkPlayerMatch(Collection<? extends Player> players) throws CommandException {
        if (players.isEmpty()) {
            throw new CommandException("No players matched query.");
        }
        return players;
    }

    public static Iterable<? extends Player> matchPlayers(CommandSender source, String filter) throws CommandException {
        if (CraftBookPlugin.server().getOnlinePlayers().size() == 0) {
            throw new CommandException("No players matched query.");
        }
        if (filter.equals("*")) {
            return PlayerUtil.checkPlayerMatch(CraftBookPlugin.server().getOnlinePlayers());
        }
        if (filter.charAt(0) == '#') {
            if (filter.equalsIgnoreCase("#world")) {
                ArrayList<Player> players = new ArrayList<Player>();
                Player sourcePlayer = PlayerUtil.checkPlayer(source);
                World sourceWorld = sourcePlayer.getWorld();
                for (Player player : CraftBookPlugin.server().getOnlinePlayers()) {
                    if (!player.getWorld().equals(sourceWorld)) continue;
                    players.add(player);
                }
                return PlayerUtil.checkPlayerMatch(players);
            }
            if (filter.equalsIgnoreCase("#near")) {
                ArrayList<Player> players = new ArrayList<Player>();
                Player sourcePlayer = PlayerUtil.checkPlayer(source);
                for (Player player : CraftBookPlugin.server().getOnlinePlayers()) {
                    if (!player.getWorld().equals(sourcePlayer.getWorld()) || !(LocationUtil.getDistanceSquared(player.getLocation(), sourcePlayer.getLocation()) < 900.0)) continue;
                    players.add(player);
                }
                return PlayerUtil.checkPlayerMatch(players);
            }
            throw new CommandException("Invalid group '" + filter + "'.");
        }
        List<Player> players = PlayerUtil.matchPlayerNames(filter);
        return PlayerUtil.checkPlayerMatch(players);
    }

    public static Player matchPlayerExactly(CommandSender sender, String filter) throws CommandException {
        Collection players = CraftBookPlugin.server().getOnlinePlayers();
        for (Player player : players) {
            if (!player.getName().equalsIgnoreCase(filter) && !player.getDisplayName().equalsIgnoreCase(filter)) continue;
            return player;
        }
        throw new CommandException("No player found!");
    }

    public static Player matchSinglePlayer(CommandSender sender, String filter) throws CommandException {
        Iterator<? extends Player> players = PlayerUtil.matchPlayers(sender, filter).iterator();
        Player match = players.next();
        if (players.hasNext()) {
            throw new CommandException("More than one player found! Use @<name> for exact matching.");
        }
        return match;
    }

    public static CommandSender matchPlayerOrConsole(CommandSender sender, String filter) throws CommandException {
        if (filter.equalsIgnoreCase("#console") || filter.equalsIgnoreCase("*console*") || filter.equals("!")) {
            return CraftBookPlugin.server().getConsoleSender();
        }
        return PlayerUtil.matchSinglePlayer(sender, filter);
    }

    public static Iterable<Player> matchPlayers(Player player) {
        return Collections.singletonList(player);
    }

    public static String toName(CommandSender sender) {
        return ChatColor.stripColor((String)PlayerUtil.toColoredName(sender, null));
    }

    public static String toColoredName(CommandSender sender, ChatColor endColor) {
        if (sender instanceof Player) {
            String name = ((Player)sender).getDisplayName();
            if (endColor != null && name.contains("\u00a7")) {
                name = name + endColor;
            }
            return name;
        }
        if (sender instanceof ConsoleCommandSender) {
            return "*Console*";
        }
        return sender.getName();
    }

    public static String toUniqueName(CommandSender sender) {
        if (sender instanceof Player) {
            return sender.getName();
        }
        return "*Console*";
    }
}

