/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit.util;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.world.World;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.util.Vector;

public final class CraftBookBukkitUtil {
    public static final double EQUALS_PRECISION = 1.0E-4;
    private static Set<Material> isRedstoneBlock = new HashSet<Material>();

    public static void printStacktrace(Throwable e) {
        CraftBookPlugin.inst().getLogger().severe(CraftBookPlugin.getStackTrace(e));
    }

    public static ChangedSign toChangedSign(Block sign) {
        return CraftBookBukkitUtil.toChangedSign(sign, null);
    }

    public static ChangedSign toChangedSign(Block block, String[] lines) {
        return CraftBookBukkitUtil.toChangedSign(block, lines, null);
    }

    public static ChangedSign toChangedSign(Block block, String[] lines, CraftBookPlayer player) {
        return CraftBookPlugin.inst().getNmsAdapter().getChangedSign(block, lines, player);
    }

    public static Block toBlock(ChangedSign sign) {
        return sign.getBlock();
    }

    public static Sign toSign(ChangedSign sign) {
        try {
            if (sign.hasChanged()) {
                sign.update(false);
            }
            return sign.getSign();
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public static BlockVector3 toVector(Block block) {
        return BlockVector3.at((int)block.getX(), (int)block.getY(), (int)block.getZ());
    }

    public static BlockVector3 toVector(BlockFace face) {
        return BlockVector3.at((int)face.getModX(), (int)face.getModY(), (int)face.getModZ());
    }

    public static Vector3 toVector(Location loc) {
        return Vector3.at((double)loc.getX(), (double)loc.getY(), (double)loc.getZ());
    }

    public static Vector3 toVector(Vector vector) {
        return Vector3.at((double)vector.getX(), (double)vector.getY(), (double)vector.getZ());
    }

    public static Location toLocation(org.bukkit.World world, Vector3 pt) {
        return new Location(world, pt.getX(), pt.getY(), pt.getZ());
    }

    public static Location center(Location loc) {
        return new Location(loc.getWorld(), (double)loc.getBlockX() + 0.5, (double)loc.getBlockY() + 0.5, (double)loc.getBlockZ() + 0.5, loc.getPitch(), loc.getYaw());
    }

    public static boolean equals(Location a, Location b) {
        return Math.abs(a.getX() - b.getX()) <= 1.0E-4 && Math.abs(a.getY() - b.getY()) <= 1.0E-4 && Math.abs(a.getZ() - b.getZ()) <= 1.0E-4;
    }

    public static Location toLocation(com.sk89q.worldedit.util.Location teleportLocation) {
        return new Location(CraftBookBukkitUtil.toWorld((World)teleportLocation.getExtent()), teleportLocation.getX(), teleportLocation.getY(), teleportLocation.getZ(), teleportLocation.getYaw(), teleportLocation.getPitch());
    }

    public static org.bukkit.World toWorld(World world) {
        return ((BukkitWorld)world).getWorld();
    }

    public static boolean isRedstoneBlock(Material id) {
        return isRedstoneBlock.contains(id);
    }

    static {
        isRedstoneBlock.add(Material.POWERED_RAIL);
        isRedstoneBlock.add(Material.DETECTOR_RAIL);
        isRedstoneBlock.add(Material.STICKY_PISTON);
        isRedstoneBlock.add(Material.PISTON);
        isRedstoneBlock.add(Material.LEVER);
        isRedstoneBlock.add(Material.STONE_PRESSURE_PLATE);
        isRedstoneBlock.addAll(Tag.WOODEN_PRESSURE_PLATES.getValues());
        isRedstoneBlock.add(Material.REDSTONE_TORCH);
        isRedstoneBlock.add(Material.REDSTONE_WALL_TORCH);
        isRedstoneBlock.add(Material.REDSTONE_WIRE);
        isRedstoneBlock.addAll(Tag.DOORS.getValues());
        isRedstoneBlock.add(Material.TNT);
        isRedstoneBlock.add(Material.DISPENSER);
        isRedstoneBlock.add(Material.NOTE_BLOCK);
        isRedstoneBlock.add(Material.REPEATER);
        isRedstoneBlock.add(Material.TRIPWIRE_HOOK);
        isRedstoneBlock.add(Material.COMMAND_BLOCK);
        isRedstoneBlock.addAll(Tag.BUTTONS.getValues());
        isRedstoneBlock.add(Material.TRAPPED_CHEST);
        isRedstoneBlock.add(Material.HEAVY_WEIGHTED_PRESSURE_PLATE);
        isRedstoneBlock.add(Material.LIGHT_WEIGHTED_PRESSURE_PLATE);
        isRedstoneBlock.add(Material.COMPARATOR);
        isRedstoneBlock.add(Material.REDSTONE_BLOCK);
        isRedstoneBlock.add(Material.HOPPER);
        isRedstoneBlock.add(Material.ACTIVATOR_RAIL);
        isRedstoneBlock.add(Material.DROPPER);
        isRedstoneBlock.add(Material.DAYLIGHT_DETECTOR);
        isRedstoneBlock = EnumSet.copyOf(isRedstoneBlock);
    }
}

